/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.CheckerSeverity;
import chemaxon.checkers.MissingAtomMapChecker;
import chemaxon.checkers.ReactionChecker;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;

@CheckerInfo(name="Reaction Map Error Checker", localMenuName="Reaction Map Error", description="Detects reactions having insufficient or invalid atom mapping", noErrorMessage="No invalid reaction map found", oneErrorMessage="invalid reaction map found", moreErrorMessage="invalid reaction maps found", severity=CheckerSeverity.ERROR, actionStringToken="reactionmap")
public class ReactionMapErrorChecker
extends ReactionChecker {
    public ReactionMapErrorChecker() {
        super(StructureCheckerErrorType.INVALID_REACTION_MAP, new MissingAtomMapChecker());
    }

    @Override
    protected boolean isCorrect(StructureCheckerResult result) {
        return result.getMolecule().getAtomCount() - result.getAtoms().size() >= 2;
    }
}

