/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.CheckerSeverity;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import java.util.ArrayList;
import java.util.HashSet;

@CheckerInfo(name="R-group Orphan Attachment Error Checker", localMenuName="R-group Orphan Attachment Error", description="Detects molecules containing orphan attachments", noErrorMessage="No orphan attachments found", oneErrorMessage="Orphan attachment", moreErrorMessage="orphan attachments", severity=CheckerSeverity.ERROR, actionStringToken="rgrouporphanattachmenterror")
public class RgroupOrphanAttachmentErrorChecker
extends AbstractStructureChecker {
    public RgroupOrphanAttachmentErrorChecker() {
        super(StructureCheckerErrorType.RGROUP_ORPHAN_ATTACHMENT_ERROR);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        if (!(molecule instanceof RgMolecule)) {
            return null;
        }
        HashSet<MolAtom> atoms = new HashSet<MolAtom>();
        HashSet<MolBond> bonds = new HashSet<MolBond>();
        int errorCount = 0;
        RgMolecule rgmol = (RgMolecule)molecule;
        int rgroupCount = rgmol.getRgroupCount();
        for (int i = 0; i < rgroupCount; ++i) {
            int memberCount = rgmol.getRgroupMemberCount(i);
            for (int j = 0; j < memberCount; ++j) {
                Molecule member = rgmol.getRgroupMember(i, j);
                int atomCount = member.getAtomCount();
                block5: for (int k = 0; k < atomCount; ++k) {
                    MolAtom atom = member.getAtom(k);
                    if (atom.getAtno() != 138) continue;
                    int bondCount = atom.getBondCount();
                    switch (bondCount) {
                        case 1: {
                            MolAtom ligand = atom.getBond(0).getOtherAtom(atom);
                            if (ligand.getAtno() != 138) continue block5;
                            atoms.add(atom);
                            atoms.add(ligand);
                            bonds.add(atom.getBond(0));
                            ++errorCount;
                            continue block5;
                        }
                        default: {
                            atoms.add(atom);
                            for (int t = 0; t < bondCount; ++t) {
                                bonds.add(atom.getBond(t));
                            }
                            ++errorCount;
                        }
                    }
                }
            }
        }
        if (errorCount == 0) {
            return null;
        }
        return new DefaultStructureCheckerResult(this, new ArrayList<MolAtom>(atoms), new ArrayList<MolBond>(bonds), StructureCheckerErrorType.RGROUP_ORPHAN_ATTACHMENT_ERROR, molecule, this.getErrorDescription(errorCount), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }
}

