/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

@CheckerInfo(name="Solvent Checker", localMenuName="Solvent", description="Detects solvent moieties", noErrorMessage="No solvent found", oneErrorMessage="solvent found", moreErrorMessage="solvents found", actionStringToken="solvent")
public final class SolventChecker
extends AbstractStructureChecker {
    final List<String> solvents = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolventChecker() {
        super(StructureCheckerErrorType.SOLVENT);
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/chemaxon/checkers/resource/solvents.smiles")));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.solvents.add(line);
            }
        }
        catch (IOException e) {
            this.solvents.clear();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected synchronized StructureCheckerResult check1(Molecule molecule) {
        if (molecule.getFragCount(1) == 1 || molecule instanceof RxnMolecule) {
            return null;
        }
        Molecule clone = molecule.cloneMolecule();
        List<String> nonMappedSmilesList = Arrays.asList(clone.toFormat("smiles:u").split("\\."));
        for (int i = 0; i < clone.getAtomCount(); ++i) {
            clone.getAtom(i).setAtomMap(i + 1);
        }
        List<String> mappedSmilesList = Arrays.asList(clone.toFormat("smiles:u").split("\\."));
        HashSet<String> mappedSolventsFound = new HashSet<String>();
        HashSet<String> solventsFound = new HashSet<String>();
        for (String solvent : this.solvents) {
            for (int i = 0; i < nonMappedSmilesList.size(); ++i) {
                if (!solvent.equals(nonMappedSmilesList.get(i))) continue;
                solventsFound.add(nonMappedSmilesList.get(i));
                mappedSolventsFound.add(mappedSmilesList.get(i));
            }
        }
        ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
        for (String solvent : mappedSolventsFound) {
            String[] splited;
            for (String data : splited = solvent.split("]")) {
                String substring;
                int beginIndex = data.indexOf(58);
                if (beginIndex == -1 || "".equals(substring = data.substring(beginIndex + 1))) continue;
                atoms.add(molecule.getAtom(Integer.parseInt(substring) - 1));
            }
        }
        boolean noError = mappedSolventsFound.isEmpty();
        boolean isAmbigous = solventsFound.size() > 1 || atoms.size() == molecule.getAtomCount();
        StructureCheckerErrorType errorType = isAmbigous ? StructureCheckerErrorType.SOLVENT_AMBIGOUS : StructureCheckerErrorType.SOLVENT;
        return noError ? null : new DefaultStructureCheckerResult(this, atoms, new ArrayList<MolBond>(), errorType, molecule, this.getErrorDescription(mappedSolventsFound.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }
}

