/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import java.util.List;

public class StructureCheckOptions {
    @Parameter(names={"-h", "--help"}, description="help text generation")
    public boolean help = false;
    @Parameter(names={"-hc", "--help-checker-action"}, description="checker action help text generation")
    public boolean helpCheckerAction = false;
    @Parameter(names={"-hf", "--help-fixer-action"}, description="fixer action help text generation")
    public boolean helpFixerAction = false;
    @Parameter(names={"-c", "--config"}, description="action string configuration")
    public String config;
    @Parameter(names={"-m", "--mode"}, description="mode of the operation: fix or check", converter=ModeConverter.class)
    public Mode mode = Mode.Check;
    @Parameter(names={"-t", "--output-type"}, description="output type", converter=TypeConverter.class)
    public Type type = Type.Single;
    @Parameter(names={"-f", "--format"}, description="output file format")
    public String format = "smiles";
    @Parameter(names={"-o", "--output"}, description="output file (default: standard output)")
    public String outputPath;
    @Parameter(names={"-d", "--discarded"}, description="writes molecules with structure error to a separate file")
    public String discardedPath;
    @Parameter(names={"-rf", "--report-file"}, description="writes report to a file")
    public String reportPath;
    @Parameter(names={"-rp", "--report-property"}, description="writes report to the property of the output, with the specified propery name")
    public boolean reportProperty = false;
    @Parameter(names={"-rt", "--report-pattern"}, description="pattern for the report")
    public String reportPattern = "old";
    @Parameter(names={"-re", "--report-format"}, description="molecule format in the report")
    public String reportFormat;
    @Parameter(names={"-l", "--log"}, description="writes software-error log messages to file")
    public String logPath;
    @Parameter(names={"-ocr", "--discard-scan-erros"}, description="discard incorrectly scanned molecules")
    public boolean ocr = false;
    @Parameter(names={"-x"}, description="Fix mode enabled. - deprecated")
    public boolean fix = false;
    @Parameter(names={"-g", "--ignore-errors"}, description="Ignores errors in input files")
    public boolean ignoreErrors = false;
    @Parameter(names={"-n", "--no-report"}, description="Does not generate report")
    public boolean noReport = false;
    @Parameter(description="The list of input files")
    public List<String> files;

    public static final class TypeConverter
    implements IStringConverter<Type> {
        public Type convert(String value) {
            if ("separated".equalsIgnoreCase(value)) {
                return Type.Separated;
            }
            if ("single".equalsIgnoreCase(value)) {
                return Type.Single;
            }
            if ("accepted".equalsIgnoreCase(value)) {
                return Type.Accepted;
            }
            if ("discarded".equalsIgnoreCase(value)) {
                return Type.Discarded;
            }
            return Type.Single;
        }
    }

    public static enum Type {
        Single,
        Separated,
        Accepted,
        Discarded;

    }

    public static final class ModeConverter
    implements IStringConverter<Mode> {
        public Mode convert(String value) {
            if ("fix".equalsIgnoreCase(value)) {
                return Mode.Fix;
            }
            if ("check".equalsIgnoreCase(value)) {
                return Mode.Check;
            }
            return Mode.Check;
        }
    }

    public static enum Mode {
        Check,
        Fix;

    }
}

