/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.util.ArrayList;

@CheckerInfo(name="Unbalanced Reaction Checker", localMenuName="Unbalanced Reaction", description="Detects reaction schemes having more atoms on one side of the reaction arrow than on the other", noErrorMessage="No unbalanced reaction found", oneErrorMessage="unbalanced reaction found", moreErrorMessage="unbalanced reactions found", actionStringToken="unbalancedreaction")
public class UnbalancedReactionChecker
extends AbstractStructureChecker {
    public UnbalancedReactionChecker() {
        super(StructureCheckerErrorType.UNBALANCED_REACTION);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        if (!molecule.isReaction()) {
            return null;
        }
        RxnMolecule reaction = RxnMolecule.getReaction(molecule.cloneMolecule());
        Molecule rmol = new Molecule();
        for (Molecule mol : reaction.getReactants()) {
            rmol.fuse(mol, false);
        }
        String rformula = rmol.getFormula();
        Molecule pmol = new Molecule();
        for (Molecule mol : reaction.getProducts()) {
            pmol.fuse(mol, false);
        }
        String pformula = pmol.getFormula();
        if (rformula.equals(pformula)) {
            return null;
        }
        return new DefaultStructureCheckerResult(this, new ArrayList<MolAtom>(), new ArrayList<MolBond>(), this.getErrorType(), molecule, this.getDescription(), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }
}

