/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AtomChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.CheckerSeverity;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

@CheckerInfo(name="Valence Error Checker", localMenuName="Valence Error", description="Detects valence errors", noErrorMessage="No valence error found", oneErrorMessage="valence error found", moreErrorMessage="valence errors found", severity=CheckerSeverity.ERROR, actionStringToken="valence")
public class ValenceErrorChecker
extends AtomChecker {
    public ValenceErrorChecker() {
        super(StructureCheckerErrorType.VALENCE);
    }

    @Override
    protected boolean check(Molecule molecule, MolAtom atom) {
        atom.valenceCheck();
        return atom.hasValenceError();
    }
}

