/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.logger;

import chemaxon.checkers.logger.SimplePattern;
import java.util.ArrayList;
import java.util.List;

public class CheckerLogPattern
extends SimplePattern {
    private String moleculeFormat = "smiles";
    private static List<Character> listEscapeSequences = new ArrayList<Character>();
    private String entrySeparator = ",";
    private String fixerSeparator = "->";
    private String lineSeparator = "\n";
    private final boolean allowsMultiline;
    private String title = "Structure Checker Results";
    private String header;
    private SimplePattern summary = new SimplePattern("Analized structures: %s, in %i files.\nErrors found: %c, in %a structures, in %d files.\nFixed errors: %f, in %b structures, in %e files. \nError count after fixes: %n, in %x structures, in %y files.\n");
    public static final SimplePattern DEFAULT_SUMMARY;
    public static final CheckerLogPattern DEFAULT_OLD;
    public static final CheckerLogPattern DEFAULT;
    public static final CheckerLogPattern ERRORS;
    public static final CheckerLogPattern FIXES;
    public static final CheckerLogPattern DEFAULT_MULTILINED;
    public static final CheckerLogPattern ERRORS_MULTILINED;
    public static final CheckerLogPattern FIXES_MULTILINED;
    public static final SimplePattern CSV_SUMMARY_FULL;
    public static final CheckerLogPattern CSV;
    public static final CheckerLogPattern CSV_SMILES;
    public static final CheckerLogPattern CSV_FULL;

    public CheckerLogPattern(String pattern) {
        super(pattern);
        boolean c = this.getRepresentation().contains("%c");
        boolean f = this.getRepresentation().contains("%f");
        boolean r = this.getRepresentation().contains("%r");
        this.allowsMultiline = c || f || r;
    }

    public CheckerLogPattern(String pattern, String entrySeparator, String lineSeparator, String title, String header, SimplePattern summary) {
        this(pattern);
        this.entrySeparator = entrySeparator;
        this.lineSeparator = lineSeparator;
        this.title = title;
        this.header = header;
        this.summary = summary;
    }

    public void setFormat(String format2) {
        this.moleculeFormat = format2;
    }

    public String getFormat() {
        return this.moleculeFormat;
    }

    public String getEntrySeparator() {
        return this.entrySeparator;
    }

    public void setEntrySeparator(String entrySeparator) {
        this.entrySeparator = entrySeparator;
    }

    public String getFixerSeparator() {
        return this.fixerSeparator;
    }

    public void setFixerSeparator(String fixerSeparator) {
        this.fixerSeparator = fixerSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public boolean isValid() {
        boolean result = true;
        if (this.getParts() == null || this.getParts().isEmpty()) {
            result = false;
        }
        boolean c = this.getRepresentation().contains("%c");
        boolean f = this.getRepresentation().contains("%f");
        boolean r = this.getRepresentation().contains("%r");
        boolean C = this.getRepresentation().contains("%C");
        boolean F = this.getRepresentation().contains("%F");
        boolean R = this.getRepresentation().contains("%R");
        if (!(c || f || r || C || F || R)) {
            result = false;
        }
        if ((C || F || R) && (c || f || r)) {
            result = false;
        }
        if (C && R || F && R || C && F) {
            result = false;
        }
        return result;
    }

    public boolean allowsMultipleRows() {
        return this.allowsMultiline;
    }

    public static List<Character> getListEscapeSequences() {
        return listEscapeSequences;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public SimplePattern getSummary() {
        return this.summary;
    }

    public void setSummary(SimplePattern summary) {
        this.summary = summary;
    }

    public static CheckerLogPattern parse(String logPattern) {
        CheckerLogPattern result = null;
        String pattern = logPattern.toLowerCase();
        result = "csv".equals(pattern) ? CSV : ("csv_full".equals(pattern) ? CSV_FULL : ("default".equals(pattern) ? DEFAULT : ("errors".equals(pattern) ? ERRORS : ("fixes".equals(pattern) ? FIXES : ("default_multi".equals(pattern) ? DEFAULT_MULTILINED : ("errors_multi".equals(pattern) ? ERRORS_MULTILINED : ("fixes_multi".equals(pattern) ? FIXES_MULTILINED : ("old".equals(pattern) ? DEFAULT_OLD : new CheckerLogPattern(logPattern)))))))));
        return result;
    }

    static {
        listEscapeSequences.add(Character.valueOf('C'));
        listEscapeSequences.add(Character.valueOf('F'));
        listEscapeSequences.add(Character.valueOf('R'));
        DEFAULT_SUMMARY = new SimplePattern("Summary:\n\nStructures checked: %s\nStructures with problems: %a\nStructures fixed automatically: %b");
        DEFAULT_OLD = new CheckerLogPattern("%i\t%c\t%f\t%x", ",", "\n", "Structure Checker Report", "Structure\tProblem\tApplied fix\tFixed", DEFAULT_SUMMARY);
        DEFAULT = new CheckerLogPattern("%i. %R");
        ERRORS = new CheckerLogPattern("%i. %C");
        FIXES = new CheckerLogPattern("%i. %F");
        DEFAULT_MULTILINED = new CheckerLogPattern("%i. %r");
        ERRORS_MULTILINED = new CheckerLogPattern("%i. %c");
        FIXES_MULTILINED = new CheckerLogPattern("%i. %f");
        CSV_SUMMARY_FULL = new SimplePattern("\n\"Summary\"\n;\"Error\";\"Structure\";\"File\"\n\"Analized\";;%s;%i\n\"Found\";%c;%a;%d\n\"Fixed\";%f;%b;%e\n\"Still exists\";%n;%x;%y");
        CSV = new CheckerLogPattern("%i;\"%c\";\"%f\"", ",", "\n", "Structure checker report", "\"Index\";\"Checker\";\"Fixer\"", null);
        CSV_SMILES = new CheckerLogPattern("%i;\"%c\";\"%f\";\"%s\";\"%o\"", ",", "\n", "Structure Checker Report", "\"Index\";\"Checker\";\"Fixer\";\"Input\";\"Output\"", null);
        CSV_FULL = new CheckerLogPattern("\"%p\";%l;\"%c\";\"%f\";\"%s\";\"%o\"", ",", "\n", "Structure Checker Report", "\"File\";\"Index\";\"Checker\";\"Fixer\";\"Input\";\"Output\"", CSV_SUMMARY_FULL);
    }
}

