/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.logger;

import chemaxon.checkers.logger.StructureCheckerLogger;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.StructureFixer;
import chemaxon.struc.Molecule;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PropertyCheckerLogger
implements StructureCheckerLogger {
    private static final String DEFAULT_MANUAL_FIX_ENTRY = "[manual]";
    private static final String DEFAULT_ORIGINAL_RESULT_LIST_PROPERTY = "Problems Found";
    private static final String DEFAULT_APPLIED_FIXES_LIST_PROPERTY = "Fixes Applied";
    private static final String DEFAULT_FINAL_RESULT_LIST_PROPERTY = "Problems Remaining";
    private static final String DEFAULT_RESULT_SEPARATOR = ", ";
    private final Set<String> appliedFixers = new HashSet<String>();
    private final String manualFixEntry;
    private final String originalResultListPropery;
    private final String finalResultListProperty;
    private final String resultSeparator;
    private final String appliedFixesListProperty;
    private String originalResults = null;

    public PropertyCheckerLogger() {
        this(DEFAULT_RESULT_SEPARATOR);
    }

    public PropertyCheckerLogger(String separator) {
        this(separator, DEFAULT_MANUAL_FIX_ENTRY);
    }

    public PropertyCheckerLogger(String separator, String manualFixEntry) {
        this(separator, manualFixEntry, DEFAULT_ORIGINAL_RESULT_LIST_PROPERTY, DEFAULT_APPLIED_FIXES_LIST_PROPERTY, DEFAULT_FINAL_RESULT_LIST_PROPERTY);
    }

    public PropertyCheckerLogger(String originalResultsPropertyName, String appliedFixesPropertyName, String remainingIssuesPropertyName) {
        this(DEFAULT_RESULT_SEPARATOR, DEFAULT_MANUAL_FIX_ENTRY, DEFAULT_ORIGINAL_RESULT_LIST_PROPERTY, DEFAULT_APPLIED_FIXES_LIST_PROPERTY, DEFAULT_FINAL_RESULT_LIST_PROPERTY);
    }

    public PropertyCheckerLogger(String separator, String manualFixEntry, String originalResultsPropertyName, String appliedFixesPropertyName, String remainingIssuesPropertyName) {
        this.resultSeparator = separator;
        this.manualFixEntry = manualFixEntry;
        this.originalResultListPropery = originalResultsPropertyName;
        this.appliedFixesListProperty = appliedFixesPropertyName;
        this.finalResultListProperty = remainingIssuesPropertyName;
    }

    @Override
    public void onFirstCheck(Molecule molecule, List<StructureCheckerResult> resultList) {
        StringBuilder builder = new StringBuilder();
        this.appliedFixers.clear();
        if (resultList.isEmpty()) {
            this.originalResults = null;
        } else {
            for (StructureCheckerResult result : resultList) {
                builder.append(result.getName());
                if (result == resultList.get(resultList.size() - 1)) continue;
                builder.append(this.resultSeparator);
            }
            this.originalResults = builder.toString();
        }
    }

    @Override
    public void onFix(Molecule originalMolecule, Molecule fixedMolecule, StructureCheckerResult checkerResult, StructureFixer appliedFixer, boolean fixResult) {
        this.appliedFixers.add(appliedFixer == null ? this.manualFixEntry : (appliedFixer.getDescriptor() == null ? "Unnamed Fixer" : appliedFixer.getDescriptor().getName()));
    }

    @Override
    public void onLastCheck(Molecule molecule, List<StructureCheckerResult> resultList) {
        if (this.originalResults != null) {
            molecule.setProperty(this.originalResultListPropery, this.originalResults);
        }
        if (!this.appliedFixers.isEmpty()) {
            StringBuilder fixesBuilder = new StringBuilder();
            String[] entries = this.appliedFixers.toArray(new String[this.appliedFixers.size()]);
            for (int i = 0; i < entries.length; ++i) {
                fixesBuilder.append(entries[i]);
                if (i + 1 >= entries.length) continue;
                fixesBuilder.append(this.resultSeparator);
            }
            molecule.setProperty(this.appliedFixesListProperty, fixesBuilder.toString());
        }
        if (resultList != null && !resultList.isEmpty()) {
            StringBuilder finalResultsBuilder = new StringBuilder();
            for (StructureCheckerResult result : resultList) {
                finalResultsBuilder.append(result.getName());
                if (result == resultList.get(resultList.size() - 1)) continue;
                finalResultsBuilder.append(this.resultSeparator);
            }
            molecule.setProperty(this.finalResultListProperty, finalResultsBuilder.toString());
        }
    }
}

