/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.logger;

import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.StructureFixer;
import chemaxon.struc.Molecule;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StructureLog {
    private Map<StructureChecker, LogEntry> logEntries = new LinkedHashMap<StructureChecker, LogEntry>();

    public Map<StructureChecker, LogEntry> getLogEntries() {
        return this.logEntries;
    }

    public void addLogEntry(StructureCheckerResult result, Molecule original) {
        if (!this.logEntries.containsKey(result.getSource())) {
            LogEntry entry = new LogEntry(result);
            entry.setOriginalStructure(original);
            this.logEntries.put(result.getSource(), entry);
        }
    }

    public void addLogEntry(StructureCheckerResult result, StructureFixer fixer, Molecule original, Molecule fixedMolecule, boolean fixed) {
        if (!this.logEntries.containsKey(result.getSource())) {
            LogEntry entry = new LogEntry(result, fixer, fixed);
            entry.setOriginalStructure(original);
            entry.setFixedMolecule(fixedMolecule);
            this.logEntries.put(result.getSource(), entry);
        } else {
            LogEntry entry = this.logEntries.get(result.getSource());
            entry.setOriginalStructure(original);
            if (fixer != null) {
                entry.setFixer(fixer);
                entry.setFixed(fixed);
                entry.setFixedByPreviousFixer(false);
                entry.setManualFix(false);
                entry.setFixedMolecule(fixedMolecule);
            } else {
                entry.setFixed(fixed);
                entry.setFixedByPreviousFixer(false);
                entry.setManualFix(true);
                entry.setFixedMolecule(fixedMolecule);
            }
        }
    }

    public void finalize(List<StructureCheckerResult> resultList) {
        for (StructureChecker checker : this.logEntries.keySet()) {
            boolean found = false;
            for (StructureCheckerResult result : resultList) {
                if (!result.getSource().equals(checker)) continue;
                found = true;
                this.logEntries.get(checker).setFixed(false);
            }
            if (found) continue;
            this.logEntries.get(checker).setFixed(true);
            this.logEntries.get(checker).setFixedByPreviousFixer(true);
        }
    }

    public static class LogEntry {
        private StructureCheckerResult result;
        private StructureFixer fixer;
        private boolean fixed = false;
        private boolean manualFix = false;
        private boolean fixedByPreviousFixer = false;
        private Molecule original;
        private Molecule fixedMolecule;

        public LogEntry(StructureCheckerResult result) {
            this.result = result;
        }

        public LogEntry(StructureCheckerResult result, StructureFixer fixer, boolean fixed) {
            this.result = result;
            this.fixer = fixer;
            this.fixed = fixed;
            if (fixer == null && fixed) {
                this.manualFix = true;
            }
        }

        public StructureFixer getFixer() {
            return this.fixer;
        }

        public void setFixer(StructureFixer fixer) {
            this.fixer = fixer;
            if (fixer != null) {
                this.fixed = true;
            }
        }

        public boolean isFixed() {
            return this.fixed;
        }

        public void setFixed(boolean fixed) {
            this.fixed = fixed;
        }

        public Molecule getOriginalStructure() {
            return this.original;
        }

        public void setOriginalStructure(Molecule original) {
            this.original = original;
        }

        public StructureCheckerResult getResult() {
            return this.result;
        }

        public boolean isManualFix() {
            return this.fixed && this.manualFix;
        }

        public void setManualFix(boolean manualFix) {
            this.manualFix = manualFix;
        }

        public boolean isFixedByPreviousFixer() {
            return this.fixed && this.fixedByPreviousFixer;
        }

        public void setFixedByPreviousFixer(boolean fixedByPreviousFixer) {
            this.fixedByPreviousFixer = fixedByPreviousFixer;
        }

        public Molecule getFixedMolecule() {
            if (this.fixedMolecule == null) {
                return this.result.getMolecule();
            }
            return this.fixedMolecule;
        }

        public void setFixedMolecule(Molecule fixedMolecule) {
            this.fixedMolecule = fixedMolecule;
        }
    }
}

