/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.logger;

import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.logger.CheckerLogPattern;
import chemaxon.checkers.logger.SimplePattern;
import chemaxon.checkers.logger.StructureLog;
import chemaxon.checkers.logger.SummarizerLogger;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.StructureFixer;
import chemaxon.formats.MolExporter;
import chemaxon.struc.Molecule;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TemplateBasedLogger
extends SummarizerLogger
implements Closeable,
Flushable {
    private CheckerLogPattern pattern;
    private PrintStream stream;
    private StructureLog processedErrors = new StructureLog();
    private int structureIndex = 1;

    public TemplateBasedLogger(CheckerLogPattern pattern, OutputStream stream) {
        this.pattern = pattern;
        this.stream = new PrintStream(stream);
        if (pattern.getTitle() != null) {
            this.stream.print(pattern.getTitle());
            this.stream.print(pattern.getLineSeparator());
        }
        if (pattern.getHeader() != null) {
            this.stream.print(pattern.getHeader());
            this.stream.print(pattern.getLineSeparator());
        }
    }

    @Override
    public void onFirstCheck(Molecule molecule, List<StructureCheckerResult> resultList) {
        super.onFirstCheck(molecule, resultList);
        for (StructureCheckerResult result : resultList) {
            this.processedErrors.addLogEntry(result, molecule);
        }
    }

    @Override
    public void onFix(Molecule originalMolecule, Molecule fixedMolecule, StructureCheckerResult checkerResult, StructureFixer appliedFixer, boolean fixResult) {
        super.onFix(originalMolecule, fixedMolecule, checkerResult, appliedFixer, fixResult);
        this.processedErrors.addLogEntry(checkerResult, appliedFixer, originalMolecule, fixedMolecule, fixResult);
    }

    @Override
    public void onLastCheck(Molecule molecule, List<StructureCheckerResult> resultList) {
        super.onLastCheck(molecule, resultList);
        this.processedErrors.finalize(resultList);
        if (this.pattern.isValid()) {
            if (this.pattern.allowsMultipleRows()) {
                this.logMultiLine();
            } else {
                this.logSingleLine();
            }
        }
        ++this.structureIndex;
    }

    private void logMultiLine() {
        for (StructureChecker error : this.processedErrors.getLogEntries().keySet()) {
            this.stream.print(this.pattern.getParts().get(0));
            StructureLog.LogEntry entry = this.processedErrors.getLogEntries().get(error);
            for (int i = 1; i < this.pattern.getParts().size(); ++i) {
                this.stream.print(this.getValueOf(this.structureIndex, this.pattern.getEscapeCharacters().get(i - 1).charValue(), entry));
                this.stream.print(this.pattern.getParts().get(i));
            }
            this.stream.print(this.pattern.getLineSeparator());
        }
        this.processedErrors = new StructureLog();
    }

    private void logSingleLine() {
        this.stream.print(this.pattern.getParts().get(0));
        for (int i = 1; i < this.pattern.getParts().size(); ++i) {
            if (CheckerLogPattern.getListEscapeSequences().contains(this.pattern.getEscapeCharacters().get(i - 1))) {
                StructureLog.LogEntry entry = null;
                for (StructureChecker checker : this.processedErrors.getLogEntries().keySet()) {
                    if (entry != null) {
                        this.stream.print(this.pattern.getEntrySeparator());
                    }
                    entry = this.processedErrors.getLogEntries().get(checker);
                    this.stream.print(this.getValueOf(this.structureIndex, this.pattern.getEscapeCharacters().get(i - 1).charValue(), entry));
                }
            } else {
                this.stream.print(this.getValueOf(this.structureIndex, this.pattern.getEscapeCharacters().get(i - 1).charValue(), null));
            }
            this.stream.print(this.pattern.getParts().get(i));
        }
        this.processedErrors = new StructureLog();
        this.stream.print(this.pattern.getLineSeparator());
    }

    @Override
    public void closeLog() {
        super.closeLog();
        this.stream.print(this.pattern.getLineSeparator());
        if (this.pattern.getSummary() != null) {
            this.stream.print(SimplePattern.getValue(this.pattern.getSummary(), this.getSummaryValues()));
        }
        this.stream.flush();
    }

    private String getValueOf(long id, char character, StructureLog.LogEntry entry) {
        StringBuilder result = new StringBuilder();
        StructureCheckerResult checkerResult = entry == null ? null : entry.getResult();
        StructureFixer fixer = entry == null ? null : entry.getFixer();
        Molecule original = entry == null ? null : entry.getOriginalStructure();
        switch (character) {
            case 'c': {
                if (checkerResult == null) break;
                result.append(checkerResult.getName());
                break;
            }
            case 'f': {
                if (this.getFixerName(fixer, entry) == null) break;
                result.append(this.getFixerName(fixer, entry));
                break;
            }
            case 'r': {
                if (checkerResult != null) {
                    result.append(checkerResult.getName());
                }
                if (null == this.getFixerName(fixer, entry)) break;
                result.append(this.pattern.getFixerSeparator());
                result.append(this.getFixerName(fixer, entry));
                break;
            }
            case 'C': {
                if (checkerResult == null) break;
                result.append(checkerResult.getName());
                break;
            }
            case 'F': {
                if (this.getFixerName(fixer, entry) == null) break;
                result.append(this.getFixerName(fixer, entry));
                break;
            }
            case 'R': {
                if (checkerResult == null) break;
                result.append(checkerResult.getName());
                if (this.getFixerName(fixer, entry) == null) break;
                result.append(this.pattern.getFixerSeparator());
                result.append(this.getFixerName(fixer, entry));
                break;
            }
            case 'i': {
                result.append(id);
                break;
            }
            case 'p': {
                String fileName = this.getFileNameFor(id - 1L);
                if (fileName == null) break;
                result.append(fileName);
                break;
            }
            case 'l': {
                Long index = this.getFileIndexFor(id - 1L);
                if (index == null) break;
                result.append(index + 1L);
                break;
            }
            case 'o': {
                try {
                    result.append(MolExporter.exportToFormat(checkerResult == null ? original : entry.getFixedMolecule(), this.pattern.getFormat()));
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error happened in report generation: " + e.getMessage());
                    result.append("ERROR in molecule export");
                }
                break;
            }
            case 's': {
                try {
                    result.append(MolExporter.exportToFormat(original == null ? entry.getFixedMolecule() : original, this.pattern.getFormat()));
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error happened in report generation: " + e.getMessage());
                    result.append("ERROR in molecule export");
                }
                break;
            }
            case 'x': {
                result.append(entry == null ? false : entry.isFixed());
            }
        }
        return result.toString();
    }

    private String getFixerName(StructureFixer fixer, StructureLog.LogEntry entry) {
        String result = null;
        result = fixer != null ? fixer.getDescriptor().getName() : (entry.isFixedByPreviousFixer() ? "Fixed already" : (entry.isManualFix() ? "Manual Fix" : "Unknown Fix"));
        return result;
    }

    protected Map<Character, String> getSummaryValues() {
        HashMap<Character, String> result = new HashMap<Character, String>();
        result.put(Character.valueOf('s'), String.valueOf(this.getStructureCount()));
        result.put(Character.valueOf('i'), String.valueOf(this.getFileCount()));
        result.put(Character.valueOf('c'), String.valueOf(this.getErrorCount()));
        result.put(Character.valueOf('f'), String.valueOf(this.getFixedErrorCount()));
        result.put(Character.valueOf('n'), String.valueOf(this.getNotFixedErrorCount()));
        result.put(Character.valueOf('a'), String.valueOf(this.getErrorStructureCount()));
        result.put(Character.valueOf('b'), String.valueOf(this.getFixedStructureCount()));
        result.put(Character.valueOf('x'), String.valueOf(this.getNotFixedStructureCount()));
        result.put(Character.valueOf('d'), String.valueOf(this.getErrorFileCount()));
        result.put(Character.valueOf('e'), String.valueOf(this.getFixedFileCount()));
        result.put(Character.valueOf('y'), String.valueOf(this.getNotFixedFileCount()));
        return result;
    }

    @Override
    public void close() throws IOException {
        this.closeLog();
        this.stream.close();
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    public void setFormat(String reportFormat) {
        this.pattern.setFormat(reportFormat);
    }
}

