/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.result;

import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.List;
import javax.swing.Icon;

public class AromaticityCheckerResult
extends DefaultStructureCheckerResult {
    private final int aromataType;

    public AromaticityCheckerResult(StructureChecker source, List<MolAtom> atoms, List<MolBond> bonds, Molecule molecule, String description, int aromataType, String name, String localMenuName, String helpText, Icon icon) {
        super(source, atoms, bonds, StructureCheckerErrorType.AROMATICITY, molecule, description, name, localMenuName, helpText, icon);
        this.aromataType = aromataType;
    }

    public int getAromataType() {
        return this.aromataType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.aromataType;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AromaticityCheckerResult other = (AromaticityCheckerResult)obj;
        return this.aromataType == other.aromataType;
    }
}

