/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.result;

import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class MetalloceneCheckerResult
extends DefaultStructureCheckerResult {
    private List<List<MolAtom>> fiveLongRings;
    private List<MolAtom> metalAtoms;

    public MetalloceneCheckerResult(StructureChecker source, List<MolAtom> atoms, List<MolBond> bonds, StructureCheckerErrorType errorType, Molecule molecule, String description, String name, String localMenuName, String helpText, Icon icon, List<List<MolAtom>> fiveLongRings, List<MolAtom> metalAtoms) {
        super(source, atoms, bonds, errorType, molecule, description, name, localMenuName, helpText, icon);
        this.fiveLongRings = fiveLongRings;
        this.metalAtoms = metalAtoms;
    }

    public List<List<MolAtom>> getFiveLongRings() {
        return this.fiveLongRings;
    }

    public void setFiveLongRings(List<List<MolAtom>> fiveLongRings) {
        this.fiveLongRings = fiveLongRings;
    }

    public List<MolAtom> getMetalAtoms() {
        return this.metalAtoms;
    }

    public void setMetalAtoms(List<MolAtom> metalAtoms) {
        this.metalAtoms = metalAtoms;
    }

    @Override
    public void convert(Molecule molecule, Map<String, Map<? extends Object, ? extends Object>> convertData) {
        super.convert(molecule, convertData);
        Map<? extends Object, ? extends Object> atomAtomMap = convertData.get("atomAtomMap");
        ArrayList<List<MolAtom>> fiveLongRings = new ArrayList<List<MolAtom>>();
        for (List<MolAtom> ring : this.getFiveLongRings()) {
            ArrayList<Object> newRing = new ArrayList<Object>();
            for (MolAtom molAtom : ring) {
                newRing.add(atomAtomMap.get(molAtom));
            }
            fiveLongRings.add(newRing);
        }
        this.setFiveLongRings(fiveLongRings);
        ArrayList<MolAtom> metalAtoms = new ArrayList<MolAtom>();
        for (MolAtom atom : this.getMetalAtoms()) {
            metalAtoms.add((MolAtom)atomAtomMap.get(atom));
        }
        this.setMetalAtoms(metalAtoms);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fiveLongRings == null ? 0 : ((Object)this.fiveLongRings).hashCode());
        result = 31 * result + (this.metalAtoms == null ? 0 : ((Object)this.metalAtoms).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetalloceneCheckerResult other = (MetalloceneCheckerResult)obj;
        if (this.fiveLongRings == null ? other.fiveLongRings != null : !((Object)this.fiveLongRings).equals(other.fiveLongRings)) {
            return false;
        }
        return !(this.metalAtoms == null ? other.metalAtoms != null : !((Object)this.metalAtoms).equals(other.metalAtoms));
    }
}

