/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.result;

import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class SgroupCheckerResult
extends DefaultStructureCheckerResult {
    private List<Sgroup> groups = new ArrayList<Sgroup>();

    public SgroupCheckerResult(StructureChecker source, List<MolAtom> atoms, List<MolBond> bonds, StructureCheckerErrorType errorType, Molecule molecule, String description, List<Sgroup> groups, String name, String localMenuName, String helpText, Icon icon) {
        super(source, atoms, bonds, errorType, molecule, description, name, localMenuName, helpText, icon);
        this.groups = groups;
    }

    public List<Sgroup> getSgroups() {
        return this.groups;
    }

    public void setSrgoups(List<Sgroup> groups) {
        this.groups = groups;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.groups == null ? 0 : ((Object)this.groups).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SgroupCheckerResult other = (SgroupCheckerResult)obj;
        return !(this.groups == null ? other.groups != null : !((Object)this.groups).equals(other.groups));
    }

    @Override
    public void convert(Molecule molecule, Map<String, Map<? extends Object, ? extends Object>> convertData) {
        super.convert(molecule, convertData);
        ArrayList<Sgroup> groups = new ArrayList<Sgroup>();
        Map<? extends Object, ? extends Object> sgroupSgroupMap = convertData.get("sgroupSgroupMap");
        for (Sgroup group : this.getSgroups()) {
            groups.add((Sgroup)sgroupSgroupMap.get(group));
        }
        this.setSrgoups(groups);
    }
}

