/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.runner;

import chemaxon.checkers.FixMode;
import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.logger.StructureCheckerLogger;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.checkers.runner.BasicCheckerRunner;
import chemaxon.checkers.runner.configuration.reader.ConfigurationReader;
import chemaxon.fixers.StructureFixer;
import chemaxon.struc.Molecule;
import java.util.List;

public class AdvancedCheckerRunner
extends BasicCheckerRunner {
    protected StructureCheckerLogger logger = null;
    protected boolean fallBackToBasic = true;

    public AdvancedCheckerRunner(ConfigurationReader configurationReader) {
        super(configurationReader);
    }

    protected boolean fix(StructureChecker checker, StructureCheckerResult result) {
        Molecule originalMolecule = result.getMolecule().cloneMolecule();
        if (checker.getDescriptor() != null) {
            if (FixMode.FIX.equals((Object)checker.getDescriptor().getFixMode())) {
                for (StructureFixer fixer : this.getFixers(result)) {
                    if (!fixer.getClass().getName().equals(checker.getDescriptor().getFixerClassName())) continue;
                    boolean fixResult = fixer.fix(result);
                    if (this.getLogger() != null) {
                        this.getLogger().onFix(originalMolecule, result.getMolecule(), result, fixer, fixResult);
                    }
                    if (!fixResult) continue;
                    return true;
                }
            } else {
                return false;
            }
        }
        if (this.fallBackToBasic) {
            return super.fix(result);
        }
        return false;
    }

    @Override
    public boolean fix() {
        int iterationCount = 0;
        List<StructureCheckerResult> resultList = super.checkAndWait();
        if (this.getLogger() != null) {
            this.getLogger().onFirstCheck(this.getMolecule(), resultList);
        }
        while (!resultList.isEmpty() && iterationCount < this.getCheckerList().size() + 1) {
            for (StructureChecker checker : this.getCheckerList()) {
                StructureCheckerResult result = checker.check(this.getMolecule());
                if (result == null) continue;
                this.convertResult(result);
                this.fix(checker, result);
            }
            ++iterationCount;
            resultList = super.checkAndWait();
        }
        if (this.getLogger() != null) {
            this.getLogger().onLastCheck(this.getMolecule(), resultList);
        }
        return resultList.isEmpty();
    }

    @Override
    public List<StructureCheckerResult> checkAndWait() {
        List<StructureCheckerResult> resultList = super.checkAndWait();
        if (this.getLogger() != null) {
            this.getLogger().onFirstCheck(this.getMolecule(), resultList);
            this.getLogger().onLastCheck(this.getMolecule(), resultList);
        }
        return resultList;
    }

    @Override
    public void check() {
        if (this.getLogger() != null) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    AdvancedCheckerRunner.super.check();
                    if (AdvancedCheckerRunner.this.backgroundThread != null) {
                        try {
                            AdvancedCheckerRunner.this.backgroundThread.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    AdvancedCheckerRunner.this.getLogger().onFirstCheck(AdvancedCheckerRunner.this.getMolecule(), AdvancedCheckerRunner.this.getResultList());
                    AdvancedCheckerRunner.this.getLogger().onLastCheck(AdvancedCheckerRunner.this.getMolecule(), AdvancedCheckerRunner.this.getResultList());
                }
            });
            thread.start();
        } else {
            super.check();
        }
    }

    @Override
    public void setMolecule(Molecule molecule) {
        super.setMolecule(molecule);
    }

    public StructureCheckerLogger getLogger() {
        return this.logger;
    }

    public void setLogger(StructureCheckerLogger logger) {
        this.logger = logger;
    }
}

