/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.runner.configuration.reader;

import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.runner.configuration.reader.ConfigurationReader;
import chemaxon.checkers.runner.configuration.reader.XMLBasedConfigurationReaderSAXHandler;
import chemaxon.fixers.StructureFixer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLBasedConfigurationReader
implements ConfigurationReader {
    public static final String DEFAULT_CONFIGURATION_SCHEMA = "/chemaxon/checkers/runner/configuration/reader/resource/checkerconfiguration.xsd";
    private final InputStream inputStream;
    private final List<StructureChecker> checkerList = new ArrayList<StructureChecker>();
    private final XMLBasedConfigurationReaderSAXHandler handler;

    public XMLBasedConfigurationReader(InputStream inputStream) {
        this.inputStream = inputStream;
        this.handler = new XMLBasedConfigurationReaderSAXHandler(this.checkerList);
    }

    @Override
    public List<StructureChecker> getCheckerList() {
        if (this.checkerList.isEmpty()) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                URL schemaURL = this.getClass().getResource(DEFAULT_CONFIGURATION_SCHEMA);
                if (schemaURL != null) {
                    Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaURL);
                    try {
                        factory.setSchema(schema);
                    }
                    catch (UnsupportedOperationException e) {
                        // empty catch block
                    }
                }
                SAXParser parser = factory.newSAXParser();
                parser.parse(this.inputStream, (DefaultHandler)this.handler);
            }
            catch (SAXException e) {
                this.checkerList.clear();
            }
            catch (ParserConfigurationException e) {
                this.checkerList.clear();
            }
            catch (IOException e) {
                this.checkerList.clear();
            }
        }
        return this.checkerList;
    }

    @Override
    public Map<StructureCheckerErrorType, StructureFixer> getErrorTypeDefaultFixerMap() {
        return new HashMap<StructureCheckerErrorType, StructureFixer>();
    }
}

