/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.ChemicalSpace;
import chemaxon.clustering.Cluster;
import chemaxon.clustering.ClusteringException;
import chemaxon.clustering.chemistry.Compound;
import chemaxon.clustering.chemistry.Fingerprint;
import java.util.Collections;
import java.util.Vector;

final class ACompoundInTheSpace
extends Compound {
    public float distance = 0.0f;
    private int index = -1;
    private Vector neighbours = new Vector();
    private int compounds = 0;
    private int elemCount = 0;
    Cluster cluster = null;
    private Fingerprint fp = null;
    private float[] fpf = null;
    private float[] coordinates = null;

    public ACompoundInTheSpace(int index, int id, int[] fpbits, int fplen, float[] coords) {
        super(id);
        this.index = index;
        this.fp = fplen == 0 ? null : new Fingerprint(fpbits, fplen);
        this.coordinates = coords;
        ++this.compounds;
        this.elemCount = 1;
    }

    public ACompoundInTheSpace(int index, ACompoundInTheSpace a, ACompoundInTheSpace b) {
        super(-index - 1);
        this.index = index;
        ++this.compounds;
        this.elemCount = a.elemCount + b.elemCount;
        this.coordWeights(a, b);
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public float similarity(ACompoundInTheSpace other) {
        return Fingerprint.tanimoto(this.fp, other.fp);
    }

    public float wardDistance(ACompoundInTheSpace other, float fingerprintWeight) {
        float d2 = 0.0f;
        int otherNo = other.elemCount;
        if (this.elemCount == 1 && otherNo == 1) {
            if (this.fp != null) {
                d2 += (float)Fingerprint.hamming(this.fp, other.fp);
            }
        } else if (this.elemCount == 1 && otherNo > 1) {
            if (this.fp != null) {
                for (int i = 0; i < this.fp.length(); ++i) {
                    float f = this.fp.get(i) ? 1.0f : 0.0f;
                    float diff = f - other.fpf[i];
                    d2 += diff * diff;
                }
            }
        } else if (this.elemCount > 1 && otherNo == 1) {
            if (this.fpf != null) {
                for (int i = 0; i < other.fp.length(); ++i) {
                    float f = other.fp.get(i) ? 1.0f : 0.0f;
                    float diff = f - this.fpf[i];
                    d2 += diff * diff;
                }
            }
        } else if (this.fpf != null) {
            for (int i = 0; i < this.fpf.length; ++i) {
                float diff = this.fpf[i] - other.fpf[i];
                d2 += diff * diff;
            }
        }
        d2 *= fingerprintWeight;
        if (this.coordinates != null) {
            d2 += this.euclideanDistanceSquare(other);
        }
        return (float)(Math.sqrt(d2) * (double)this.elemCount * (double)otherNo / (double)(this.elemCount + otherNo));
    }

    public float euclideanDistanceSquare(ACompoundInTheSpace other) {
        if (this.coordinates == null) {
            return 0.0f;
        }
        float sum = 0.0f;
        for (int i = 0; i < this.coordinates.length; ++i) {
            float diff = this.coordinates[i] - other.coordinates[i];
            sum += diff * diff;
        }
        return sum;
    }

    public float euclideanDistance(ACompoundInTheSpace other) {
        return (float)Math.sqrt(this.euclideanDistanceSquare(other));
    }

    public float distance(ACompoundInTheSpace other, float tanimotoWeight) {
        float dtanim = 0.0f;
        if (this.fp != null) {
            dtanim = 1.0f - this.similarity(other);
        }
        if (this.coordinates == null) {
            return dtanim;
        }
        float eucl = this.euclideanDistanceSquare(other);
        return (float)Math.sqrt((dtanim *= tanimotoWeight) + eucl);
    }

    public void coordWeights(ACompoundInTheSpace a, ACompoundInTheSpace b) {
        float[] avg;
        int newcount = a.elemCount + b.elemCount;
        float[] fArray = avg = a.coordinates == null ? null : new float[a.coordinates.length];
        if (a.fp != null) {
            this.fpf = new float[a.fp.length()];
        } else if (a.fpf != null) {
            this.fpf = new float[a.fpf.length];
        }
        if (this.fpf != null) {
            float sum;
            int i;
            if (a.elemCount == 1 && b.elemCount == 1) {
                for (i = 0; i < this.fpf.length; ++i) {
                    sum = (a.fp.get(i) ? 1 : 0) + (b.fp.get(i) ? 1 : 0);
                    this.fpf[i] = sum / (float)newcount;
                }
            } else if (a.elemCount == 1 && b.elemCount > 1) {
                for (i = 0; i < this.fpf.length; ++i) {
                    sum = (float)(a.fp.get(i) ? 1 : 0) + (float)b.elemCount * b.fpf[i];
                    this.fpf[i] = sum / (float)newcount;
                }
            } else if (a.elemCount > 1 && b.elemCount == 1) {
                for (i = 0; i < this.fpf.length; ++i) {
                    sum = (float)(b.fp.get(i) ? 1 : 0) + (float)a.elemCount * a.fpf[i];
                    this.fpf[i] = sum / (float)newcount;
                }
            } else {
                for (i = 0; i < this.fpf.length; ++i) {
                    if (a.fpf[i] == b.fpf[i]) {
                        this.fpf[i] = a.fpf[i];
                        continue;
                    }
                    sum = (float)a.elemCount * a.fpf[i] + (float)b.elemCount * b.fpf[i];
                    this.fpf[i] = sum / (float)newcount;
                }
            }
        }
        if (avg != null) {
            for (int i = 0; i < avg.length; ++i) {
                avg[i] = a.coordinates[i] == a.coordinates[i] ? a.coordinates[i] : (a.coordinates[i] * (float)a.elemCount + b.coordinates[i] * (float)b.elemCount) / (float)newcount;
            }
        }
        this.coordinates = avg;
    }

    protected Cluster getCluster() {
        return this.cluster;
    }

    protected boolean hadNeighbours() {
        return this.neighbours != null;
    }

    protected boolean hasNeighbours() {
        return this.neighbours != null && !this.neighbours.isEmpty();
    }

    protected Vector neighbours() {
        return this.neighbours;
    }

    public boolean isANeighbour(ACompoundInTheSpace c) {
        return Collections.binarySearch(this.neighbours, c) >= 0;
    }

    protected void clearNeighbours() {
        if (this.neighbours != null) {
            this.neighbours.clear();
        }
    }

    protected void initNeighbours(Vector neighbours) throws ClusteringException {
        if (this.hadNeighbours()) {
            throw new ClusteringException("This compound had got its neighbours already.");
        }
        this.setNeighbours(neighbours);
    }

    protected void setNeighbours(Vector neighbours) {
        this.clearNeighbours();
        this.neighbours = neighbours;
    }

    protected void calcNeighbours(ChemicalSpace space, int size, float fingerprintWeight) {
        int i;
        this.clearNeighbours();
        float maxDistNeigh = Float.MAX_VALUE;
        float[] distances = new float[size];
        for (i = 0; i < size; ++i) {
            distances[i] = Float.MAX_VALUE;
        }
        for (i = 0; i < space.size(); ++i) {
            float d;
            ACompoundInTheSpace e = (ACompoundInTheSpace)space.elementAt(i);
            if (e == this || !((d = this.wardDistance(e, fingerprintWeight)) < maxDistNeigh)) continue;
            int j = 0;
            boolean added = false;
            do {
                if (!(distances[j] > d)) continue;
                if (j < this.neighbours.size()) {
                    this.neighbours.insertElementAt(e, j);
                    added = true;
                } else {
                    this.neighbours.add(e);
                    added = true;
                }
                if (this.neighbours.size() > size) {
                    this.neighbours.removeElementAt(size);
                }
                System.arraycopy(distances, j, distances, j + 1, size - 1 - j);
                distances[j] = d;
            } while (++j < size && !added);
            maxDistNeigh = distances[size - 1];
        }
    }

    protected ACompoundInTheSpace getFirstNeighbour(ChemicalSpace space, int size, float fingerprintWeight) {
        if (!this.hasNeighbours()) {
            this.calcNeighbours(space, size, fingerprintWeight);
        }
        if (this.neighbours.size() == 0) {
            this.calcNeighbours(space, size, fingerprintWeight);
        }
        return (ACompoundInTheSpace)this.neighbours.firstElement();
    }

    protected void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public float[] coordinates() {
        return this.coordinates;
    }

    public Fingerprint fingerprint() {
        return this.fp;
    }

    public void clearData() {
        this.fp = null;
        this.coordinates = null;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    protected void finalize() {
        this.clearNeighbours();
        --this.compounds;
    }
}

