/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.ACompoundInTheSpace;
import chemaxon.clustering.chemistry.Fingerprint;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public final class ChemicalSpace
extends Vector {
    private float[] weights;
    private InvertedFile inv = null;
    private int dimensions;
    private int fpsize;
    private BitSet emptyset = null;
    private BitSet checked = null;
    private boolean willett = false;

    public ChemicalSpace(float[] weights, int fpsize, int dimensions) {
        super(10000, 10000);
        this.weights = weights;
        this.dimensions = dimensions;
        this.fpsize = fpsize;
        this.willett = this.willett;
    }

    public float[] getWeights() {
        return this.weights;
    }

    public int getFpsize() {
        return this.fpsize;
    }

    public int getDim() {
        return this.dimensions;
    }

    public float distance(ACompoundInTheSpace c1, ACompoundInTheSpace c2) {
        return c1.distance(c2, this.weights[0]);
    }

    public void useWillett() {
        this.willett = true;
    }

    public synchronized Collection neighbours(ACompoundInTheSpace c, float threshold) throws Exception {
        Vector<ACompoundInTheSpace> neighbours = new Vector<ACompoundInTheSpace>();
        if (!this.willett || this.dimensions != 0) {
            int cb = c.fingerprint().brightness();
            for (ACompoundInTheSpace q : this) {
                float dist;
                if (q == c) continue;
                int qb = q.fingerprint().brightness();
                int n = cb < qb ? cb : qb;
                int min = n;
                float lb = 1.0f - (float)min / (float)(cb + qb - min);
                if (!(lb <= threshold) || !((dist = this.distance(q, c)) <= threshold)) continue;
                neighbours.add(q);
            }
        } else {
            this.checked.and(this.emptyset);
            Fingerprint fp = c.fingerprint();
            int m = 0;
            for (int i = 0; i < this.fpsize; ++i) {
                ACompoundInTheSpace q;
                int it;
                Column col = this.inv.columns[i];
                boolean used = fp.get(col.index);
                if (!used) continue;
                ++m;
                int cb = fp.brightness();
                int cm = Math.min(cb - m + 1, col.smax);
                float lb = 1.0f - (float)cm / (float)(cb + col.smin - cm);
                if (lb <= threshold) {
                    for (it = 0; it < this.size(); ++it) {
                        float dist;
                        if (this.checked.get(it) || (q = (ACompoundInTheSpace)this.elementAt(it)) == c || !q.fingerprint().get(col.index)) continue;
                        int cu = Math.min(cb - m + 1, q.fingerprint().brightness());
                        float tcu = 1.0f - (float)cu / (float)(cb + q.fingerprint().brightness() - cu);
                        if (tcu <= threshold && (dist = this.distance(q, c)) <= threshold) {
                            neighbours.add(q);
                        }
                        this.checked.set(it);
                    }
                    continue;
                }
                for (it = 0; it < this.size(); ++it) {
                    q = (ACompoundInTheSpace)this.elementAt(it);
                    if (!q.fingerprint().get(col.index)) continue;
                    this.checked.set(it);
                }
            }
        }
        neighbours.trimToSize();
        return neighbours;
    }

    public synchronized void clearData(float threshold) {
        for (int i = 0; i < this.elementCount; ++i) {
            ACompoundInTheSpace c = (ACompoundInTheSpace)this.elementData[i];
            c.clearData();
        }
    }

    public void prepareInvertedFile() {
        this.inv = new InvertedFile(this.fpsize, this);
        this.emptyset = new BitSet(this.size());
        this.checked = new BitSet(this.size());
    }

    public void updateNeighbours(ACompoundInTheSpace q, ACompoundInTheSpace rem1, ACompoundInTheSpace rem2, float fingerprintWeight) {
        for (int i = 0; i < this.size(); ++i) {
            ACompoundInTheSpace e = (ACompoundInTheSpace)this.elementAt(i);
            Vector neighbours = e.neighbours();
            if (neighbours == null || neighbours.size() < 1) continue;
            for (int j = neighbours.size() - 1; j >= 0; --j) {
                ACompoundInTheSpace te = (ACompoundInTheSpace)neighbours.elementAt(j);
                if (te != rem1 && te != rem2) continue;
                neighbours.removeElementAt(j);
            }
            float lastDist = neighbours.size() > 0 ? e.wardDistance((ACompoundInTheSpace)neighbours.lastElement(), fingerprintWeight) : Float.MAX_VALUE;
            float newCmpDist = e.wardDistance(q, fingerprintWeight);
            if (!(newCmpDist < lastDist)) continue;
            for (int j = neighbours.size() - 2; j >= 0; --j) {
                float prevDist = e.wardDistance((ACompoundInTheSpace)neighbours.elementAt(j), fingerprintWeight);
                if (newCmpDist >= prevDist) {
                    neighbours.insertElementAt(q, j + 1);
                    j = -1;
                }
                if (j != 0 || !(newCmpDist < prevDist)) continue;
                neighbours.insertElementAt(q, 0);
            }
        }
    }

    private class InvertedFile {
        public Column[] columns = null;

        InvertedFile(int fpsize, ChemicalSpace space) {
            this.columns = new Column[fpsize];
            this.init(space);
        }

        private void init(ChemicalSpace space) {
            Iterator i = space.iterator();
            for (int c = 0; c < this.columns.length; ++c) {
                this.columns[c] = new Column(c);
            }
            while (i.hasNext()) {
                ACompoundInTheSpace q = (ACompoundInTheSpace)i.next();
                Fingerprint fp = q.fingerprint();
                for (int c = 0; c < this.columns.length; ++c) {
                    if (!fp.get(c)) continue;
                    Column col = this.columns[c];
                    ++col.length;
                    col.smax = col.isnew ? fp.brightness() : Math.max(col.smax, fp.brightness());
                    col.smin = col.isnew ? fp.brightness() : Math.min(col.smin, fp.brightness());
                    col.isnew = false;
                }
            }
            Arrays.sort(this.columns);
        }
    }

    private class Column
    implements Comparable {
        int length = 0;
        int smax = 0;
        int smin = 0;
        int index = 0;
        boolean isnew = true;

        public Column(int index) {
            this.index = index;
        }

        public int compareTo(Object o) {
            return this.compareTo((Column)o);
        }

        public int compareTo(Column o) {
            return this.length - o.length;
        }

        public String toString() {
            return this.index + ". (" + this.length + ") " + this.smin + "-" + this.smax;
        }
    }
}

