/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.jchem.db.SettingsHandler;
import chemaxon.util.CLQ;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClusterStatistics {
    private static final String nl = System.getProperty("line.separator");
    private static final String home = System.getProperty("user.home");
    private static final String helptext = "ClStat, (C) 1999-2012 ChemAxon Ltd." + nl + "Variable length Jarvis-Patrick clustering." + nl + "Usage:" + nl + "  clstat [options]" + nl + "" + nl + "" + "Options: " + nl + "  -h  --help                    this help message" + nl + "  -i  --input <filepath>        input file" + nl + "  -C  --cluster <col>[:<count>] name of columns storing the clusters (indexes)." + nl + "                                <count> is the occurence of the column." + nl + "  -c \"<f1><OP><value><LOGOP><f2><OP><value>&...\"" + nl + "                                filtering by the values of fields" + nl + "                                <OP> may be: =,<,>,<=,>=" + nl + "                                <LOGOP> may be: either & or |, but not both" + nl + "  -o  --output <filepath>       output file" + nl + "  -v  --verbose                 verbose output" + nl + "";
    BufferedReader input = null;
    PrintStream output = null;
    String clusterName;
    int clusterOcc;
    String[] condNames = null;
    private static final int LESS = -2;
    private static final int LESS_OR_EQUAL = -1;
    private static final int EQUAL = 0;
    private static final int GREATER_OR_EQUAL = 1;
    private static final int GREATER = 2;
    int[] condOPs = null;
    String[] condValues = null;
    char condSeparator;
    Vector statVector = new Vector(100);

    public void run() throws IOException {
        int i;
        int index = 0;
        int objectCounter = 0;
        int[] condIdxs = new int[this.condNames.length];
        for (int i2 = 0; i2 < condIdxs.length; ++i2) {
            condIdxs[i2] = -1;
        }
        int clusterIdx = -1;
        String line = null;
        int headerCounter = 0;
        while (!((line = this.input.readLine()) == null || line.trim().equals("") && clusterIdx >= 0)) {
            String token;
            StringTokenizer st = new StringTokenizer(line, "\t");
            int tokenIdx = 0;
            if (this.clusterName != null && clusterIdx < 0 || this.clusterName == null && index == 0) {
                if (condIdxs != null) {
                    for (i = 0; i < condIdxs.length; ++i) {
                        condIdxs[i] = -1;
                    }
                }
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (this.clusterName != null && token.equals(this.clusterName)) {
                        clusterIdx = tokenIdx;
                        ++headerCounter;
                    }
                    if (this.condNames != null) {
                        for (int j = 0; j < this.condNames.length; ++j) {
                            if (!token.equals(this.condNames[j])) continue;
                            condIdxs[j] = tokenIdx;
                        }
                    }
                    ++tokenIdx;
                }
                if (headerCounter < this.clusterOcc) {
                    clusterIdx = -1;
                }
            } else {
                Stat stat;
                int nextTabIndex;
                boolean condOK = this.condSeparator == '&';
                boolean found = false;
                int cluster = -1;
                int tabIndex = -1;
                do {
                    if ((nextTabIndex = line.indexOf("\t", tabIndex + 1)) < 0) {
                        nextTabIndex = line.length();
                    }
                    token = line.substring(tabIndex + 1, nextTabIndex);
                    for (int i3 = 0; i3 < this.condOPs.length && (this.condSeparator == '&' ? condOK : !condOK); ++i3) {
                        if (tokenIdx != condIdxs[i3]) continue;
                        if (this.condSeparator == '&') {
                            if (this.checkCond(token, this.condOPs[i3], this.condValues[i3])) continue;
                            condOK = false;
                            continue;
                        }
                        if (!this.checkCond(token, this.condOPs[i3], this.condValues[i3])) continue;
                        condOK = true;
                    }
                    if (this.clusterName != null && tokenIdx == clusterIdx) {
                        cluster = Integer.parseInt(token);
                    }
                    ++tokenIdx;
                } while ((tabIndex = nextTabIndex) < line.length());
                if (this.statVector.size() < cluster) {
                    this.statVector.setSize(cluster);
                }
                if ((stat = (Stat)this.statVector.elementAt(cluster - 1)) == null) {
                    stat = new Stat();
                    this.statVector.setElementAt(stat, cluster - 1);
                }
                ++stat.countAll;
                if (condOK) {
                    ++stat.countTrue;
                }
                ++objectCounter;
            }
            ++index;
        }
        if (this.clusterName != null && clusterIdx < 0) {
            throw new IOException("Column " + this.clusterName + " not found.");
        }
        int activeClusters = 0;
        int allObjectsInActiveClusters = 0;
        int activeObjects = 0;
        this.output.println(this.clusterName + "\t" + "all\tactives");
        for (i = 0; i < this.statVector.size(); ++i) {
            Stat stat = (Stat)this.statVector.elementAt(i);
            this.output.println(i + 1 + "\t" + (stat == null ? 0 : stat.countAll) + "\t" + (stat == null ? 0 : stat.countTrue));
            if (stat.countTrue <= 0) continue;
            ++activeClusters;
            allObjectsInActiveClusters += stat.countAll;
            activeObjects += stat.countTrue;
        }
        int allObjects = objectCounter;
        float propActives = (float)activeObjects / (float)allObjects;
        int allClusters = this.statVector.size();
        float propActiveClusters = (float)activeClusters / (float)allClusters;
        float propActivesInActiveClusters = (float)activeObjects / (float)allObjectsInActiveClusters;
        this.output.println();
        this.output.println("STATISTICS");
        this.output.println();
        this.output.println("All objects = " + allObjects);
        this.output.println("Active objects = " + activeObjects);
        this.output.println("Proportion of actives = " + propActives);
        this.output.println("All clusters = " + allClusters);
        this.output.println("Active clusters = " + activeClusters);
        this.output.println("Proportion of active clusters = " + propActiveClusters);
        this.output.println("All objects in active clusters = " + allObjectsInActiveClusters);
        this.output.println("Proportion of actives in active clusters = " + propActivesInActiveClusters);
        this.output.println("Enrichment factor = " + propActivesInActiveClusters / propActives);
    }

    private boolean checkCond(String a, int OP, String b) {
        try {
            float fa = Float.parseFloat(a);
            float fb = Float.parseFloat(b);
            switch (OP) {
                case 0: {
                    return fa == fb;
                }
                case 2: {
                    return fa > fb;
                }
                case -2: {
                    return fa < fb;
                }
                case 1: {
                    return fa >= fb;
                }
                case -1: {
                    return fa <= fb;
                }
            }
        }
        catch (Throwable t) {
            int res = a.compareTo(b);
            switch (OP) {
                case 0: {
                    return res == 0;
                }
                case 2: {
                    return res > 0;
                }
                case -2: {
                    return res < 0;
                }
                case 1: {
                    return res >= 0;
                }
                case -1: {
                    return res <= 0;
                }
            }
        }
        return false;
    }

    public static void main(String[] args) {
        Properties p = new Properties();
        CLQ clq = new CLQ(args, p);
        CLQ.Parameter verbose = null;
        SettingsHandler settingsHandler = null;
        try {
            settingsHandler = new SettingsHandler();
            p = settingsHandler.getSettings();
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            if (clq.lookup("-h", "--help", "", 1, false, false) != null) {
                System.out.println(helptext);
                return;
            }
            verbose = clq.lookup("-v", "--verbose", "", 1, false, false);
            CLQ.Parameter inputfile = clq.lookup("-i", "--input", "", 2, false, false);
            InputStream is = inputfile == null ? System.in : new FileInputStream(inputfile.getString());
            BufferedReader input = new BufferedReader(new InputStreamReader(is));
            CLQ.Parameter outputfile = clq.lookup("-o", "--output", "", 2, false, false);
            PrintStream output = outputfile == null ? System.out : new PrintStream(new FileOutputStream(outputfile.getString()));
            CLQ.Parameter cond = clq.lookup("-c", "--condition", "", 2, true, false);
            String fullCondString = cond.getString();
            if (fullCondString.indexOf("&") >= 0 && fullCondString.indexOf("|") >= 0) {
                throw new Exception("'&' and '|' at the same time is not supported.");
            }
            int condSeparator = fullCondString.indexOf("&") >= 0 ? 38 : 124;
            StringTokenizer stCond = new StringTokenizer(fullCondString, "&|");
            int condCount = stCond.countTokens();
            String[] condNames = new String[condCount];
            int[] condOPs = new int[condCount];
            String[] condValues = new String[condCount];
            for (int condIndex = 0; condIndex < condCount; ++condIndex) {
                String condString = stCond.nextToken();
                String OPString = null;
                if (condString.indexOf(">=") > 0) {
                    condOPs[condIndex] = 1;
                    OPString = ">=";
                } else if (condString.indexOf("<=") > 0) {
                    condOPs[condIndex] = -1;
                    OPString = "<=";
                } else if (condString.indexOf("=") > 0) {
                    condOPs[condIndex] = 0;
                    OPString = "=";
                } else if (condString.indexOf(">") > 0) {
                    condOPs[condIndex] = 2;
                    OPString = ">";
                } else if (condString.indexOf("<") > 0) {
                    condOPs[condIndex] = -2;
                    OPString = "<";
                } else {
                    System.err.println("Unknown operator in " + condString);
                    System.exit(1);
                }
                try {
                    int index = condString.indexOf(OPString);
                    condNames[condIndex] = condString.substring(0, index);
                    condValues[condIndex] = condString.substring(index + OPString.length());
                    continue;
                }
                catch (Throwable t) {
                    System.err.println("Error in condition: " + condString);
                }
            }
            CLQ.Parameter clusterName = clq.lookup("-C", "--cluster", "", 2, true, false);
            ClusterStatistics gs = new ClusterStatistics();
            gs.input = input;
            gs.output = output;
            gs.condSeparator = (char)condSeparator;
            gs.condNames = condNames;
            gs.condOPs = condOPs;
            gs.condValues = condValues;
            gs.clusterName = clusterName == null ? null : clusterName.getString();
            gs.clusterOcc = 1;
            if (clusterName != null && gs.clusterName.indexOf(":") > 0) {
                StringTokenizer st = new StringTokenizer(gs.clusterName, ":");
                int dataNameCount = st.countTokens();
                gs.clusterName = st.nextToken();
                try {
                    gs.clusterOcc = Integer.parseInt(st.nextToken());
                }
                catch (Throwable t) {
                    throw new Exception("The id column parameter is invalid.");
                }
            }
            gs.run();
        }
        catch (Throwable thr) {
            if (thr.getMessage() != null) {
                System.err.println("Error: " + thr.getMessage());
                if (verbose != null) {
                    thr.printStackTrace();
                }
            } else {
                System.err.println("Unknown error");
                thr.printStackTrace();
            }
            System.exit(1);
        }
    }

    class Stat {
        int countAll = 0;
        int countTrue = 0;
    }
}

