/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.jchem.db.SettingsHandler;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.util.CLQ;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class CreateView {
    private static final String nl = System.getProperty("line.separator");
    private static final String home = System.getProperty("user.home");
    private static final String helptext = "CreateView " + VersionInfo.JCHEM_VERSION + ", (C) 1999-2012 ChemAxon Ltd." + nl + "Composing SDfiles from SDfiles and clustering output." + nl + "Usage:" + nl + "  crview [options]" + nl + "" + nl + "" + "Options: " + nl + " -h  --help                        this help message" + nl + " -s  --input-sdf <file>            input SDfile" + nl + " -t  --input-table <file>          input table (id values and other data)" + nl + " -o  --output-sdf <file>           output SDfile" + nl + " -i  --id-name <col>[:<count>]     name of columns storing the ids (indexes)." + nl + "                                   <count> is the occurence of the column." + nl + "                                   default: the id is the line number." + nl + " -d  --data-names <col1>:<col2>... name of columns to include in the SDfile" + nl + " -c  --condition \"<col><OP><cond>\" condition checked. OP may be: =,<,>,<=,>=" + nl + "";
    private BufferedReader sdf;
    private BufferedReader table;
    private PrintStream out;
    Vector records = null;
    String idName;
    int idOcc;
    String[] dataNames;
    String condName;
    String condOP;
    String condValue;

    private void run() throws IOException {
        this.records = this.buildRecords();
        this.createSDF();
    }

    private Vector buildRecords() throws IOException {
        this.records = new Vector();
        int index = 0;
        String line = null;
        int idIdx = -1;
        int[] dataIdxs = this.dataNames == null ? null : new int[this.dataNames.length];
        int condIdx = -1;
        int headerCounter = 0;
        while (!((line = this.table.readLine()) == null || line.trim().equals("") && idIdx >= 0)) {
            String token;
            StringTokenizer st = new StringTokenizer(line);
            int tokenIdx = 0;
            if (this.idName != null && idIdx < 0 || this.idName == null && index == 0) {
                if (dataIdxs != null) {
                    for (int i = 0; i < dataIdxs.length; ++i) {
                        dataIdxs[i] = -1;
                    }
                }
                condIdx = -1;
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (this.idName != null && token.equals(this.idName)) {
                        idIdx = tokenIdx;
                        ++headerCounter;
                    }
                    if (this.dataNames != null) {
                        for (int j = 0; j < this.dataNames.length; ++j) {
                            if (!token.equals(this.dataNames[j])) continue;
                            dataIdxs[j] = tokenIdx;
                        }
                    }
                    if (token.equals(this.condName)) {
                        condIdx = tokenIdx;
                    }
                    ++tokenIdx;
                }
                if (headerCounter < this.idOcc) {
                    idIdx = -1;
                }
            } else {
                int id = index;
                String[] data = dataIdxs == null ? null : new String[dataIdxs.length];
                boolean condOK = false;
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (this.condOP != null && tokenIdx == condIdx && this.checkCond(token, this.condOP, this.condValue)) {
                        condOK = true;
                    }
                    if (this.idName != null && tokenIdx == idIdx) {
                        id = Integer.parseInt(token);
                    }
                    if (dataIdxs != null) {
                        for (int j = 0; j < dataIdxs.length; ++j) {
                            int dataIdx = dataIdxs[j];
                            if (tokenIdx != dataIdx) continue;
                            data[j] = token;
                        }
                    }
                    ++tokenIdx;
                }
                if (this.condOP == null || condOK) {
                    Record r = new Record();
                    r.id = id;
                    r.data = data;
                    this.records.addElement(r);
                }
            }
            ++index;
        }
        if (this.idName != null && idIdx < 0) {
            throw new IOException("Column " + this.idName + " not found.");
        }
        Collections.sort(this.records);
        return this.records;
    }

    private void createSDF() throws IOException {
        StringBuffer sdfRecord;
        Record testRecord = new Record();
        int index = 1;
        boolean isFirst = true;
        while ((sdfRecord = this.getNextFromSDF()) != null) {
            testRecord.id = index++;
            int row = Collections.binarySearch(this.records, testRecord);
            if (row < 0) continue;
            Record r = (Record)this.records.elementAt(row);
            if (this.dataNames != null) {
                for (int i = 0; i < this.dataNames.length; ++i) {
                    if (r.data[i] == null) continue;
                    sdfRecord.append("> <");
                    sdfRecord.append(this.dataNames[i]);
                    sdfRecord.append(">");
                    sdfRecord.append(nl);
                    sdfRecord.append(r.data[i]);
                    sdfRecord.append(nl);
                    sdfRecord.append(nl);
                }
            }
            sdfRecord.append("$$$$");
            if (isFirst) {
                isFirst = false;
            } else {
                this.out.println();
            }
            this.out.print(sdfRecord.toString());
        }
    }

    private StringBuffer getNextFromSDF() throws IOException {
        StringBuffer sb = new StringBuffer();
        String line = null;
        while ((line = this.sdf.readLine()) != null && !line.equals("$$$$")) {
            sb.append(line);
            sb.append(nl);
        }
        return line == null ? null : sb;
    }

    private boolean checkCond(String a, String OP, String b) {
        block11: {
            try {
                float fa = Float.parseFloat(a);
                float fb = Float.parseFloat(b);
                if (OP.equals("=")) {
                    return fa == fb;
                }
                if (OP.equals(">")) {
                    return fa > fb;
                }
                if (OP.equals("<")) {
                    return fa < fb;
                }
                if (OP.equals(">=")) {
                    return fa >= fb;
                }
                if (OP.equals("<=")) {
                    return fa <= fb;
                }
            }
            catch (Throwable t) {
                int res = a.compareTo(b);
                if (OP.equals("=")) {
                    return res == 0;
                }
                if (OP.equals(">")) {
                    return res > 0;
                }
                if (OP.equals("<")) {
                    return res < 0;
                }
                if (OP.equals(">=")) {
                    return res >= 0;
                }
                if (!OP.equals("<=")) break block11;
                return res <= 0;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        Properties p = new Properties();
        CLQ clq = new CLQ(args, p);
        CLQ.Parameter verbose = null;
        SettingsHandler settingsHandler = null;
        try {
            settingsHandler = new SettingsHandler();
            p = settingsHandler.getSettings();
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            if (clq.lookup("-h", "--help", "", 1, false, false) != null) {
                System.out.println(helptext);
                return;
            }
            verbose = clq.lookup("-v", "--verbose", "", 1, false, false);
            CLQ.Parameter sdfile = clq.lookup("-s", "--input-sdf", "", 2, true, false);
            BufferedReader sdf = new BufferedReader(new InputStreamReader(new FileInputStream(sdfile.getString())));
            CLQ.Parameter clfile = clq.lookup("-t", "--table", "", 2, false, false);
            InputStream is = clfile != null ? new FileInputStream(clfile.getString()) : System.in;
            BufferedReader table = new BufferedReader(new InputStreamReader(is));
            CLQ.Parameter idName = clq.lookup("-i", "--id-name", "", 2, false, false);
            CLQ.Parameter dataNames = clq.lookup("-d", "--data-names", "", 2, false, false);
            CLQ.Parameter cond = clq.lookup("-c", "--condition", "", 2, false, false);
            CLQ.Parameter outputfile = clq.lookup("-o", "--output-sdf", "", 2, false, false);
            PrintStream out = outputfile != null ? new PrintStream(new FileOutputStream(outputfile.getString())) : System.out;
            String s = clq.notUsed();
            if (s != null) {
                throw new Exception("Unknown or not supported parameter: " + s);
            }
            CreateView cv = new CreateView();
            cv.sdf = sdf;
            cv.table = table;
            cv.out = out;
            cv.idName = idName == null ? null : idName.getString();
            cv.idOcc = 1;
            if (idName != null && cv.idName.indexOf(":") > 0) {
                StringTokenizer st = new StringTokenizer(cv.idName, ":");
                int dataNameCount = st.countTokens();
                cv.idName = st.nextToken();
                try {
                    cv.idOcc = Integer.parseInt(st.nextToken());
                }
                catch (Throwable t) {
                    throw new Exception("The id column parameter is invalid.");
                }
            }
            if (dataNames == null) {
                cv.dataNames = null;
            } else {
                String names = dataNames.getString();
                StringTokenizer st = new StringTokenizer(names, ":");
                int dataNameCount = st.countTokens();
                cv.dataNames = new String[dataNameCount];
                for (int i = 0; i < dataNameCount; ++i) {
                    cv.dataNames[i] = st.nextToken();
                }
            }
            if (cond == null) {
                cv.condName = null;
            } else {
                String condString = cond.getString();
                cv.condOP = condString.indexOf(">=") > 0 ? ">=" : (condString.indexOf("<=") > 0 ? "<=" : (condString.indexOf("=") > 0 ? "=" : (condString.indexOf(">") > 0 ? ">" : (condString.indexOf("<") > 0 ? "<" : null))));
                if (cv.condOP != null) {
                    int index = condString.indexOf(cv.condOP);
                    cv.condName = condString.substring(0, index);
                    cv.condValue = condString.substring(index + cv.condOP.length());
                }
            }
            cv.run();
            System.exit(0);
        }
        catch (Throwable thr) {
            if (thr.getMessage() != null) {
                System.err.println("Error: " + thr.getMessage());
                if (verbose != null) {
                    thr.printStackTrace();
                }
            } else {
                System.err.println("Unknown error");
                thr.printStackTrace();
            }
            System.exit(1);
        }
    }

    private class Record
    implements Comparable {
        int id;
        String[] data;

        private Record() {
        }

        public int compareTo(Object o) {
            int oid = ((Record)o).id;
            return oid == this.id ? 0 : (oid > this.id ? -1 : 1);
        }
    }
}

