/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.ACompoundInTheSpace;
import chemaxon.clustering.ClusteringException;
import chemaxon.clustering.InvalidLicenseKeyException;
import chemaxon.clustering.JPCluster;
import chemaxon.clustering.NearestNeighbors;
import chemaxon.clustering.SpaceInputStream;
import chemaxon.clustering.SpaceLoader;
import chemaxon.jchem.db.SettingsHandler;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.util.ArgumentException;
import chemaxon.util.CLQ;
import chemaxon.util.ConnectionHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;

public class JarvisPatrick
extends NearestNeighbors {
    private boolean showCentroids = false;
    private boolean isNearNeibCalculation = false;
    private float requiredCommonRatio = 0.0f;
    private boolean singletonsNegative = false;
    private static final String helptext = "Jarp " + VersionInfo.JCHEM_VERSION + ", (C) 1999-2012 ChemAxon Ltd." + lineSep + "Variable length Jarvis-Patrick clustering." + lineSep + "Usage:" + lineSep + "  jarp [options]" + lineSep + "" + lineSep + "" + "General options: " + lineSep + "  -h  --help                    this help message" + lineSep + "  -d  --driver <JDBC driver>    JDBC driver" + lineSep + "  -u  --dburl <url>             URL of database" + lineSep + "  -l  --login <login>           login name" + lineSep + "  -p  --password <password>     password" + lineSep + "  -P  --proptable <table>       property table" + lineSep + "  -s  --saveconf                save settings into" + lineSep + "\"" + configFile + "\"" + lineSep + "" + lineSep + "Input options (default: standard input):" + lineSep + "  -i  --input <filepath>        input file to cluster (text file input)" + lineSep + "  -q  --query <sql>             SQL query for reading input " + lineSep + "                                (database input)" + lineSep + "" + lineSep + "" + "Output options (default: standard output):" + lineSep + "  -o  --output <filepath>       output file path (text file output)" + lineSep + "  -a  --statement <sql>         SQL statement for inserting results" + lineSep + "                                (database output)" + lineSep + "  -x  --central                 calculate and sign central objects" + lineSep + "  -y  --singlet                 singletons get negative cluster ids" + lineSep + "  -z  --statistics              print statistics" + lineSep + "  -Z  --only-statistics         print only statistics" + lineSep + "  -v  --verbose                 verbose output" + lineSep + "" + lineSep + "" + "Data properties" + lineSep + "" + "  -m  --dimensions <dim>        number of floating-point descriptors" + lineSep + "  -f  --fingerprint-size <bits> binary fingerprint size in bits." + lineSep + "                                fpsize should be a multiple of 32" + lineSep + "  -w  --weights <w1> <w2> ...   the weights of the floating-point descriptors" + lineSep + "  -g  --generate-id             generate id for each compound." + lineSep + "" + lineSep + "Clustering conditions" + lineSep + "  -t  --threshold <threshold>   maximum dissimilarity of two compounds " + lineSep + "  -c  --common <ratio>          minimum ratio of common neighbors of two" + lineSep + "                                compounds" + lineSep;

    public void setMinCommonRatio(float ratio) {
        this.requiredCommonRatio = ratio;
    }

    public float getMinCommonRatio() {
        return this.requiredCommonRatio;
    }

    public void setSingletonNegative(boolean b) {
        this.singletonsNegative = b;
    }

    public boolean isSingletonNegative() {
        return this.singletonsNegative;
    }

    public void setCentralShown(boolean b) {
        this.showCentroids = b;
    }

    public boolean isCentralShown() {
        return this.showCentroids;
    }

    private Iterator notClusteredYet() {
        return new notClusteredCompoundsIterator(this.space);
    }

    private boolean commonNeighboursRatioOK(ACompoundInTheSpace a, ACompoundInTheSpace b, float stopAtRatio) {
        int stopAtCommon;
        int sb;
        if (stopAtRatio == 0.0f) {
            return true;
        }
        if (!a.isANeighbour(b)) {
            return false;
        }
        int sa = a.neighbours().size();
        int min = sa < (sb = b.neighbours().size()) ? sa + 1 : sb + 1;
        float temp = stopAtRatio * (float)min - 2.0f;
        if (temp > (float)(stopAtCommon = (int)temp)) {
            ++stopAtCommon;
        }
        Iterator i = a.neighbours().iterator();
        int common = 0;
        if (stopAtCommon <= sa && stopAtCommon <= sb) {
            while (i.hasNext() && common <= stopAtCommon) {
                ACompoundInTheSpace c = (ACompoundInTheSpace)i.next();
                if (!b.isANeighbour(c)) continue;
                ++common;
            }
            return (float)(common + 2) / (float)min >= stopAtRatio;
        }
        return false;
    }

    private boolean commonNeighboursRatioOK(Collection cluster, ACompoundInTheSpace c, float stopAtRatio) {
        Iterator i = cluster.iterator();
        float max = 0.0f;
        while (i.hasNext()) {
            ACompoundInTheSpace q = (ACompoundInTheSpace)i.next();
            if (!this.commonNeighboursRatioOK(c, q, stopAtRatio)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() throws ClusteringException, IOException, SQLException, InvalidLicenseKeyException {
        long retrTime;
        this.startTime = System.currentTimeMillis();
        this.checkWeights();
        if (this.fpSize % 32 != 0) {
            throw new ClusteringException("Binary fingerprint size must be dividable by 32");
        }
        this.isNearNeibCalculation = this.threshold != 0.0f;
        SpaceLoader loader = this.input != null ? new SpaceInputStream(this.input) : this.db_input;
        this.space = this.threshold != 0.0f ? loader.loadSpace(this.fpSize, this.dimensions, this.weights, !this.generateID) : ((SpaceInputStream)loader).loadSpaceFromNNeibFile();
        long minMemory = this.startMemory;
        JPCluster cluster = null;
        ACompoundInTheSpace q = null;
        ACompoundInTheSpace seed = null;
        Vector<ClusterInfo> ciVector = new Vector<ClusterInfo>();
        int singletonCounter = 0;
        if (this.onlyStat) {
            this.statsNeeded = true;
        }
        Iterator i = this.notClusteredYet();
        long neibTime = retrTime = System.currentTimeMillis();
        if (this.isNearNeibCalculation) {
            this.calcNeighbours(this.threshold);
            neibTime = System.currentTimeMillis();
        }
        if (!this.onlyStat) {
            this.output.printHeader(this.showCentroids);
        }
        int clid = 1;
        int sid = -1;
        while (i.hasNext()) {
            long roundStart = System.currentTimeMillis();
            seed = (ACompoundInTheSpace)i.next();
            cluster = new JPCluster(this.space, seed, clid++);
            for (int j = 0; j < cluster.size(); ++j) {
                ACompoundInTheSpace member = (ACompoundInTheSpace)cluster.elementAt(j);
                Iterator candidates = member.neighbours().iterator();
                while (candidates.hasNext()) {
                    while ((q = (ACompoundInTheSpace)candidates.next()).getCluster() != null && candidates.hasNext()) {
                    }
                    if (q.getCluster() != null || !this.commonNeighboursRatioOK(cluster, q, this.requiredCommonRatio)) continue;
                    cluster.add(q);
                }
            }
            if (this.singletonsNegative && cluster.size() == 1) {
                cluster.setId(sid--);
                --clid;
            }
            if (!this.onlyStat) {
                Iterator it = cluster.iterator();
                int cls = 0;
                while (it.hasNext()) {
                    ACompoundInTheSpace c = (ACompoundInTheSpace)it.next();
                    if (this.showCentroids) {
                        this.output.process(c.getId(), cluster.getId(), ++cls, c.equals(cluster.getCentroid()), c.neighbours().size());
                        continue;
                    }
                    this.output.process(c.getId(), cluster.getId(), ++cls, c.neighbours().size());
                }
            }
            if (cluster.size() > 1) {
                ciVector.add(new ClusterInfo(cluster.getId(), cluster.size(), this.showCentroids ? cluster.getCentroid().getId() : Integer.MIN_VALUE));
            } else {
                ++singletonCounter;
            }
            cluster.clear();
        }
        if (this.statsNeeded) {
            this.statStream.println();
            this.statStream.println("STATISTICS");
            this.statStream.println();
            this.statStream.println("Number of objects = " + this.space.size());
            this.statStream.println("Number of clusters (without singletons) = " + ciVector.size());
            this.statStream.println("Number of singletons = " + singletonCounter);
            this.statStream.println();
            this.statStream.println("List of clusters (without singletons):");
            this.statStream.println("clid\tsize" + (this.showCentroids ? "\tcentr" : ""));
            for (ClusterInfo ci : ciVector) {
                this.statStream.println(ci.id + "\t" + ci.size + (this.showCentroids ? "\t" + ci.central : ""));
            }
            this.statStream.println();
            if (this.isNearNeibCalculation) {
                this.statStream.println("Average dissimilarity = " + this.avgDist);
                this.statStream.println("Minimum dissimilarity = " + this.minDist);
                this.statStream.println("Maximum dissimilarity = " + this.maxDist);
                this.statStream.println();
            }
        }
        long clusTime = System.currentTimeMillis();
    }

    private static boolean init(JarvisPatrick jp, String[] args) throws ArgumentException, FileNotFoundException, SQLException, ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        String s;
        ConnectionHandler conh = null;
        CLQ.Parameter verbose = null;
        Properties p = new Properties();
        try {
            SettingsHandler settingsHandler = new SettingsHandler();
            p = settingsHandler.getSettings();
        }
        catch (IOException exc) {
            // empty catch block
        }
        CLQ clq = new CLQ(args, p);
        if (clq.lookup("-h", "--help", "", 1, false, false) != null) {
            System.out.println(helptext);
            return false;
        }
        Object input = null;
        Object output = null;
        verbose = clq.lookup("-v", "--verbose", "", 1, false, false);
        long startMemory = 0L;
        if (verbose != null) {
            System.err.println("Jarp started at " + new Date());
            Runtime.getRuntime().gc();
            startMemory = Runtime.getRuntime().freeMemory();
            System.err.println("Free memory at start: " + startMemory + " bytes ");
        }
        CLQ.Parameter threshold = clq.lookup("-t", "--threshold", "jarvispatrick.threshold", 2, false, false);
        CLQ.Parameter ratio = clq.lookup("-c", "--common", "jarvispatrick.common", 2, true, false);
        CLQ.Parameter inputfile = clq.lookup("-i", "--input", "", 2, false, false);
        CLQ.Parameter inputquery = null;
        CLQ.Parameter genid = null;
        if (threshold != null) {
            inputquery = clq.lookup("-q", "--query", "", 2, false, false);
            genid = clq.lookup("-g", "--generate-id", "", 1, false, false);
        }
        if (inputfile == null && inputquery == null) {
            jp.setInput(System.in);
        } else {
            if (inputfile != null && inputquery != null) {
                throw new ArgumentException("Ambiguous input");
            }
            if (inputfile != null) {
                jp.setInput(inputfile.getString());
            } else if (inputquery != null) {
                conh = JarvisPatrick.openConn(clq);
                jp.setInput(conh, inputquery.getString());
            }
        }
        CLQ.Parameter dimensions = null;
        CLQ.Parameter fpsize = null;
        int wnum = 0;
        CLQ.Parameter pweights = null;
        float[] weights = null;
        if (threshold != null) {
            dimensions = clq.lookup("-m", "--dimensions", "", 2, false, false);
            fpsize = clq.lookup("-f", "--fingerprint-size", "fingerprint.size", 2, true, true);
            if (fpsize.getInt() % 32 != 0) {
                throw new ArgumentException("Binary fingerprint size must be dividable by 32");
            }
            wnum = dimensions != null ? dimensions.getInt() : 0;
            pweights = clq.lookup("-w", "--weights", "", wnum + 1, false, false);
            weights = new float[wnum];
            for (int i = 0; i < wnum; ++i) {
                weights[i] = pweights != null ? (float)pweights.getDouble(i) : 1.0f;
            }
        }
        CLQ.Parameter willett = clq.lookup("-willett", "--willett", "", 1, false, false);
        CLQ.Parameter centroid = null;
        CLQ.Parameter stat = null;
        CLQ.Parameter onlyStat = null;
        if (threshold != null) {
            centroid = clq.lookup("-x", "--central", "", 1, false, false);
        }
        stat = clq.lookup("-z", "--statistics", "", 1, false, false);
        onlyStat = clq.lookup("-Z", "--only-statistics", "", 1, false, false);
        CLQ.Parameter singletonsNegative = clq.lookup("-y", "--singlet", "", 1, false, false);
        CLQ.Parameter outputfile = clq.lookup("-o", "--output", "", 2, false, false);
        CLQ.Parameter outputquery = clq.lookup("-a", "--statement", "", 2, false, false);
        if (outputfile == null && outputquery == null) {
            jp.setOutput(System.out);
        } else {
            if (outputfile != null && outputquery != null) {
                throw new ArgumentException("Ambiguous output");
            }
            if (outputfile != null) {
                jp.setOutput(outputfile.getString());
            } else if (outputquery != null) {
                if (conh == null) {
                    conh = JarvisPatrick.openConn(clq);
                }
                jp.setOutput(conh.getConnection(), outputquery.getString());
            }
        }
        CLQ.Parameter store = clq.lookup("-s", "--saveconf", "", 1, false, false);
        if (store != null) {
            JarvisPatrick.saveConfig(p);
        }
        if ((s = clq.notUsed()) != null) {
            throw new ArgumentException("Unknown or unnecessary parameter: " + s);
        }
        jp.setFpSize(fpsize != null ? fpsize.getInt() : 0);
        jp.setDimensions(dimensions != null ? dimensions.getInt() : 0);
        if (weights != null) {
            jp.setWeights(weights);
        }
        jp.setIdGeneration(genid != null);
        jp.setThreshold(threshold == null ? 0.0f : (float)threshold.getDouble());
        jp.setMinCommonRatio((float)ratio.getDouble());
        jp.setCentralShown(centroid != null);
        jp.setSingletonNegative(singletonsNegative != null);
        jp.setStatNeeded(stat != null);
        jp.setOnlyStat(onlyStat != null);
        return true;
    }

    public static void main(String[] args) {
        JarvisPatrick jp = new JarvisPatrick();
        try {
            long startTime = System.currentTimeMillis();
            if (JarvisPatrick.init(jp, args)) {
                jp.run();
            }
            System.exit(0);
        }
        catch (InvalidLicenseKeyException exi) {
            System.err.println(exi.getMessage());
            System.exit(1);
        }
        catch (Throwable thr) {
            if (thr.getMessage() != null) {
                System.err.println("Error: " + thr.getMessage());
            } else {
                System.err.println("Unknown error");
                thr.printStackTrace();
            }
            System.exit(1);
        }
    }

    private class notClusteredCompoundsIterator
    implements Iterator {
        ListIterator i = null;
        Object current = null;

        notClusteredCompoundsIterator(List space) {
            this.i = space.listIterator();
            if (this.i.hasNext()) {
                this.current = this.i.next();
            }
        }

        public void nextNotClustered() {
            while (this.current != null && ((ACompoundInTheSpace)this.current).getCluster() != null && this.i.hasNext()) {
                this.current = (ACompoundInTheSpace)this.i.next();
            }
            this.current = ((ACompoundInTheSpace)this.current).getCluster() == null ? this.current : null;
        }

        public Object next() {
            Object t = this.current;
            this.nextNotClustered();
            if (this.current == null) {
                throw new NoSuchElementException(t + "(" + ((ACompoundInTheSpace)t).getCluster().getId() + ")");
            }
            Object next = this.current;
            if (this.i.hasNext()) {
                this.current = this.i.next();
            }
            return next;
        }

        @Override
        public boolean hasNext() {
            this.nextNotClustered();
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ClusterInfo {
        int id;
        int size;
        int central;

        public ClusterInfo(int id, int size, int central) {
            this.id = id;
            this.size = size;
            this.central = central;
        }
    }
}

