/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.MBaseNode;
import chemaxon.clustering.MGraph;
import chemaxon.clustering.MultiNode;
import chemaxon.clustering.SmilesNode;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class MultiSmilesNode
extends SmilesNode
implements MultiNode {
    private Vector listOfInstances = null;

    private void initList() {
        this.listOfInstances = new Vector(2, 2);
        this.listOfInstances.add(this);
    }

    public MultiSmilesNode() {
    }

    public MultiSmilesNode(Molecule m) {
        super(m);
        this.initList();
    }

    public MultiSmilesNode(Molecule m, MGraph g) {
        super(m, g);
        this.initList();
    }

    public MultiSmilesNode(MultiNode m) {
        super(m.getMolecule());
        MBaseNode copyNode = m.instance(0);
        this.propertyContainer = new MPropertyContainer();
        for (int i = 0; i < copyNode.getPropertyCount(); ++i) {
            this.setPropertyObject(copyNode.getPropertyKey(i), copyNode.getPropertyObject(copyNode.getPropertyKey(i)));
        }
        this.listOfInstances = m.getInstances();
        this.listOfInstances.add(this);
    }

    @Override
    public Vector getInstances() {
        return this.listOfInstances;
    }

    @Override
    public int countInstances() {
        return this.listOfInstances.size();
    }

    @Override
    public MBaseNode instance(int i) {
        if (i < 0 || i >= this.countInstances()) {
            return null;
        }
        return (MBaseNode)this.listOfInstances.elementAt(i);
    }

    @Override
    protected void loadNodeData(ObjectInputStream in, Vector multiNodes) throws IOException, ClassNotFoundException {
        super.loadNodeData(in, multiNodes);
        int multiID = in.readInt();
        int indexInMultiNodes = -1;
        for (int i = 0; i < multiNodes.size(); ++i) {
            if (indexInMultiNodes <= -1 && (Integer)((Object[])multiNodes.get(i))[0] != multiID) continue;
            indexInMultiNodes = i;
        }
        if (indexInMultiNodes == -1) {
            this.initList();
            Object[] insertMultiNode = new Object[]{new Integer(multiID), this};
            multiNodes.add(insertMultiNode);
        } else {
            MultiNode m = (MultiNode)((Object[])multiNodes.get(indexInMultiNodes))[1];
            Molecule molec = m.getMoleculeWithProperty();
            this.smilesRepresent = molec.toFormat("smiles");
            this.propertyContainer = molec.properties();
            this.listOfInstances = m.getInstances();
            this.listOfInstances.add(this);
        }
    }

    @Override
    public void saveNodeData(ObjectOutputStream out, Vector multiNodes, Integer actualSerialForMultiNodes) throws IOException {
        super.saveNodeData(out, multiNodes, actualSerialForMultiNodes);
        int indexInMultiNodes = -1;
        for (int i = 0; indexInMultiNodes == -1 && i < multiNodes.size(); ++i) {
            indexInMultiNodes = this.listOfInstances.indexOf(((Object[])multiNodes.get(i))[1]);
        }
        if (indexInMultiNodes == -1) {
            Object[] insertMultiNode = new Object[]{actualSerialForMultiNodes, this};
            multiNodes.add(insertMultiNode);
            out.writeInt(actualSerialForMultiNodes);
            actualSerialForMultiNodes = new Integer(actualSerialForMultiNodes + 1);
        } else {
            out.writeInt((Integer)((Object[])multiNodes.get(indexInMultiNodes))[0]);
        }
    }

    @Override
    public MBaseNode copy() {
        return new MultiSmilesNode(this);
    }
}

