/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.ResultProcessor;
import java.io.PrintStream;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class ResultPrintStream
implements ResultProcessor {
    protected PrintStream ps = null;
    protected int index = 0;
    protected int col = 0;
    protected NumberFormat nf = new DecimalFormat("#0.0000");
    protected boolean isFormating = true;
    protected long start = System.currentTimeMillis();

    ResultPrintStream(PrintStream ps) {
        this.ps = ps;
    }

    public void setFormating(boolean isFormating) {
        this.isFormating = isFormating;
    }

    @Override
    public void printHeader(boolean printCentroid) {
        this.ps.println("id\tclid" + (printCentroid ? "\tcentr" : ""));
    }

    @Override
    public void process(int id, int clusterid, int clustersize, boolean centroid, int numofneighbours) throws SQLException {
        this.ps.println(id + "\t" + clusterid + "\t" + (centroid ? "@" : ""));
    }

    @Override
    public void process(int id, int clusterid, int clustersize, int numofneighbours) throws SQLException {
        this.ps.println(id + "\t" + clusterid);
    }

    @Override
    public void setInt(int value) throws SQLException {
        if (this.col++ > 0) {
            this.ps.print("\t");
        }
        this.ps.print(value);
    }

    @Override
    public void setFloat(float value) throws SQLException {
        if (this.col++ > 0) {
            this.ps.print("\t");
        }
        if (this.isFormating) {
            this.ps.print(this.nf.format(value));
        } else {
            this.ps.print(value);
        }
    }

    @Override
    public void writeln() throws SQLException {
        this.ps.println();
        this.col = 0;
    }

    @Override
    public void writeHeader(String line) {
        this.ps.println(line);
    }
}

