/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.descriptors.ChemicalFingerprint;
import chemaxon.struc.StaticMolecule;
import chemaxon.util.Heap;
import java.util.Arrays;

class SimilarityMatrix {
    public static final float DEFAULT_MAX_ALLOWED_PAIR_RATIO = 0.1f;
    public static final int DEFAULT_MAX_MEMORY_KB = 4096;
    private static final int MIN_SIMILARS_STORED = 1000;
    private float maxAllowedPairRatio = 0.1f;
    private int maxMemoryKB = 4096;
    private int maxMoleculeCount;
    Heap similars;
    StaticMolecule[] mols;
    int molsCount;
    ChemicalFingerprint[] cfps;
    boolean[] deleted = null;
    int[] deletedPair = null;
    int deletedPairCount = 0;
    int totalcall = 0;

    public SimilarityMatrix(int maxMolecules) {
        this.maxMoleculeCount = maxMolecules;
    }

    public void maxPairRatio(float maxAllowedPairRatio) {
        this.maxAllowedPairRatio = maxAllowedPairRatio;
    }

    public void maxMemoryKB(int maxMemoryKB) {
        this.maxMemoryKB = maxMemoryKB;
    }

    public void initialize() {
        int similarsHeapSize = this.calcHeapSize();
        this.allocate(similarsHeapSize);
    }

    public void clear() {
        this.similars.clear();
        Arrays.fill(this.mols, null);
        Arrays.fill(this.cfps, null);
        Arrays.fill(this.deleted, false);
        this.deletedPairCount = 0;
        this.molsCount = 0;
    }

    public void addMolecule(StaticMolecule mol, ChemicalFingerprint cfp) {
        ++this.totalcall;
        for (int i = 0; i < this.molsCount; ++i) {
            this.similars.insert(cfp.getCommonBitCount(this.cfps[i]), new SimilarityPair(i, this.molsCount));
        }
        this.mols[this.molsCount] = mol;
        this.cfps[this.molsCount] = cfp;
        ++this.molsCount;
    }

    int pairIndex(int i, int j) {
        return Math.min(j, i) * this.maxMoleculeCount + Math.max(j, i);
    }

    public boolean isDeleted(int index) {
        return this.deleted[index];
    }

    private boolean isDeletedPair(int i, int j) {
        int pi = this.pairIndex(i, j);
        for (int s = 0; s < this.deletedPairCount; ++s) {
            if (this.deletedPair[s] != pi) continue;
            return true;
        }
        return false;
    }

    public boolean empty() {
        return this.similars == null || this.similars.size() == 0;
    }

    public float getMostSimlarsScore() {
        return this.similars.findMin();
    }

    public int getSimIndex1() {
        return ((SimilarityPair)this.similars.getMinData()).index1;
    }

    public int getSimIndex2() {
        return ((SimilarityPair)this.similars.getMinData()).index2;
    }

    public void deleteMostSimilarMolecules() {
        SimilarityPair top = (SimilarityPair)this.similars.getMinData();
        for (int i = this.similars.size() - 1; i > 0; --i) {
            SimilarityPair c = (SimilarityPair)this.similars.getData(i);
            if (c.index1 != top.index1 && c.index1 != top.index2 && c.index2 != top.index1 && c.index2 != top.index2) continue;
            this.similars.deleteNoSort(i);
        }
        this.similars.deleteNoSort(0);
        this.similars.heapify();
        this.deleted[top.index2] = true;
        this.deleted[top.index1] = true;
    }

    public void deleteMostSimilarPair() {
        SimilarityPair top = (SimilarityPair)this.similars.getMinData();
        if (this.deletedPairCount == this.deletedPair.length) {
            int[] newDeletedPair = new int[this.deletedPairCount * 2];
            System.arraycopy(this.deletedPair, 0, newDeletedPair, 0, this.deletedPairCount);
            this.deletedPair = newDeletedPair;
        }
        this.deletedPair[this.deletedPairCount++] = this.pairIndex(top.index1, top.index2);
        this.similars.deleteMin();
    }

    public void deleteItem(int index) {
        for (int i = this.similars.size() - 1; i >= 0; --i) {
            SimilarityPair c = (SimilarityPair)this.similars.getData(i);
            if (c.index1 != index && c.index2 != index) continue;
            this.similars.deleteNoSort(i);
        }
        this.similars.heapify();
        this.deleted[index] = true;
    }

    public void renew() {
        for (int i = 0; i < this.molsCount; ++i) {
            if (this.deleted[i]) continue;
            for (int j = 0; j < i; ++j) {
                if (this.deleted[j] || this.isDeletedPair(i, j)) continue;
                this.similars.insert(this.cfps[i].getCommonBitCount(this.cfps[j]), new SimilarityPair(i, j));
            }
        }
    }

    private void allocate(int heapSize) {
        this.similars = new Heap(heapSize, 2);
        this.mols = new StaticMolecule[this.maxMoleculeCount];
        this.cfps = new ChemicalFingerprint[this.maxMoleculeCount];
        this.deleted = new boolean[this.maxMoleculeCount];
        this.deletedPair = new int[this.maxMoleculeCount * 10];
    }

    private int calcHeapSize() {
        int heapSize;
        long memoryKBByPairRatio;
        int wordSize = 4;
        int internalSizeInKB = (this.maxMoleculeCount * wordSize + this.maxMoleculeCount * wordSize + this.maxMoleculeCount * wordSize + this.maxMoleculeCount * wordSize) / 1024 + 1;
        int sizeOfOneHeapNode = 4 + wordSize + 2 * wordSize;
        long similarsCountByPairRatio = (long)((float)(this.maxMoleculeCount * (this.maxMoleculeCount - 1) / 2) * (this.maxAllowedPairRatio * 100.0f));
        if (similarsCountByPairRatio < 1000L) {
            similarsCountByPairRatio = 1000L;
        }
        if (similarsCountByPairRatio > 10000L) {
            similarsCountByPairRatio = 10000L;
        }
        if ((memoryKBByPairRatio = similarsCountByPairRatio * (long)sizeOfOneHeapNode / 1024L + 1L) > Integer.MAX_VALUE) {
            memoryKBByPairRatio = Integer.MAX_VALUE;
        }
        if (memoryKBByPairRatio + (long)internalSizeInKB <= (long)this.maxMemoryKB) {
            return (int)similarsCountByPairRatio;
        }
        if (this.maxMemoryKB < internalSizeInKB) {
            this.maxMemoryKB = internalSizeInKB;
        }
        return (heapSize = (this.maxMemoryKB - internalSizeInKB) * 1024 / sizeOfOneHeapNode) < 1000 ? 1000 : heapSize;
    }

    public void dump() {
        this.similars.dump();
    }

    public class SimilarityPair {
        int index1;
        int index2;

        SimilarityPair(int index1, int index2) {
            this.index1 = index1;
            this.index2 = index2;
        }

        public String toString() {
            return this.index1 + ", " + this.index2;
        }
    }
}

