/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.MBaseNode;
import chemaxon.clustering.MGraph;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import chemaxon.struc.StaticMolecule;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class SimpleMoleculeNode
extends MBaseNode {
    protected StaticMolecule sm = null;
    protected MPropertyContainer properties;

    public SimpleMoleculeNode() {
    }

    public SimpleMoleculeNode(Molecule m) {
        this.createRepresentation(m);
    }

    public SimpleMoleculeNode(SimpleMoleculeNode n) {
        this.sm = n.sm;
        this.properties = (MPropertyContainer)n.properties.clone();
    }

    public SimpleMoleculeNode(StaticMolecule m) {
        this.sm = m;
        this.properties = new MPropertyContainer();
    }

    public SimpleMoleculeNode(Molecule m, MGraph g) {
        super(g);
        this.createRepresentation(m);
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.sm = null;
    }

    private void createRepresentation(Molecule m) {
        this.sm = new StaticMolecule(m, false);
        this.properties = (MPropertyContainer)m.properties().clone();
    }

    @Override
    public Object getContent() {
        return this.sm;
    }

    @Override
    public Molecule getMolecule() {
        Molecule m = this.sm.toMolecule();
        m.clean(2, null);
        return m;
    }

    @Override
    public Molecule getMoleculeWithProperty() {
        Molecule tmpmol = this.getMolecule();
        for (int i = 0; i < this.getPropertyCount(); ++i) {
            tmpmol.setPropertyObject(this.getPropertyKey(i), this.getPropertyObject(this.getPropertyKey(i)));
        }
        return tmpmol;
    }

    @Override
    public int getPropertyCount() {
        return this.properties.size();
    }

    @Override
    public String getPropertyKey(int i) {
        return this.properties.getKey(i);
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getString(key);
    }

    @Override
    public Object getPropertyObject(String key) {
        return this.properties.getObject(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.setString(key, value);
    }

    @Override
    public void setPropertyObject(String key, Object value) {
        this.properties.setObject(key, value);
    }

    @Override
    public void convertPropertiesToStringProperties() {
        for (int j = 0; j < this.properties.size(); ++j) {
            String propKey = this.properties.getKey(j);
            if (this.properties.getObject(propKey) instanceof String) continue;
            this.properties.setString(propKey, this.properties.getObject(propKey).toString());
        }
    }

    @Override
    protected void loadNodeData(ObjectInputStream in, Vector multiNodes) throws IOException, ClassNotFoundException {
        super.loadNodeData(in, multiNodes);
        this.sm = (StaticMolecule)in.readObject();
    }

    @Override
    public void saveNodeData(ObjectOutputStream out, Vector multiNodes, Integer actualSerialForMultiNodes) throws IOException {
        super.saveNodeData(out, multiNodes, actualSerialForMultiNodes);
        out.writeObject(this.sm == null ? new StaticMolecule() : this.sm);
    }

    @Override
    public MBaseNode copy() {
        return new SimpleMoleculeNode(this);
    }
}

