/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.ACompoundInTheSpace;
import chemaxon.clustering.ChemicalSpace;
import chemaxon.clustering.InvalidLicenseKeyException;
import chemaxon.clustering.SpaceLoader;
import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.util.ConnectionHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

final class SpaceDBLoader
implements SpaceLoader {
    private PreparedStatement pstmt = null;
    private float[] weights = null;
    private boolean isDemoMode = true;
    private boolean readid = true;
    private int actid = 0;

    public SpaceDBLoader(ConnectionHandler conh, String sql) throws SQLException {
        this.pstmt = conh.getConnection().prepareStatement(sql);
        try {
            DatabaseProperties prop = new DatabaseProperties(conh);
            long code = DatabaseOptions.getClusterRegistrationCode(prop);
            if (code != 0L && DatabaseOptions.isValidClusterRegistrationCode(code)) {
                this.isDemoMode = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public ChemicalSpace loadSpace(int fpsize, int dimensions, float[] weights, boolean readid) throws SQLException, InvalidLicenseKeyException {
        ResultSet rs = null;
        this.readid = readid;
        ChemicalSpace space = new ChemicalSpace(weights, fpsize, dimensions);
        this.weights = weights;
        try {
            rs = this.pstmt.executeQuery();
            int i = 0;
            int max = 1000;
            while (rs.next()) {
                space.add(this.loadOne(i, rs, fpsize, dimensions));
                if (this.isDemoMode && i == max) {
                    throw new InvalidLicenseKeyException("Error! Clustering is limited to " + max + " structures in demo mode.\n" + "Please contact sales@chemaxon.com for a license key.");
                }
                ++i;
            }
        }
        catch (SQLException sqle) {
            space.clear();
            space = null;
            throw sqle;
        }
        catch (InvalidLicenseKeyException ile) {
            space.clear();
            space = null;
            throw ile;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (this.pstmt != null) {
                this.pstmt.close();
            }
        }
        space.prepareInvertedFile();
        return space;
    }

    private ACompoundInTheSpace loadOne(int index, ResultSet rs, int fpsize, int dimensions) throws SQLException {
        int j;
        int id;
        float[] coordinates;
        int i = 0;
        int[] fp = new int[fpsize / 32];
        float[] fArray = coordinates = dimensions == 0 ? null : new float[dimensions];
        if (this.readid) {
            id = rs.getInt(1);
            i = 2;
        } else {
            id = ++this.actid;
            i = 1;
        }
        for (j = 0; j < fp.length; ++j) {
            fp[j] = rs.getInt(i);
            ++i;
        }
        for (j = 0; j < dimensions; ++j) {
            coordinates[j] = (float)((double)rs.getFloat(i) * Math.sqrt(this.weights[j + 1]));
            ++i;
        }
        return new ACompoundInTheSpace(index, id, fp, fpsize, coordinates);
    }

    protected void finalize() {
        try {
            this.pstmt.close();
        }
        catch (SQLException exc) {
            exc.printStackTrace();
        }
    }
}

