/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.ACompoundInTheSpace;
import chemaxon.clustering.ChemicalSpace;
import chemaxon.clustering.SpaceLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

final class SpaceInputStream
implements SpaceLoader {
    private BufferedReader br = null;
    private boolean readid;
    private int actid = 0;
    private float[] weights = null;

    public SpaceInputStream(InputStream is) {
        this.br = new BufferedReader(new InputStreamReader(is));
        this.readid = this.readid;
    }

    @Override
    public ChemicalSpace loadSpace(int fpsize, int dimensions, float[] weights, boolean readid) throws IOException {
        ChemicalSpace space = new ChemicalSpace(weights, fpsize, dimensions);
        int index = 0;
        this.weights = weights;
        this.readid = readid;
        String line = null;
        while ((line = this.br.readLine()) != null) {
            ACompoundInTheSpace c = this.loadOne(index, line, fpsize, dimensions);
            space.add(c);
            ++index;
        }
        return space;
    }

    private ACompoundInTheSpace loadOne(int index, String line, int fpsize, int dimensions) throws IOException {
        int i;
        int[] fp = new int[fpsize / 32];
        float[] coordinates = dimensions == 0 ? null : new float[dimensions];
        StringTokenizer st = new StringTokenizer(line);
        int id = this.readid ? Integer.parseInt(st.nextToken()) : ++this.actid;
        for (i = 2; i < fp.length + 2; ++i) {
            fp[i - 2] = Integer.parseInt(st.nextToken());
        }
        int start = i;
        while (i < fp.length + 2 + dimensions) {
            float f = (float)((double)Float.parseFloat(st.nextToken()) * Math.sqrt(this.weights[i - start + 1]));
            if (Float.isNaN(f)) {
                throw new IOException("NaN float value given!");
            }
            coordinates[i - start] = f;
            ++i;
        }
        ACompoundInTheSpace c = new ACompoundInTheSpace(index, id, fp, fpsize, coordinates);
        return c;
    }

    public ChemicalSpace loadSpaceFromNNeibFile() throws IOException {
        ChemicalSpace space = new ChemicalSpace(null, 0, 0);
        int index = 0;
        String line = null;
        while ((line = this.br.readLine()) != null) {
            ACompoundInTheSpace c;
            if (space.size() <= index) {
                space.setSize(index + 1);
            }
            if ((c = (ACompoundInTheSpace)space.get(index)) == null) {
                c = new ACompoundInTheSpace(index, -1, null, 0, null);
            }
            space.set(index, c);
            this.loadOneFromNNeibFile(c, space, line);
            ++index;
        }
        return space;
    }

    private void loadOneFromNNeibFile(ACompoundInTheSpace c, ChemicalSpace space, String line) {
        StringTokenizer st = new StringTokenizer(line);
        int id = Integer.parseInt(st.nextToken());
        c.setId(id);
        while (st.hasMoreTokens()) {
            int nindex = Integer.parseInt(st.nextToken()) - 1;
            if (space.size() <= nindex) {
                space.setSize(nindex + 1);
            }
            ACompoundInTheSpace neib = (ACompoundInTheSpace)space.get(nindex);
            if (space.get(nindex) == null) {
                neib = new ACompoundInTheSpace(nindex, -1, null, 0, null);
                space.set(nindex, neib);
            }
            c.neighbours().add(neib);
        }
    }
}

