/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.ACompoundInTheSpace;
import chemaxon.clustering.Cluster;
import java.util.Iterator;
import java.util.LinkedList;

final class WardCluster
extends LinkedList
implements Cluster {
    private int id;
    private int size = 0;
    private ACompoundInTheSpace centroid = null;

    public WardCluster(ACompoundInTheSpace seed, int id) {
        this.id = id;
        this.add(seed);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String toString() {
        String s = new String();
        s = s.concat("Cluster ").concat(String.valueOf(this.id)).concat(" : ");
        for (ACompoundInTheSpace cmp : this) {
            cmp.setCluster(this);
            s = s.concat(String.valueOf(cmp.getIndex())).concat(", ");
        }
        return s;
    }

    public void setCluster() {
        for (ACompoundInTheSpace cmp : this) {
            cmp.setCluster(this);
        }
    }

    public double distance(ACompoundInTheSpace c, float fingerprintWeight) {
        Iterator i = this.iterator();
        double dist = 0.0;
        while (i.hasNext()) {
            ACompoundInTheSpace ac = (ACompoundInTheSpace)i.next();
            dist += (double)c.wardDistance(ac, fingerprintWeight);
        }
        return dist;
    }

    public ACompoundInTheSpace findCentroid(float fingerprintWeight) {
        double dist;
        ACompoundInTheSpace ac;
        Iterator i = this.iterator();
        ACompoundInTheSpace c = null;
        double min = 0.0;
        if (i.hasNext()) {
            ac = (ACompoundInTheSpace)i.next();
            dist = this.distance(ac, fingerprintWeight);
            c = ac;
            min = this.distance(c, fingerprintWeight);
        }
        while (i.hasNext()) {
            ac = (ACompoundInTheSpace)i.next();
            dist = this.distance(ac, fingerprintWeight);
            if (!(dist < min)) continue;
            c = ac;
            min = dist;
        }
        return c;
    }

    public ACompoundInTheSpace getCentroid(float fingerprintWeight) {
        if (this.centroid == null) {
            this.centroid = this.findCentroid(fingerprintWeight);
        }
        return this.centroid;
    }
}

