/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.BemisMurcko;
import chemaxon.clustering.backend.ClustorImpl;
import chemaxon.clustering.backend.DSSC;
import chemaxon.clustering.backend.KMeans;
import chemaxon.clustering.backend.LibraryMCS;
import chemaxon.clustering.backend.SphereExclusion;
import chemaxon.clustering.backend.oa.ChemFormatFactory;
import chemaxon.clustering.backend.oa.FormatFactory;
import chemaxon.clustering.backend.oa.IteratorWithException;
import chemaxon.clustering.backend.oa.OAException;
import chemaxon.clustering.backend.oa.OutputAction;
import chemaxon.clustering.boundary.CFPDFactory;
import chemaxon.clustering.boundary.ComparableDescriptor;
import chemaxon.clustering.boundary.ECFPDFactory;
import chemaxon.clustering.calculations.impl.MMDS;
import chemaxon.clustering.scaffolding.logging.SimpleVLog;
import chemaxon.clustering.scaffolding.logging.VLog;
import chemaxon.clustering.server.clustorServer.CS;
import chemaxon.clustering.util.TextUtil;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.sss.search.MCES;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BM
implements Licensable {
    Log log = LogFactory.getLog(BM.class);
    VLog vlog = null;
    ChemFormatFactory cff = null;
    private static String helpstr = "JKlustor - clustering command line frontend v0.07   (c) 1999-2012 ChemAxon Ltd.\n\nThis tool provides command line access to various clustering implementations.\n\nCommand line usage:\n  jklustor [options] inputs ...  or\n  jklustor.bat [options] inputs ... \n  Reads molecules from given inputs (files or URL) and group them by one of the\n  implemented clustering methods. The results are then exported to the standard\n  output or into files. Results can be presented by a lightweight HTTP server.\n\nOPTIONS\n\n-h          Print this help\n\n-v          Turn on verbose mode. Use -vv or -vvv to be more verbose.\n            Verbose messages will be forwarded to the logger at DEBUG level.\n\n-c <clus>   Specify clustering method to use\n Clustering methods:\n   bm         Use Bemis-Murcko framework based clustering\n   sphex[:<rsep>]\n              Use single level sphere exclusion clustering\n     <rsep>     Minimal separation between cluster centroids\n   kmeans[:<k>]\n              Use K-Means clustering\n     <k>        Targeted cluster count\n   libmcs[:<opts>]\n              Use LibraryMCS clustering\n     <opts>     LibMCS fine tune options, each separated with \";\" characters.\n       lookahead=<n>\n                  Set  lookahead   pair  count  parameter  of  the   clustering\n                  algorithm.\n       mcs=oldmcs Use  \"legacy\"  Maximum  Common  Substructure   identification\n                  already present in JChem prior to 5.4 release.\n       mincommonsize=<n>\n                  Set minimumCommonSize parameter of \"oldmcs\".\n       mcs=mces   Use new Maximum Common Edge Substructure identification.\n                                                                      (default)\n       mincomponentsize=<n>\n                  Set minComponentSize parameter of \"mces\"\n       keeplargestcomponent=[true|false]\n                  Set  keepLargestComponent  parameter  of \"mces\".  Use \"false\"\n                  to create disconnected (multifragment) cluster representants.\n                  Default is \"true\"\n       searchmode=[FAST|STANDARD|EXHAUSTIVE]\n                  Set searchMode parameter of \"mces\". Default is \"FAST\".\n       EXAMPLES:\n         jklustor ... -c libmcs ....\n           Default Library MCS clustering\n         jklustor ... -c libmcs:mcs=oldmcs;mincommonsize=4 ...\n           Use currently default \"legacy\" MCS identification allowing MCS sizes\n           at least 4 atoms\n         jklustor ... -c libmcs:mcs=mces;keeplargestcomponent=false ...\n           Use Library MCS clustering with disconnected cluster representants.\n   mmds[:<k>] Use Maximal-Minimal Dissimilarity Selection based clustering.\n     <k>        Targeted cluster count\n\n-d <desc>[:<metrics>]\n            Specify molecular descriptor and optionally the metric to use.\n            Please note that certain clustering  algorithms can be incompatible\n            with  certain descriptors or  metrics. It is always  safe to not to\n            specify descriptors or metrics.\n Descriptors:\n   cfp        ChemAxon's chemical fingerprint (default)\n              Supported dissimilarity metrics:\n              tanimoto, manhattan, euclid, euclidsqr, commonbits\n   ecfp       ChemAxon's ECFP fingerprint implementation\n              tanimoto, manhattan, euclid, euclidsqr, commonbits\n\n-s <port>   After  performing all  output actions  launch  listening  server on\n            given port.\n            Note  that option -l (store  individual  inputs) might  be required\n            since using server mode does not necessarily store inputs.\n\n-l          Store individual input structures regardless of output actions.\n            This  option  possibly  needed  when using server  mode. Note t hat\n            certain  clustering a lgorithms  and  output  actions  requres  the\n            storage  of  the  individual  input  structures.  In this  case the\n            storage is automatic, passing option -l is not needed.\n\n-sd         Store descriptor objects for inidividual structures\n            In cases when  descriptor  storage is not required by a  clustering\n            algorithm then  descriptors for inputs are not  calculated. However\n            a user  might  want to cache them for example  speed up HTTP server\n            operation. (If descriptors  are not stored then they are calculated\n            on the fly.)\n\n-lfin       Keep  only the largest  framgments of input structures. If set then\n            smaller  fragments of inputs ill be  discarded during  import. Only\n            the   largest  fragment   will   be   considered  when  calculating\n            descriptors or storing structures\n\n-o <action> Specifies a desired output action. If no -o or -s argument given\n            then one default output action will be executed. If multiple output\n            actions specified then all will be executed in the given order.\n            The default action is equivalent with \"-o wrclus:smi:-:all\"\n\n Output actions:\n\n   wrclus[:<format>[:<location>[:<opts>]]]\n              Write found clusters\n     <format>   Output format to use (defalt: \"smiles\")\n       smiles     Output cluster  representants to smiles, set molecule name to\n                  a string representing the cluster ID and cluster size.\n       sdf        Output cluster representants in sdf format. Set molecule name\n                  to  cluster  ID  and set the following SDF  properties (using\n                  clustering method sort name as <CM>):\n                    \"CHEMAXON.<CM>.CLUSTERID\"     cluster ID\n                    \"CHEMAXON.<CM>.CLUSTERSIZE\"   cluster size\n                    \"CHEMAXON.<CM>.CLUSTERSMILES\" cluster representant\n                                                  structure stored in SMILES\n                                                  format\n     <location> Output location (default: \"-\")\n       -          Write to the standard output\n       <fname>    Write to file \"<fname>\"\n     <opts>     Cluster export options, separated by \";\" characters\n       <level>    Clustering level to use\n                  To select  lowest level (the one just above the leaves) use\n                  one of \"f\" \"fine\" \"finest\" \"l\" \"lower\" \"lowest\".\n                  To select highest level then use one of\n                  \"r\" \"rough\" \"roughest\" \"u\" \"upper\".\n                  Append +N or -N to move selected level N step(s)\n       ascs       Write clusters in ascending order by size\n       descs      Write clusters in descending order by size\n       s<expr>    Select cluster sizes to export (does not affect ordering)\n       id<expr>   Select cluster ids to export (default: \"all\")\n\n   wrmols[:<format>[:<location>[:<opts>]]]\n              Write clustered molecules\n     <format>   Output format to use (default: \"smiles\")\n       smiles     Output cluster  members to smiles, set molecule molecule name\n                  to the associated parent cluster ID\n       sdf        Output  cluster  members  to sdf, set  molecule  name to  the\n                  associated  parent  cluster  ID  and  set  the  following SDF\n                  properties (using clustering method sort name as <CM>):\n                    \"CHEMAXON.<CM>.CLUSTERID\"     associated cluster ID\n                    \"CHEMAXON.<CM>.CLUSTERSMILES\" associated cluster\n                                                  representant structure stored\n                                                  in SMILES format\n     <location> Output location (default: \"-\")\n       -          Write to the standatd output\n       <fname>    Write to one or  more file. If \"<fname>\"  contains  character\n                  \"*\" then one file  per  writen  cluster will  be  created  by\n                  substituting the associated cluster ID. In this case \"?\" will\n                  be substituted to  cluster size. Using 0<d> characters before\n                  \"*\" and \"?\" will result in left \"0\" padding\n                  Example: ... -o \"wrmols:sdf:cluster_*.sdf\" ...\n       <opts>   Export options, separated by \";\" characters\n         <level>  Clustering level to use\n                  To select lowest level (the one just above the leaves) use\n                  \"f\" \"fine\" \"finest\" \"l\" \"lower\" \"lowest\".\n                  To select highest level then use\n                  \"r\" \"rough\" \"roughest\" \"u\" \"upper\".\n                  Append +N or -N to move selected level N step(s)\n         s<expr>  Select cluster sizes to export\n         id<expr> Select cluster IDs to export. (default: \"all\")\n                  Use  \"all\"  to select  all clusters  or use  a \",\"  separated\n                  cluster ID/open or closed ID interval list.\n                  Example: ... -o \"wrmols:sdf:out.sdf:id-4,6,8-10,12-\" ...\n\n   wrstat[:<format>[:<location>]]\n              Write cluster size statistics\n     <format>   statistics detail level\n       brief      write brief summary (cluster counts, covarage)\n       normal     write normal  summary  (default) (same  as brief plus cluster\n                  size vs frequency table)\n       full       write full details (same as normal and more detailed coverage\n                  statistics written)\n       xml        write XML formatted statistics\n     <location> Output location (default: \"-\")\n       -          Use standard output (default)\n       <fname>    Write to text file\n\n  none        Do  nothing.  Can be useful for  test/debug  purposes. Specifying\n              this output action alone will prevent the execution of default\n              output action.\n\nOptions for fine tuning:\n\n-bs <count> Set batch size. The given  structure count  will read at a time and\n            processed  consecutively. Note  that  certain clustering algorithms\n            need to read all structures before starting processing. These cases\n            are  also  affected by batch size: some preprocessing  (calculating\n            descriptors) might be executed.\n\nINPUTS\n\n  The command line arguments which were  not parsed as options specifies inputs\n  to read and process.  One can use file names, URL-s or \"-\" to read from the\n  standard input. Structure also can be specified inline assert SMILES sources\n  or chemical names.\n\nEXAMPLES\n\n  jklustor -v http://www.chemaxon.com/shared/libMCS/default.sdf\n           Enumerate frameworks in SMILES format on the standard output\n\n  jklustor -v -l -s 81 -clus sphex:0.4 http://www.chemaxon.com/shared/libMCS/default.sdf\n           Invoke sphere exclusion clustering (using dissmilaity radius 0.4)\n           on the given data set; store input structures and present results\n           with builtin lightweight HTTP server.\n           When clustering process finished connect browser to http://localhost:84\n\n  jklustor C CC CCC C1CC1 C1CCC1 -o none -v\n           Read inline structures and do nothing with them\n\n  jklustor C CC CCC C1CC1 C1CCC1 -o wrclus:sdf:fw.sdf\n           Read inline structures and write frameworks to fw.sdf\n\n  cat SC100.sdf | jklustor - -o wrclus:smiles:- -o wrclus:sdf:frameworks.sdf -o \"wrmols:sdf:cluster_*.sdf\"\n           Read structures from standard input, write frameworks to\n           the output in smiles and to file frameworks.sdf in sdf\n           format; write input structures grouped by framework\n           to files cluster_0.sdf, cluster_1.sdf ...\n\n  cat SC100.sdf | jklustor - -o \"wrmols:sdf:cluster_*.sdf:id-5,15,20-25,40-\"\n           write only specified clusters to files";
    private String licenseEnvironment = "";

    private void setVerboseLevel(int l) {
        this.vlog = l < 1 ? null : new SimpleVLog(this.log, System.err, l);
    }

    public static void main(String[] args) throws IOException {
        BM bm = new BM();
        bm.checkLicense();
        try {
            bm.run(args);
        }
        catch (CommandLineConfigurationException ex) {
            bm.log.fatal((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void processVerboseSettings(TextUtil.ProcessArguments arg) {
        if (arg.fetchSingleArgument("-v")) {
            this.setVerboseLevel(1);
        }
        if (arg.fetchSingleArgument("-vv")) {
            this.setVerboseLevel(2);
        }
        if (arg.fetchSingleArgument("-vvv")) {
            this.setVerboseLevel(3);
        }
    }

    private boolean processHelp(TextUtil.ProcessArguments arg) {
        if (arg.fetchSingleArgument("-h")) {
            System.err.println(BM.getHelpString());
            return true;
        }
        return false;
    }

    private OutputAction processOA(String s, FormatFactory ff) throws OAException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Processing output action " + s));
        }
        String name = s;
        String param = "";
        if (s.indexOf(58) >= 0) {
            name = s.substring(0, s.indexOf(58));
            param = s.substring(s.indexOf(58) + 1);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Action name: " + name + " param: " + param));
        }
        Class c = ff.getAction(name);
        OutputAction oa = ff.createOutputAction(c, param);
        oa.setupFF(ff);
        return oa;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void run(String[] args) throws CommandLineConfigurationException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"BM started");
        }
        this.cff = new ChemFormatFactory();
        boolean launchServer = false;
        int serverPort = -1;
        TextUtil.ProcessArguments arg = new TextUtil.ProcessArguments(args);
        if (this.processHelp(arg)) {
            if (!this.log.isTraceEnabled()) return;
            this.log.trace((Object)"Help printed, returning.");
            return;
        }
        this.processVerboseSettings(arg);
        if (arg.fetchSingleArgument("-l")) {
            this.cff.setLeavesRequired();
            this.cff.setStoreIntermediate();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Store leaves set.");
            }
        }
        String s = null;
        s = arg.fetchSingleArgumentWithParam("-s");
        if (s != null) {
            if (s.length() == 0) {
                throw new CommandLineConfigurationException("No server listening port given");
            }
            try {
                serverPort = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new CommandLineConfigurationException("Invalid server listening port: " + s, e);
            }
            launchServer = true;
        }
        Vector<OutputAction> oas = new Vector<OutputAction>();
        while ((s = arg.fetchSingleArgumentWithParam("-o")) != null) {
            if (s.length() == 0) {
                throw new CommandLineConfigurationException("No output action given.");
            }
            try {
                OutputAction oa = this.processOA(s, this.cff);
                oas.add(oa);
            }
            catch (OAException e) {
                throw new CommandLineConfigurationException("Error creating output action " + s, e);
            }
        }
        if (oas.isEmpty() && !launchServer) {
            try {
                OutputAction a = this.processOA("wrclus", this.cff);
                oas.add(a);
                if (this.vlog != null) {
                    this.vlog.verbose("No output action(s) or server launch specified. Use default output action: " + a.toString());
                }
            }
            catch (OAException e) {
                throw new CommandLineConfigurationException("Error creating output action " + s, e);
            }
        }
        if ((s = arg.fetchSingleArgumentWithParam("-bs")) != null) {
            if (s.length() == 0) {
                throw new CommandLineConfigurationException("No batch size parameter given.");
            }
            int batchSize = 0;
            try {
                batchSize = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new CommandLineConfigurationException("Invalid batch size parameter " + s, e);
            }
            if (batchSize < 1) {
                throw new CommandLineConfigurationException("Invalid batch size parameter " + batchSize);
            }
            this.cff.setBatchSize(batchSize);
        }
        if (arg.fetchSingleArgument("-l")) {
            this.cff.setLeavesRequired();
            this.cff.setStoreIntermediate();
        }
        if (arg.fetchSingleArgument("-sd")) {
            this.cff.setLeavesRequired();
            this.cff.setStoreDescriptors();
        }
        if (arg.fetchSingleArgument("-lfin")) {
            this.cff.addRawDecorator(new ChemFormatFactory.LFin());
        }
        String d = null;
        d = arg.fetchSingleArgumentWithParam("-d");
        if (d != null) {
            if (d.length() == 0) {
                throw new CommandLineConfigurationException("No descriptor specified");
            }
            ComparableDescriptor desc = null;
            if (d.startsWith("cfp")) {
                if (d.length() > 3) {
                    desc = new CFPDFactory().getDescriptor("<metric>" + d.substring(4) + "</metric>");
                    if (desc == null) {
                        throw new CommandLineConfigurationException("Unknown metric: " + d.substring(4));
                    }
                } else {
                    desc = new CFPDFactory().getDescriptor(null);
                }
            } else {
                if (!d.startsWith("ecfp")) throw new CommandLineConfigurationException("Unknow descriptor specification: " + d);
                if (d.length() > 4) {
                    desc = new ECFPDFactory().getDescriptor("<metric>" + d.substring(5) + "</metric>");
                    if (desc == null) {
                        throw new CommandLineConfigurationException("Unknown metric: " + d.substring(5));
                    }
                } else {
                    desc = new ECFPDFactory().getDescriptor(null);
                }
            }
            this.cff.setDescriptor(desc);
        }
        ClustorImpl clust = null;
        String clusts = arg.fetchSingleArgumentWithParam("-c");
        if (clusts != null && clusts.length() == 0) {
            throw new CommandLineConfigurationException("No clustering method specified.");
        }
        if (clusts != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Process clustering method: " + clusts));
            }
            if (clusts.equals("bm")) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Constructing bm clustering");
                }
                clust = new BemisMurcko(this.cff);
            } else if (clusts.startsWith("sphex")) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Constructing sphere exclusion clustering");
                }
                double dist = 1.0;
                if (!clusts.equals("sphex")) {
                    dist = Double.parseDouble(clusts.substring(6));
                }
                clust = new SphereExclusion(this.cff, 2, dist);
            } else if (clusts.startsWith("kmeans")) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Construct kmeans clustering");
                }
                int k = 20;
                if (!clusts.equals("kmeans")) {
                    k = Integer.parseInt(clusts.substring(7));
                }
                clust = new KMeans(this.cff, k);
            } else if (clusts.startsWith("libmcs")) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Construct libmcs clustering");
                }
                LibraryMCS libmcs = new LibraryMCS(this.cff);
                clust = libmcs;
                TextUtil.ProcessArguments pa0 = new TextUtil.ProcessArguments(clusts, "libmcs", ':');
                if (!pa0.isEmpty()) {
                    String mcs;
                    TextUtil.ProcessArguments pa = new TextUtil.ProcessArguments(pa0.fetchFirst(), ';');
                    Integer la = pa.fetchIntegerValue("lookahead");
                    if (la != null) {
                        if (la < 1) {
                            throw new CommandLineConfigurationException("Invalid lookahead size: " + la);
                        }
                        libmcs.setLookahead(la);
                    }
                    if ((mcs = pa.fetchValue("mcs")) != null) {
                        Integer cs;
                        if (mcs.equals("oldmcs")) {
                            LibraryMCS.OldMCS oldmcs = new LibraryMCS.OldMCS();
                            cs = pa.fetchIntegerValue("mincommonsize");
                            if (cs != null) {
                                oldmcs.setMinimumCommonSize(cs);
                            }
                            libmcs.setMCS(oldmcs);
                        } else {
                            Boolean kl;
                            MCES.SearchMode sm;
                            if (!mcs.equals("mces")) throw new CommandLineConfigurationException("Unknown mcs parameter " + mcs);
                            LibraryMCS.NewMCES mces = new LibraryMCS.NewMCES();
                            cs = pa.fetchIntegerValue("mincomponentsize");
                            if (cs != null) {
                                mces.setMinComponentSize(cs);
                            }
                            if ((sm = pa.fetchEnumValue("searchmode", MCES.SearchMode.class)) != null) {
                                mces.setSearchMode(sm);
                            }
                            if ((kl = pa.fetchBooleanValue("keeplargestcomponent")) != null) {
                                mces.setKeepLargestComponent(kl);
                            }
                            libmcs.setMCS(mces);
                        }
                    }
                    if (!pa.isEmpty()) {
                        throw new CommandLineConfigurationException("Unknown or invalid libmcs clustering option " + pa.fetchFirst());
                    }
                }
                if (!pa0.isEmpty()) {
                    throw new CommandLineConfigurationException("Unknown or invalid libmcs clustering parameter " + pa0.fetchFirst());
                }
            } else {
                if (!clusts.startsWith("mmds")) throw new CommandLineConfigurationException("Unknown clustering method " + clusts);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Construct mmdf clustering");
                }
                int k = 20;
                if (!clusts.equals("mmds")) {
                    k = Integer.parseInt(clusts.substring(5));
                }
                clust = new DSSC(this.cff, k, new MMDS());
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No clustering method specified, yse default clustering method");
            }
            clust = new BemisMurcko(this.cff);
        }
        for (OutputAction oa : oas) {
            oa.setupClustor(clust);
        }
        while (!arg.isEmpty()) {
            this.cff.addInputLocation(arg.fetchFirst());
        }
        if (this.cff.getInputCount() == 0) {
            throw new CommandLineConfigurationException("No input specified. Use -h for help.");
        }
        int tic = 0;
        try {
            IteratorWithException<IteratorWithException<Molecule, IOException>, IOException> ii = this.cff.iterateMultipleInputs();
            while (ii.hasNext()) {
                IteratorWithException<Molecule, IOException> i = ii.next();
                if (this.vlog != null) {
                    this.vlog.verbose("Import structures from " + i);
                }
                int ic = clust.getHC().importMolecules(i, this.vlog);
                tic += ic;
                if (this.vlog == null) continue;
                this.vlog.verbose("Imported " + ic + " structures from the input. (Total " + tic + " structures; " + clust.getHC().getLevelGroup(1).size() + " in tree)");
            }
        }
        catch (IOException e) {
            throw new CommandLineConfigurationException("Error importing: " + e.getMessage(), e);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Notify allImportFinished");
        }
        if (this.vlog != null) {
            this.vlog.verbose("All import finished.");
        }
        clust.getHC().notifyAllImportFinished();
        if (this.vlog != null && this.vlog.isVVVerboseEnabled()) {
            this.vlog.vvverbose("Descriptor: " + this.cff.getDescriptor().getFactory().getSummaryString());
            StringBuffer sb = new StringBuffer();
            clust.getHC().getTree().toString(sb, 2, 2);
            this.vlog.vvverbose("Tree:");
            this.vlog.vvverbose(sb.toString());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Import finished, do export");
        }
        if (this.vlog != null && this.vlog.isVVerboseEnabled()) {
            this.vlog.vverbose("Process output actions:");
            for (OutputAction a : oas) {
                this.vlog.vverbose(a.toString());
            }
        }
        for (OutputAction a : oas) {
            try {
                a.perform(clust, this.vlog);
            }
            catch (IOException e) {
                throw new CommandLineConfigurationException("Error executing " + a.getShortName(), e);
            }
        }
        if (!launchServer) return;
        if (this.vlog != null && this.vlog.isVerboseEnabled()) {
            this.vlog.verbose("Launch listening server on port " + serverPort);
        } else {
            System.err.println("Launch listening server on port " + serverPort);
        }
        try {
            CS cs = new CS(this.cff, clust);
            cs.getServer().runListeningLoop(serverPort);
            if (this.vlog != null && this.vlog.isVerboseEnabled()) {
                this.vlog.verbose("Server returned.");
                return;
            } else {
                System.err.println("Server returned.");
            }
            return;
        }
        catch (IOException ex) {
            throw new CommandLineConfigurationException("Exception running server", ex);
        }
    }

    private static String getHelpString() {
        return helpstr;
    }

    @Override
    public final boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("JKlustor", this.licenseEnvironment);
    }

    @Override
    public final void setLicenseEnvironment(String string) {
        this.licenseEnvironment = string;
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("JKlustor", this.licenseEnvironment);
    }

    public static class CommandLineConfigurationException
    extends Exception {
        public CommandLineConfigurationException(String message) {
            super(message);
        }

        public CommandLineConfigurationException() {
        }

        public CommandLineConfigurationException(Throwable cause) {
            super(cause);
        }

        public CommandLineConfigurationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

