/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.Clustor;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.EntityProperties;
import chemaxon.clustering.backend.HC;
import chemaxon.clustering.backend.PropertyTypes;
import chemaxon.clustering.backend.oa.FormatFactory;
import chemaxon.clustering.backend.oa.OALevelSelect;
import chemaxon.clustering.boundary.CDescriptor;
import chemaxon.clustering.boundary.ComparableDescriptor;
import chemaxon.clustering.boundary.LDescriptor;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ClustorImpl
implements Clustor<Molecule, String> {
    Log blog = LogFactory.getLog(Clustor.class);
    boolean f = false;
    FormatFactory<Molecule, String> ff;
    private HC hc = null;
    private int levels;
    HC.Decorator crSmiles = null;
    HC.RetrievePropertyString crSmilesR = null;
    HC.RetrievePropertyObject<String> crIntermediateR = null;
    HC.Decorator firstParent = null;
    HC.Decorator<?, Molecule> crMolecule = null;
    HC.RetrievePropertyObject<Molecule> crMoleculeR = null;
    HC.Decorator<?, CDescriptor> crDesc = null;
    HC.RetrieveDescriptor crDescR = null;
    HC.Decorator<?, LDescriptor> cmDesc = null;
    HC.RetrievePropertyObject<LDescriptor> cmDescR = null;
    HC.RetrievePropertyInt firstLeaveParentID = null;
    int[] flp = null;

    public ClustorImpl(FormatFactory<Molecule, String> ff, int levels2) {
        if (this.blog.isDebugEnabled()) {
            this.blog.debug((Object)("Constructed. FormatFactory: " + ff + " levels: " + levels2));
        }
        this.ff = ff;
        this.levels = levels2;
    }

    EntityGroup addGroup(int level, String name, Molecule gRM, String gRS, CDescriptor gRD, LDescriptor gMD) {
        if (!this.f) {
            this.f = true;
        }
        EntityGroup g = this.getHC().addGroup(level, name);
        this.updateRepresentant(g, gRM, gRS, gRD, gMD);
        return g;
    }

    void updateRepresentant(EntityGroup g, Molecule gRM, String gRS, CDescriptor gRD, LDescriptor gMD) {
        if (!this.f) {
            this.f = true;
        }
        if (this.crMolecule != null) {
            this.crMolecule.setPropertyObject(g.properties(), gRM);
            if (gRM == null && this.blog.isWarnEnabled()) {
                this.blog.warn((Object)"null cluster representant molecule given");
            }
        }
        if (this.crSmiles != null) {
            this.crSmiles.setPropertyString(g.properties(), gRS);
            if (gRS == null && this.blog.isWarnEnabled()) {
                this.blog.warn((Object)"null cluster representant SMILES given");
            }
        }
        if (this.crDesc != null) {
            this.crDesc.setPropertyObject(g.properties(), gRD);
            if (gRD == null && this.blog.isWarnEnabled()) {
                this.blog.warn((Object)"null cluster representant descriptor given");
            }
        }
        if (this.cmDesc != null) {
            this.cmDesc.setPropertyObject(g.properties(), gMD);
            if (gRD == null && this.blog.isWarnEnabled()) {
                this.blog.warn((Object)"null cluster mean descriptor given");
            }
        }
    }

    @Override
    public final HC getHC() {
        if (this.hc == null) {
            this.hc = this.ff.constructHC(this.levels);
        }
        return this.hc;
    }

    @Override
    public ComparableDescriptor getDesc() {
        return this.ff.getDescriptor();
    }

    public HC.RetrievePropertyString getClusterRepresentantSmi() {
        if (!this.f) {
            this.f = true;
        }
        if (this.crSmilesR == null) {
            if (this.crSmiles != null) {
                this.crSmilesR = this.crSmiles;
            } else if (this.crMolecule != null) {
                this.crSmilesR = new HC.RetrievePropertyString(){

                    @Override
                    public String getPropertyString(Entity node) {
                        return ClustorImpl.this.crMolecule.getPropertyObject(node).toFormat("SMILES");
                    }

                    @Override
                    public String getPropertyString(EntityProperties node) {
                        return ClustorImpl.this.crMolecule.getPropertyObject(node).toFormat("SMILES");
                    }
                };
            } else {
                throw new UnsupportedOperationException("");
            }
        }
        return this.crSmilesR;
    }

    @Override
    public HC.RetrievePropertyObject<String> getClusterRepresentantIntermediate() {
        if (this.crIntermediateR == null) {
            final HC.RetrievePropertyString rs = this.getClusterRepresentantSmi();
            this.crIntermediateR = new HC.RetrievePropertyObject<String>(){

                @Override
                public String getPropertyObject(Entity node) {
                    return rs.getPropertyString(node);
                }

                @Override
                public String getPropertyObject(EntityProperties node) {
                    return rs.getPropertyString(node);
                }
            };
        }
        return this.crIntermediateR;
    }

    @Override
    public void setStoreClusterRepresentantIntermediate() {
        this.crSmiles = new HC.Decorator("clusterRepresentantSmiles", PropertyTypes.STRINGPROP, 1){};
        this.getHC().addDecorator(this.crSmiles);
    }

    @Override
    public boolean isClusterRepresentantIntermediateStored() {
        return this.crSmiles != null;
    }

    public void setStoreFirstParentID() {
        this.firstParent = new HC.Decorator("firstparent", PropertyTypes.INTPROP, 1){};
        this.getHC().addDecorator(this.firstParent);
    }

    public HC.Decorator getFirstParent() {
        return this.firstParent;
    }

    @Override
    public HC.RetrievePropertyInt getFirstParentID() {
        return this.firstParent;
    }

    @Override
    public boolean isFirstParentIDStored() {
        return this.firstParent != null;
    }

    @Override
    public HC.RetrievePropertyObject<Molecule> getClusterRepresentantRaw() {
        if (!this.f) {
            this.f = true;
        }
        if (this.crMoleculeR == null) {
            if (this.crMolecule != null) {
                this.crMoleculeR = this.crMolecule;
            } else if (this.crSmiles != null) {
                this.crMoleculeR = new HC.RetrievePropertyObject<Molecule>(){

                    @Override
                    public Molecule getPropertyObject(Entity node) {
                        try {
                            String smi = ClustorImpl.this.crSmiles.getPropertyString(node);
                            if (smi.length() == 0) {
                                return new Molecule();
                            }
                            return MolImporter.importMol(smi);
                        }
                        catch (MolFormatException ex) {
                            return null;
                        }
                    }

                    @Override
                    public Molecule getPropertyObject(EntityProperties node) {
                        try {
                            String smi = ClustorImpl.this.crSmiles.getPropertyString(node);
                            if (smi.length() == 0) {
                                return new Molecule();
                            }
                            return MolImporter.importMol(smi);
                        }
                        catch (MolFormatException ex) {
                            return null;
                        }
                    }
                };
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return this.crMoleculeR;
    }

    @Override
    public void setStoreClusterRepresentantRaw() {
        this.crMolecule = new HC.Decorator<Object, Molecule>("clusterRepresentantMolecule", PropertyTypes.OBJECTPROP, 1){};
        this.getHC().addDecorator(this.crMolecule);
    }

    @Override
    public boolean isClusterRepresentantRawStored() {
        return this.crMolecule != null;
    }

    @Override
    public HC.RetrieveDescriptor getClusterRepresentantDescriptor() {
        if (!this.f) {
            this.f = true;
        }
        if (this.crDescR == null) {
            if (this.crDesc != null) {
                this.crDescR = new HC.RetrieveDescriptor(){

                    @Override
                    public CDescriptor getDescriptor(Entity node) {
                        return ClustorImpl.this.crDesc.getPropertyObject(node);
                    }

                    @Override
                    public CDescriptor getDescriptor(EntityProperties node) {
                        return ClustorImpl.this.crDesc.getPropertyObject(node);
                    }

                    @Override
                    public CDescriptor getPropertyObject(Entity node) {
                        return ClustorImpl.this.crDesc.getPropertyObject(node);
                    }

                    @Override
                    public CDescriptor getPropertyObject(EntityProperties node) {
                        return ClustorImpl.this.crDesc.getPropertyObject(node);
                    }
                };
            } else {
                final HC.RetrievePropertyObject<Molecule> crm = this.getClusterRepresentantRaw();
                final ComparableDescriptor cd = this.getDesc();
                this.crDescR = new HC.RetrieveDescriptor(){

                    @Override
                    public CDescriptor getDescriptor(Entity node) {
                        return this.getPropertyObject(node);
                    }

                    @Override
                    public CDescriptor getDescriptor(EntityProperties node) {
                        return this.getPropertyObject(node);
                    }

                    @Override
                    public CDescriptor getPropertyObject(Entity node) {
                        return cd.constructDescriptor((Molecule)crm.getPropertyObject(node));
                    }

                    @Override
                    public CDescriptor getPropertyObject(EntityProperties node) {
                        return cd.constructDescriptor((Molecule)crm.getPropertyObject(node));
                    }
                };
            }
        }
        return this.crDescR;
    }

    @Override
    public void setStoreClusterRepresentantDescriptor() {
        this.crDesc = new HC.Decorator<Object, CDescriptor>("clusterRepresentantDescriptor", PropertyTypes.OBJECTPROP, 1){};
        this.getHC().addDecorator(this.crDesc);
    }

    @Override
    public boolean isClusterRepresentantDescriptorStored() {
        return this.crDesc != null;
    }

    @Override
    public HC.RetrievePropertyObject<LDescriptor> getClusterMeanDescriptor() {
        if (!this.f) {
            this.f = true;
        }
        if (this.cmDescR == null && this.cmDesc != null) {
            this.cmDescR = this.cmDesc;
        }
        return this.cmDescR;
    }

    @Override
    public void setStoreClusterMeanDescriptor() {
        if (this.isClusterMeanDescriptorStored()) {
            return;
        }
        this.cmDesc = new HC.Decorator<Object, LDescriptor>("clusterMeanDescriptor", PropertyTypes.OBJECTPROP, 1){};
        this.getHC().addDecorator(this.cmDesc);
    }

    @Override
    public boolean isClusterMeanDescriptorStored() {
        return this.cmDesc != null;
    }

    @Override
    public OALevelSelect getPreferredLevel() {
        return OALevelSelect.LOWEST;
    }

    @Override
    public void setStoreLeavesFirstParentID() {
        this.firstLeaveParentID = new HC.RetrievePropertyInt(){

            @Override
            public int getPropertyInt(Entity node) {
                int i = node.getIndex();
                if (ClustorImpl.this.flp == null || ClustorImpl.this.flp.length <= i) {
                    return 0;
                }
                return ClustorImpl.this.flp[i];
            }

            @Override
            public int getPropertyInt(EntityProperties node) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        this.getHC().addDecorator(new HC.Callback(0){

            @Override
            public void allImportFinished(boolean cleanupRequired) {
                super.allImportFinished(cleanupRequired);
                if (ClustorImpl.this.isLeavesFirstParentIDStored()) {
                    ClustorImpl.this.hintMaxLeaveIndex(this.hc.getLevelCount());
                }
            }
        });
    }

    @Override
    public HC.RetrievePropertyInt getLeavesFirstParentID() {
        return this.firstLeaveParentID;
    }

    void hintMaxLeaveIndex(int li) {
        if (this.flp == null) {
            this.flp = new int[li + 1];
        }
        if (this.flp.length <= li) {
            int nl = Math.max(li + 1 + 1000, (int)((double)li * 1.3));
            int[] newFlp = new int[nl];
            System.arraycopy(this.flp, 0, newFlp, 0, this.flp.length);
            this.flp = newFlp;
        }
    }

    @Override
    public void setFirstParentAssociation(Entity leave, EntityGroup firstParent) {
        if (this.firstLeaveParentID == null) {
            throw new IllegalStateException();
        }
        int li = leave.getIndex();
        int gi = firstParent.getIndex();
        this.hintMaxLeaveIndex(li);
        this.flp[li] = gi;
    }

    @Override
    public boolean isLeavesFirstParentIDStored() {
        return this.firstLeaveParentID != null;
    }
}

