/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.ClustorImpl;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.HC;
import chemaxon.clustering.backend.SphereExclusion;
import chemaxon.clustering.backend.oa.ChemFormatFactory;
import chemaxon.clustering.boundary.CDescriptor;
import chemaxon.clustering.calculations.SimpleDiverseSubsetSelection;
import chemaxon.marvin.modelling.util.U;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DSSC
extends ClustorImpl {
    Log log = LogFactory.getLog(DSSC.class);
    SimpleDiverseSubsetSelection dss;
    int k;

    public DSSC(final ChemFormatFactory ff, final int k, final SimpleDiverseSubsetSelection dss) {
        super(ff, 2);
        this.k = k;
        this.dss = dss;
        ff.setStoreDescriptors();
        ff.setLeavesRequired();
        ff.setStoreIntermediate();
        this.setStoreLeavesFirstParentID();
        this.setStoreClusterRepresentantDescriptor();
        this.setStoreClusterRepresentantIntermediate();
        this.setStoreFirstParentID();
        HC.Callback clusteringCB = new HC.Callback(0){

            @Override
            public void allImportFinished(boolean cleanupRequired) {
                super.allImportFinished(cleanupRequired);
                if (DSSC.this.log.isDebugEnabled()) {
                    DSSC.this.log.debug((Object)"Start DSSC clustering");
                }
                if (cleanupRequired) {
                    if (DSSC.this.log.isErrorEnabled()) {
                        DSSC.this.log.error((Object)"Unexpected recall of clustering process");
                    }
                    throw new UnsupportedOperationException();
                }
                dss.setAlternativeDataSource(ff.getDescriptor(), null, ff.getLeaveDescriptors());
                if (DSSC.this.log.isTraceEnabled()) {
                    DSSC.this.log.trace((Object)"Get diverse subset");
                }
                int[] centrums = dss.getDiverseSubsetIndices(k);
                if (DSSC.this.log.isTraceEnabled()) {
                    DSSC.this.log.trace((Object)("Diverse subset ids: " + U.sel(centrums)));
                }
                for (int i = 0; i < centrums.length; ++i) {
                    Entity ei = DSSC.this.getHC().getTree().getLeaf(centrums[i]);
                    CDescriptor desci = ff.getRetrieveLeaveDescriptor().getDescriptor(ei);
                    String smii = ff.getRetrieveLeaveIntermediate().getPropertyObject(ei);
                    EntityGroup newGroup = DSSC.this.addGroup(1, "DSGROUP", null, smii, desci, null);
                    newGroup.add(ei);
                    if (!DSSC.this.isLeavesFirstParentIDStored()) continue;
                    DSSC.this.setFirstParentAssociation(ei, newGroup);
                }
                SphereExclusion.reassignLeaves(DSSC.this.log, DSSC.this, ff);
            }
        };
        this.getHC().addDecorator(clusteringCB);
    }

    @Override
    public String getShortName() {
        return "DSSC:" + this.dss.getShortName();
    }

    @Override
    public String getLongName() {
        return "Diverse Subset Selection Clustering over " + this.dss.getName();
    }

    @Override
    public String getClusteringSummary() {
        return "Diverse Subset (of size " + this.k + ") Selection Clustering based on " + this.dss.getName();
    }
}

