/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.EntityStore;
import chemaxon.clustering.backend.PropertyTypes;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;

public class Events {

    public static class DefaultStoreEventHandler
    implements StoreEventHandler,
    EntityAddedListener,
    PropertyAddedListener,
    PropertyChangedListener,
    EntityRelocationListener,
    ChangeCountListener {
        private EntityStore s;
        Set<EntityAddedListener> ea;
        Set<PropertyAddedListener> pa;
        Set<PropertyChangedListener> pc;
        Set<EntityRelocationListener> er;
        Set<ChangeCountListener> cc;

        public DefaultStoreEventHandler(EntityStore s) {
            this.s = s;
            this.ea = null;
            this.pa = null;
            this.pc = null;
            this.er = null;
            this.cc = null;
        }

        public void releaseHandler() {
            this.s = null;
        }

        @Override
        public void addEntityAddedListener(EntityAddedListener l) {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.ea == null) {
                this.ea = new HashSet<EntityAddedListener>();
            }
            this.ea.add(l);
        }

        @Override
        public void addPropertyAddedListener(PropertyAddedListener l) {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.pa == null) {
                this.pa = new HashSet<PropertyAddedListener>();
            }
            this.pa.add(l);
        }

        @Override
        public void addPropertyChangedListener(PropertyChangedListener l) {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.pc == null) {
                this.pc = new HashSet<PropertyChangedListener>();
            }
            this.pc.add(l);
        }

        @Override
        public void addChangeCountListener(ChangeCountListener l) {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.cc == null) {
                this.cc = new HashSet<ChangeCountListener>();
            }
            this.cc.add(l);
        }

        @Override
        public boolean removeEntityAddedListener(EntityAddedListener l) {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.ea != null) {
                return this.ea.remove(l);
            }
            return false;
        }

        @Override
        public boolean removePropertyAddedListener(PropertyAddedListener l) {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.pa != null) {
                return this.pa.remove(l);
            }
            return false;
        }

        @Override
        public boolean removePropertyChangedListener(PropertyChangedListener l) {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.pc != null) {
                return this.pc.remove(l);
            }
            return false;
        }

        @Override
        public void addEntityRelocationListener(EntityRelocationListener l) {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.er == null) {
                this.er = new HashSet<EntityRelocationListener>();
            }
            this.er.add(l);
        }

        @Override
        public boolean removeEntityRelocationListener(EntityRelocationListener l) {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.er != null) {
                return this.er.remove(l);
            }
            return false;
        }

        @Override
        public boolean removeChangeCountListener(ChangeCountListener l) {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.cc != null) {
                return this.cc.remove(l);
            }
            return false;
        }

        @Override
        public void removeAllListeners() {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            this.ea.clear();
            this.pa.clear();
            this.pc.clear();
            this.cc.clear();
            this.er.clear();
        }

        @Override
        public void entityAdded(EntityStore s, int eid) {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.ea != null && this.ea.size() > 0) {
                for (EntityAddedListener l : this.ea) {
                    l.entityAdded(s, eid);
                }
            }
        }

        @Override
        public void propertyAdded(EntityStore e, PropertyTypes type, int pid, String pname) {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.pa != null && this.pa.size() > 0) {
                for (PropertyAddedListener l : this.pa) {
                    l.propertyAdded(e, type, pid, pname);
                }
            }
        }

        @Override
        public void propertyChanged(EntityStore e, int eid, PropertyTypes type, int pid) {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.pc != null && this.pc.size() > 0) {
                for (PropertyChangedListener l : this.pc) {
                    l.propertyChanged(e, eid, type, pid);
                }
            }
        }

        @Override
        public void entityRelocated(EntityStore e, int oldEid, int newEid) {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.er != null && this.er.size() > 0) {
                for (EntityRelocationListener l : this.er) {
                    l.entityRelocated(e, oldEid, newEid);
                }
            }
        }

        @Override
        public void storeStructureChanged() {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.cc != null && this.cc.size() > 0) {
                for (ChangeCountListener l : this.cc) {
                    l.storeStructureChanged();
                }
            }
        }

        @Override
        public void storeChanged() {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.cc != null && this.cc.size() > 0) {
                for (ChangeCountListener l : this.cc) {
                    l.storeChanged();
                }
            }
        }

        @Override
        public void changed() {
            if (this.s == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.cc != null && this.cc.size() > 0) {
                for (ChangeCountListener l : this.cc) {
                    l.changed();
                }
            }
        }
    }

    public static class DefaultGroupEventHandler
    implements GroupEventHandler,
    EntityGroupChangeListener {
        private EntityGroup g = null;
        private Set<EntityGroupChangeListener> gcl = null;
        private Set<WeakReference<EntityGroupChangeListener>> wgcl = null;
        private ReferenceQueue<EntityGroupChangeListener> rq = null;

        public DefaultGroupEventHandler(EntityGroup g) {
            this.g = g;
        }

        public void releaseHandler() {
            this.g = null;
        }

        private void poll() {
            if (this.g == null) {
                throw new UnsupportedOperationException("Object released");
            }
            if (this.rq != null) {
                WeakReference r = null;
                while ((r = (WeakReference)this.rq.poll()) != null) {
                    this.wgcl.remove(r);
                }
            }
        }

        @Override
        public void addGroupChangedListener(EntityGroupChangeListener l) {
            this.poll();
            if (this.gcl == null) {
                this.gcl = new HashSet<EntityGroupChangeListener>();
            }
            this.gcl.add(l);
        }

        @Override
        public boolean removeGroupChangedListener(EntityGroupChangeListener l) {
            this.poll();
            if (this.gcl == null) {
                return false;
            }
            return this.gcl.remove(l);
        }

        @Override
        public void removeAllGroupChangedListeners() {
            this.poll();
            if (this.gcl != null) {
                this.gcl.clear();
            }
            if (this.wgcl == null) {
                this.wgcl.clear();
            }
        }

        @Override
        public void entityAddedOrRemoved(EntityGroup g, Entity e, boolean added) {
            this.poll();
            if (this.gcl != null) {
                for (EntityGroupChangeListener entityGroupChangeListener : this.gcl) {
                    entityGroupChangeListener.entityAddedOrRemoved(g, e, added);
                }
            }
            if (this.wgcl != null) {
                for (WeakReference weakReference : this.wgcl) {
                    EntityGroupChangeListener l = (EntityGroupChangeListener)weakReference.get();
                    if (l == null) continue;
                    l.entityAddedOrRemoved(g, e, added);
                }
            }
        }

        @Override
        public void entityGroupReleased(EntityGroup g) {
            this.poll();
            if (this.gcl != null) {
                for (EntityGroupChangeListener entityGroupChangeListener : this.gcl) {
                    entityGroupChangeListener.entityGroupReleased(g);
                }
            }
            if (this.wgcl != null) {
                for (WeakReference weakReference : this.wgcl) {
                    EntityGroupChangeListener l = (EntityGroupChangeListener)weakReference.get();
                    if (l == null) continue;
                    l.entityGroupReleased(g);
                }
            }
        }

        @Override
        public void entityAddedOrRemoved(EntityGroup g, EntityGroup ear, boolean added) {
            this.poll();
            if (this.gcl != null) {
                for (EntityGroupChangeListener entityGroupChangeListener : this.gcl) {
                    entityGroupChangeListener.entityAddedOrRemoved(g, ear, added);
                }
            }
            if (this.wgcl != null) {
                for (WeakReference weakReference : this.wgcl) {
                    EntityGroupChangeListener l = (EntityGroupChangeListener)weakReference.get();
                    if (l == null) continue;
                    l.entityAddedOrRemoved(g, ear, added);
                }
            }
        }

        @Override
        public void addWeakGroupChangedListener(WeakHandler<EntityGroupChangeListener> l) {
            this.poll();
            if (this.wgcl == null) {
                this.wgcl = new HashSet<WeakReference<EntityGroupChangeListener>>();
                this.rq = new ReferenceQueue();
            }
            WeakReference<EntityGroupChangeListener> w = l.getWeakReference(this.rq);
            this.wgcl.add(w);
        }

        @Override
        public boolean removeWeakGroupChangedListener(WeakHandler<EntityGroupChangeListener> l) {
            this.poll();
            if (this.wgcl == null) {
                return false;
            }
            WeakReference<EntityGroupChangeListener> w = l.getWeakReference(this.rq);
            return this.wgcl.remove(w);
        }
    }

    public static interface WeakHandler<T> {
        public WeakReference<T> getWeakReference(ReferenceQueue<T> var1);
    }

    public static interface GroupEventHandler {
        public void addGroupChangedListener(EntityGroupChangeListener var1);

        public boolean removeGroupChangedListener(EntityGroupChangeListener var1);

        public void addWeakGroupChangedListener(WeakHandler<EntityGroupChangeListener> var1);

        public boolean removeWeakGroupChangedListener(WeakHandler<EntityGroupChangeListener> var1);

        public void removeAllGroupChangedListeners();
    }

    public static interface StoreEventHandler {
        public void addEntityAddedListener(EntityAddedListener var1);

        public void addPropertyAddedListener(PropertyAddedListener var1);

        public void addPropertyChangedListener(PropertyChangedListener var1);

        public void addEntityRelocationListener(EntityRelocationListener var1);

        public void addChangeCountListener(ChangeCountListener var1);

        public boolean removeEntityAddedListener(EntityAddedListener var1);

        public boolean removePropertyAddedListener(PropertyAddedListener var1);

        public boolean removePropertyChangedListener(PropertyChangedListener var1);

        public boolean removeEntityRelocationListener(EntityRelocationListener var1);

        public boolean removeChangeCountListener(ChangeCountListener var1);

        public void removeAllListeners();
    }

    public static interface EntityGroupChangeListener {
        public void entityAddedOrRemoved(EntityGroup var1, Entity var2, boolean var3);

        public void entityAddedOrRemoved(EntityGroup var1, EntityGroup var2, boolean var3);

        public void entityGroupReleased(EntityGroup var1);
    }

    public static interface ChangeCountListener {
        public void storeStructureChanged();

        public void storeChanged();

        public void changed();
    }

    public static interface EntityRelocationListener {
        public void entityRelocated(EntityStore var1, int var2, int var3);
    }

    public static interface PropertyChangedListener {
        public void propertyChanged(EntityStore var1, int var2, PropertyTypes var3, int var4);
    }

    public static interface PropertyAddedListener {
        public void propertyAdded(EntityStore var1, PropertyTypes var2, int var3, String var4);
    }

    public static interface EntityAddedListener {
        public void entityAdded(EntityStore var1, int var2);
    }
}

