/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.ClustorImpl;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.HC;
import chemaxon.clustering.backend.PropertyTypes;
import chemaxon.clustering.backend.TreeNodeEntityGroup;
import chemaxon.clustering.backend.oa.ChemFormatFactory;
import chemaxon.clustering.boundary.CDescriptor;
import chemaxon.clustering.boundary.CFPDFactory;
import chemaxon.clustering.boundary.ComparableDescriptor;
import chemaxon.clustering.tools.simpleeval.IntVariable;
import chemaxon.clustering.tools.simpleeval.MultiplyDI;
import chemaxon.clustering.tools.simpleeval.OperatorDouble;
import chemaxon.clustering.tools.simpleeval.OperatorInt;
import chemaxon.clustering.util.VectorUtils;
import chemaxon.common.util.IntVector;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.modelling.util.U;
import chemaxon.marvin.modules.SubstructureSearch;
import chemaxon.sss.search.MCES;
import chemaxon.struc.Molecule;
import chemaxon.struc.StaticMolecule;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LibraryMCS
extends ClustorImpl {
    Log log = LogFactory.getLog(LibraryMCS.class);
    HC.Decorator<Molecule, StaticMolecule> smolDecorator;
    HC.Decorator<Molecule, StaticMolecule> smolGDecorator;
    IntVariable mcsSize = new IntVariable("MCSSize");
    IntVariable clusterSizeFP = new IntVariable("ClusterSizeFP");
    IntVariable clusterSizeSSS = new IntVariable("ClusterSizeSSS");
    OperatorDouble score;
    SSS<StaticMolecule> sss;
    MCS<StaticMolecule> mcs;
    int lookahead = 5;

    public void setMCS(MCS<StaticMolecule> mcs) {
        this.mcs = mcs;
    }

    public MCS getMCS() {
        return this.mcs;
    }

    public SSS getSSS() {
        return this.sss;
    }

    public void setSSS(SSS<StaticMolecule> sss) {
        this.sss = sss;
    }

    public void setLookahead(int s) {
        this.lookahead = s;
    }

    public int getLookahead() {
        return this.lookahead;
    }

    public LibraryMCS(final ChemFormatFactory ff) {
        super(ff, 2);
        if (!ff.isDescriptorSet()) {
            ff.setDescriptor(new CFPDFactory().getDescriptor("<metric>commonbits</metric>"));
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Descriptor already set. LibMCS needs to use substructure containment retaining descriptor with good MCS size predicition metrics. Recommended: chemical fingerprint using commonbits metric. Set: " + ff.getDescriptor().getFactory().getSummaryString()));
        }
        this.mcs = new NewMCES();
        this.sss = new DefaultSSS();
        this.score = new MultiplyDI(1.0, (OperatorInt)this.mcsSize);
        ff.setStoreDescriptors();
        ff.setLeavesRequired();
        ff.setStoreIntermediate();
        this.setStoreLeavesFirstParentID();
        this.setStoreClusterRepresentantDescriptor();
        this.setStoreClusterRepresentantIntermediate();
        this.setStoreFirstParentID();
        this.smolDecorator = new HC.Decorator<Molecule, StaticMolecule>("smol", PropertyTypes.OBJECTPROP, 0){

            @Override
            public void processNewLeaf(Entity node, Entity rawnode, Molecule rawmol) {
                super.processNewLeaf(node, rawnode, rawmol);
                StaticMolecule smol = new StaticMolecule(rawmol);
                this.setPropertyObject(node, smol);
            }
        };
        this.getHC().addRMDecorator(this.smolDecorator);
        this.smolGDecorator = new HC.Decorator<Molecule, StaticMolecule>("reprsmol", PropertyTypes.OBJECTPROP, 1){};
        this.getHC().addDecorator(this.smolGDecorator);
        HC.Callback clusteringCB = new HC.Callback(0){

            @Override
            public void allImportFinished(boolean cleanupRequired) {
                super.allImportFinished(cleanupRequired);
                LibraryMCS.this.score.checkUsage();
                if (LibraryMCS.this.log.isDebugEnabled()) {
                    LibraryMCS.this.log.debug((Object)"Start LibMCS clustering");
                    LibraryMCS.this.log.debug((Object)("Score function: " + LibraryMCS.this.score.toString(true) + " clustorSizeFP.isused=" + LibraryMCS.this.clusterSizeFP.isUsed() + " clustorSizeSS.isused=" + LibraryMCS.this.clusterSizeSSS.isUsed()));
                }
                if (cleanupRequired) {
                    if (LibraryMCS.this.log.isErrorEnabled()) {
                        LibraryMCS.this.log.error((Object)"Unexpected recall of clustering process");
                    }
                    throw new UnsupportedOperationException();
                }
                if (LibraryMCS.this.log.isTraceEnabled()) {
                    LibraryMCS.this.log.trace((Object)"Build similarity matrix");
                }
                SimilarityMatrix<StaticMolecule> mat = new SimilarityMatrix<StaticMolecule>(LibraryMCS.this.getHC(), ff.getDescriptor(), ff.getRetrieveLeaveDescriptor(), LibraryMCS.this.getClusterRepresentantDescriptor(), LibraryMCS.this.smolDecorator, LibraryMCS.this.smolGDecorator);
                while (true) {
                    ComparableDescriptor desc;
                    ClusterRepresentant[] pmcs;
                    int[][] pairs;
                    if (LibraryMCS.this.log.isTraceEnabled()) {
                        LibraryMCS.this.log.trace((Object)"New clustering loop: cluster leaves");
                    }
                    if ((pairs = mat.getMinimalPairs((byte)1, -1.0f, LibraryMCS.this.lookahead)) == null) {
                        if (!LibraryMCS.this.log.isTraceEnabled()) break;
                        LibraryMCS.this.log.trace((Object)"clustering finished at this level");
                        break;
                    }
                    if (LibraryMCS.this.log.isTraceEnabled()) {
                        LibraryMCS.this.log.trace((Object)("Found pair count: " + pairs.length + " pairs: " + U.toString(pairs)));
                    }
                    if ((pmcs = new ClusterRepresentant().createFromPairs(mat, pairs, LibraryMCS.this.mcs, LibraryMCS.this.sss, desc = LibraryMCS.this.getDesc())) == null || pmcs.length == 0) {
                        if (!LibraryMCS.this.log.isInfoEnabled()) break;
                        LibraryMCS.this.log.info((Object)"No match found, stop this level");
                        break;
                    }
                    int[] mcsize = new int[pmcs.length];
                    int[] clsize = new int[pmcs.length];
                    double[] s = new double[pmcs.length];
                    if (LibraryMCS.this.log.isTraceEnabled()) {
                        LibraryMCS.this.log.trace((Object)"Score matches");
                    }
                    for (int i = 0; i < pmcs.length; ++i) {
                        mcsize[i] = LibraryMCS.this.mcsSize.set(pmcs[i].getMCSSize());
                        if (LibraryMCS.this.clusterSizeFP.isUsed() || LibraryMCS.this.clusterSizeSSS.isUsed()) {
                            clsize[i] = pmcs[i].calculateClusterSize(mat, desc, LibraryMCS.this.clusterSizeSSS.isUsed() ? LibraryMCS.this.sss : null);
                        }
                        LibraryMCS.this.clusterSizeFP.set(clsize[i]);
                        LibraryMCS.this.clusterSizeSSS.set(clsize[i]);
                        s[i] = (Double)LibraryMCS.this.score.evaluate();
                    }
                    int mp = U.firstMaxIndex(s);
                    if (LibraryMCS.this.log.isTraceEnabled()) {
                        LibraryMCS.this.log.trace((Object)("Selection done. mp=" + mp));
                        LibraryMCS.this.log.trace((Object)("mcsize:   " + U.sel(mcsize, 7)));
                        LibraryMCS.this.log.trace((Object)("clsize:   " + U.sel(clsize, 7)));
                        LibraryMCS.this.log.trace((Object)("score:    " + U.sel(s)));
                    }
                    ClusterRepresentant nextCluster = pmcs[mp];
                    EntityGroup newgroup = LibraryMCS.this.addGroup(1, "MCSGROUP", null, nextCluster.reprs, nextCluster.fp, null);
                    LibraryMCS.this.smolGDecorator.setPropertyObject(newgroup.properties(), nextCluster.repr);
                    if (LibraryMCS.this.log.isTraceEnabled()) {
                        LibraryMCS.this.log.trace((Object)"Fill group; update similarity matrix");
                    }
                    nextCluster.addLeaves(newgroup, mat, LibraryMCS.this.sss);
                    if (!LibraryMCS.this.log.isTraceEnabled()) continue;
                    LibraryMCS.this.log.trace((Object)"Fill done");
                }
                if (LibraryMCS.this.log.isTraceEnabled()) {
                    LibraryMCS.this.log.trace((Object)"Add singletons");
                }
                int ni = mat.nextLeaveIndex(-1);
                int sc = 0;
                while (ni >= 0) {
                    if (LibraryMCS.this.log.isTraceEnabled()) {
                        LibraryMCS.this.log.trace((Object)("ni=" + ni));
                    }
                    CDescriptor dni = mat.getLeaveDescriptor(ni);
                    StaticMolecule sni = mat.retrieve(ni);
                    EntityGroup newgroup = LibraryMCS.this.addGroup(1, "MCSGROUP", null, sni.toMolecule().toFormat("smiles"), dni, null);
                    LibraryMCS.this.smolGDecorator.setPropertyObject(newgroup.properties(), sni);
                    newgroup.add(mat.getLeave(ni));
                    if (LibraryMCS.this.isLeavesFirstParentIDStored()) {
                        LibraryMCS.this.setFirstParentAssociation(mat.getLeave(ni), newgroup);
                    }
                    mat.replace(ni, (byte)2, newgroup.getIndex(), false);
                    ni = mat.nextLeaveIndex(ni);
                    ++sc;
                }
                if (LibraryMCS.this.log.isTraceEnabled()) {
                    LibraryMCS.this.log.trace((Object)("Singletons added: " + sc));
                }
                while (true) {
                    int levelToCluster = LibraryMCS.this.getHC().getLevelCount() - 1;
                    byte levelToClysterNtype = (byte)(2 + levelToCluster - 1);
                    if (LibraryMCS.this.log.isTraceEnabled()) {
                        LibraryMCS.this.log.trace((Object)("Round II+, Cluster level " + levelToCluster + " ====================================================="));
                        LibraryMCS.this.log.trace((Object)"Build similarity matrix");
                    }
                    mat = new SimilarityMatrix<StaticMolecule>(mat, levelToClysterNtype);
                    boolean newGroupFound = false;
                    while (true) {
                        ComparableDescriptor desc;
                        ClusterRepresentant[] pmcs;
                        int[][] pairs;
                        if (LibraryMCS.this.log.isTraceEnabled()) {
                            LibraryMCS.this.log.trace((Object)("New clustering loop: cluster at level " + levelToCluster));
                        }
                        if ((pairs = mat.getMinimalPairs(levelToClysterNtype, -1.0f, LibraryMCS.this.lookahead)) == null) {
                            if (!LibraryMCS.this.log.isTraceEnabled()) break;
                            LibraryMCS.this.log.trace((Object)"No pairs found; clustering finished at this level");
                            break;
                        }
                        if (LibraryMCS.this.log.isTraceEnabled()) {
                            LibraryMCS.this.log.trace((Object)("Found pair count: " + pairs.length + " pairs: " + U.toString(pairs)));
                        }
                        if ((pmcs = new ClusterRepresentant().createFromPairs(mat, pairs, LibraryMCS.this.mcs, LibraryMCS.this.sss, desc = LibraryMCS.this.getDesc())) == null || pmcs.length == 0) {
                            if (!LibraryMCS.this.log.isTraceEnabled()) break;
                            LibraryMCS.this.log.trace((Object)"No CS match found, stop this level");
                            break;
                        }
                        int[] mcsize = new int[pmcs.length];
                        int[] clsize = new int[pmcs.length];
                        double[] s = new double[pmcs.length];
                        if (LibraryMCS.this.log.isTraceEnabled()) {
                            LibraryMCS.this.log.trace((Object)"Score matches");
                        }
                        for (int i = 0; i < pmcs.length; ++i) {
                            mcsize[i] = LibraryMCS.this.mcsSize.set(pmcs[i].getMCSSize());
                            if (LibraryMCS.this.clusterSizeFP.isUsed() || LibraryMCS.this.clusterSizeSSS.isUsed()) {
                                clsize[i] = pmcs[i].calculateClusterSize(mat, desc, LibraryMCS.this.clusterSizeSSS.isUsed() ? LibraryMCS.this.sss : null);
                            }
                            LibraryMCS.this.clusterSizeFP.set(clsize[i]);
                            LibraryMCS.this.clusterSizeSSS.set(clsize[i]);
                            s[i] = (Double)LibraryMCS.this.score.evaluate();
                        }
                        int mp = U.firstMaxIndex(s);
                        if (LibraryMCS.this.log.isTraceEnabled()) {
                            LibraryMCS.this.log.trace((Object)("Selection done. mp=" + mp));
                            LibraryMCS.this.log.trace((Object)("mcsize:   " + U.sel(mcsize, 7)));
                            LibraryMCS.this.log.trace((Object)("clsize:   " + U.sel(clsize, 7)));
                            LibraryMCS.this.log.trace((Object)("score:    " + U.sel(s)));
                        }
                        ClusterRepresentant nextCluster = pmcs[mp];
                        if (levelToCluster + 1 == LibraryMCS.this.getHC().getLevelCount()) {
                            if (LibraryMCS.this.log.isTraceEnabled()) {
                                LibraryMCS.this.log.trace((Object)"Add one level up");
                            }
                            LibraryMCS.this.getHC().addLevel();
                        }
                        newGroupFound = true;
                        TreeNodeEntityGroup newgroup = (TreeNodeEntityGroup)LibraryMCS.this.addGroup(levelToCluster + 1, "MCSGROUP", null, nextCluster.reprs, nextCluster.fp, null);
                        LibraryMCS.this.smolGDecorator.setPropertyObject(newgroup.properties(), nextCluster.repr);
                        if (LibraryMCS.this.log.isTraceEnabled()) {
                            LibraryMCS.this.log.trace((Object)"Fill group; update similarity matrix");
                        }
                        nextCluster.addGroups(levelToClysterNtype, newgroup, mat, LibraryMCS.this.sss);
                        if (!LibraryMCS.this.log.isTraceEnabled()) continue;
                        LibraryMCS.this.log.trace((Object)"Fill done");
                    }
                    if (!newGroupFound) break;
                    if (LibraryMCS.this.log.isTraceEnabled()) {
                        LibraryMCS.this.log.trace((Object)"Add singletons");
                    }
                    ni = mat.nextNodeIndex(levelToClysterNtype, -1);
                    sc = 0;
                    while (ni >= 0) {
                        if (LibraryMCS.this.log.isTraceEnabled()) {
                            LibraryMCS.this.log.trace((Object)("ni=" + ni));
                        }
                        CDescriptor dni = mat.getGroupDescriptor(ni);
                        StaticMolecule sni = mat.retrieve(ni);
                        TreeNodeEntityGroup newgroup = (TreeNodeEntityGroup)LibraryMCS.this.addGroup(levelToCluster + 1, "MCSGROUP", null, sni.toMolecule().toFormat("smiles"), dni, null);
                        LibraryMCS.this.smolGDecorator.setPropertyObject(newgroup.properties(), sni);
                        newgroup.AddSubtree(mat.getGroup(ni));
                        if (LibraryMCS.this.isFirstParentIDStored()) {
                            LibraryMCS.this.firstParent.setPropertyInt(mat.getGroup(ni).properties(), newgroup.getIndex());
                        }
                        mat.replace(ni, (byte)(levelToClysterNtype + 1), newgroup.getIndex(), false);
                        ni = mat.nextNodeIndex(levelToClysterNtype, ni);
                        ++sc;
                    }
                    if (!LibraryMCS.this.log.isTraceEnabled()) continue;
                    LibraryMCS.this.log.trace((Object)("Singletons added: " + sc));
                }
            }
        };
        this.getHC().addDecorator(clusteringCB);
    }

    @Override
    public String getShortName() {
        return "LibMCS";
    }

    @Override
    public String getLongName() {
        return "Library MCS";
    }

    @Override
    public String getClusteringSummary() {
        return "LibraryMCS maximum common substructure based hierarchical clustering";
    }

    public static class DefaultSSS
    implements SSS<StaticMolecule> {
        Log log = LogFactory.getLog(DefaultSSS.class);
        SubstructureSearch sss = new SubstructureSearch();

        @Override
        public boolean contains(StaticMolecule substructure, StaticMolecule superstructure) {
            try {
                this.sss.setMolecules(substructure, superstructure);
                boolean match = this.sss.findFirst();
                return match;
            }
            catch (RuntimeException e) {
                Molecule mq = substructure.toMolecule();
                Molecule mt = superstructure.toMolecule();
                String sq = mq.toFormat("smiles");
                String st = mt.toFormat("smiles");
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("EXCEPTION calling SSS. Query and target in SMILES follows\n" + sq + "\n" + st + "\n" + sq + "." + st + "\n"), (Throwable)e);
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"Fall back to Molecule");
                }
                try {
                    this.sss.setMolecules(mq, mt);
                    boolean match = this.sss.findFirst();
                    return match;
                }
                catch (RuntimeException f) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"EXCEPTION in fallback", (Throwable)f);
                    }
                    throw e;
                }
            }
        }

        @Override
        public int[] getMap() {
            return this.sss.getResult();
        }
    }

    public static class NewMCES
    implements MCS<StaticMolecule> {
        MCES mcs = new MCES();
        int minComponentSize = 9;
        MCES.SearchMode searchMode;
        boolean keepLargest;

        public NewMCES() {
            this.mcs.setMinComponentSize(this.minComponentSize);
            this.keepLargest = true;
            this.mcs.setKeepLargestComponent(this.keepLargest);
            this.searchMode = MCES.SearchMode.FAST;
            this.mcs.setSearchMode(this.searchMode);
        }

        public void setMinComponentSize(int s) {
            this.minComponentSize = s;
            this.mcs.setMinComponentSize(this.minComponentSize);
        }

        public int getMinComponentSize() {
            return this.minComponentSize;
        }

        public MCES.SearchMode getSearchMode() {
            return this.searchMode;
        }

        public void setSearchMode(MCES.SearchMode sm) {
            this.searchMode = sm;
            this.mcs.setSearchMode(this.searchMode);
        }

        public void setKeepLargestComponent(boolean b) {
            this.keepLargest = b;
            this.mcs.setKeepLargestComponent(this.keepLargest);
        }

        @Override
        public StaticMolecule findMCS(StaticMolecule m1, StaticMolecule m2) {
            Molecule mol1 = m1.toMolecule();
            Molecule mol2 = m2.toMolecule();
            this.mcs.setMolecules(mol1, mol2);
            if (!this.mcs.search()) {
                return null;
            }
            Molecule ret = this.mcs.getAsMolecule();
            if (ret == null || ret.getAtomCount() == 0) {
                return null;
            }
            return new StaticMolecule(ret);
        }
    }

    public static class OldMCS
    implements MCS<StaticMolecule> {
        chemaxon.marvin.modules.MCS mcs = new chemaxon.marvin.modules.MCS();
        int minCommonSize = 9;

        public OldMCS() {
            this.mcs.setMinimumCommonSize(this.minCommonSize);
        }

        public void setMinimumCommonSize(int s) {
            this.minCommonSize = s;
            this.mcs.setMinimumCommonSize(this.minCommonSize);
        }

        public int getMinimumCommonSize() {
            return this.minCommonSize;
        }

        @Override
        public StaticMolecule findMCS(StaticMolecule m1, StaticMolecule m2) {
            this.mcs.setMolecules(m1, m2);
            if (!this.mcs.findFirst()) {
                return null;
            }
            StaticMolecule ret = this.mcs.getResultAsStaticMolecule();
            if (ret == null || ret.getAtomCount() == 0) {
                return null;
            }
            return ret;
        }
    }

    public static interface SSS<R> {
        public boolean contains(R var1, R var2);

        public int[] getMap();
    }

    public static interface MCS<R> {
        public R findMCS(R var1, R var2);
    }

    public static class SimilarityMatrix<R> {
        Log log = LogFactory.getLog(SimilarityMatrix.class);
        static final byte TYPE_NOTUSED = 0;
        static final byte TYPE_LEAVE = 1;
        static final byte TYPE_GROUP_LEVEL_1 = 2;
        int size;
        byte[] types;
        int[] ids;
        ComparableDescriptor desc;
        float[][] matrix;
        private HC hc;
        private HC.RetrievePropertyObject<R> retrleave;
        private HC.RetrievePropertyObject<R> retrgrepr;
        private HC.RetrieveDescriptor retrldesc;
        private HC.RetrieveDescriptor retrgdesc;

        public R retrieve(int i) {
            if (this.types[i] == 0) {
                throw new NullPointerException("Unused node " + i);
            }
            if (this.types[i] == 1) {
                Entity ei = this.hc.getTree().getLeaf(this.ids[i]);
                return this.retrleave.getPropertyObject(ei);
            }
            EntityGroup gi = this.hc.getTree().getGroup(this.ids[i]);
            return this.retrgrepr.getPropertyObject(gi.properties());
        }

        public SimilarityMatrix(SimilarityMatrix<R> mat, byte ntype) {
            int i;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Construct from a matrix; ntype: " + ntype));
            }
            this.hc = mat.hc;
            this.retrgrepr = mat.retrgrepr;
            this.retrleave = mat.retrleave;
            this.retrldesc = mat.retrldesc;
            this.retrgdesc = mat.retrgdesc;
            this.desc = mat.desc;
            this.size = mat.getLevelSize(ntype);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Size=" + this.size));
                this.log.trace((Object)"Init matrix");
            }
            this.types = new byte[this.size];
            this.ids = new int[this.size];
            if (this.size == 0) {
                return;
            }
            this.matrix = new float[this.size - 1][];
            int pi = mat.nextNodeIndex(ntype, -1);
            for (i = 0; i < this.size; ++i) {
                EntityGroup gi = mat.getGroup(pi);
                this.ids[i] = gi.getIndex();
                this.types[i] = ntype;
                pi = mat.nextNodeIndex(ntype, pi);
            }
            if (pi >= 0) {
                throw new IllegalStateException();
            }
            for (i = 0; i < this.size; ++i) {
                if (i >= this.size - 1) continue;
                this.matrix[i] = new float[this.size - i - 1];
                CDescriptor di = this.retrgdesc.getDescriptor(this.hc.getTree().getGroup(this.ids[i]).properties());
                for (int j = i + 1; j < this.size; ++j) {
                    CDescriptor dj = this.retrgdesc.getDescriptor(this.hc.getTree().getGroup(this.ids[j]).properties());
                    this.matrix[i][j - i - 1] = (float)this.desc.calcDistance(di, dj);
                }
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Matrix filled");
                if (this.size <= 10) {
                    this.dumpMatrixTrace(this.log);
                }
            }
        }

        final void dumpMatrixTrace(Log log) {
            int i;
            log.trace((Object)"Matrix dump:");
            StringBuffer b = new StringBuffer();
            b.append("   ");
            for (i = 0; i < this.size; ++i) {
                b.append(" [");
                b.append(TextUtils.formatNumber(this.ids[i], 5));
                b.append("] ");
            }
            log.trace((Object)b.toString());
            b = new StringBuffer();
            b.append("   ");
            for (i = 0; i < this.size; ++i) {
                b.append("   ");
                b.append(TextUtils.formatNumber(this.types[i], 3));
                b.append("   ");
            }
            log.trace((Object)b.toString());
            for (i = 0; i < this.size; ++i) {
                int j;
                b = new StringBuffer();
                b.append(TextUtils.formatNumber(this.types[i], 3));
                for (j = 0; j < i; ++j) {
                    b.append("         ");
                }
                b.append("   ---   ");
                for (j = 0; j < this.size - i - 1; ++j) {
                    b.append('|');
                    b.append(this.fn(this.matrix[i][j]));
                }
                log.trace((Object)b.toString());
            }
        }

        final String fn(double n) {
            String ret = TextUtils.formatNumber(n, 6);
            return "             ".substring(0, Math.max(0, 8 - ret.length())) + ret;
        }

        public SimilarityMatrix(HC hc, ComparableDescriptor desc, HC.RetrieveDescriptor retrldesc, HC.RetrieveDescriptor retrgdesc, HC.RetrievePropertyObject<R> retrleave, HC.RetrievePropertyObject<R> retrgrepr) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Construct");
            }
            this.hc = hc;
            this.retrgrepr = retrgrepr;
            this.retrleave = retrleave;
            this.retrldesc = retrldesc;
            this.retrgdesc = retrgdesc;
            this.desc = desc;
            this.size = hc.getLeavesCount();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Size=" + this.size));
                this.log.trace((Object)"Init matrix");
            }
            this.types = new byte[this.size];
            this.ids = new int[this.size];
            this.matrix = new float[this.size - 1][];
            for (int i = 0; i < this.size; ++i) {
                Entity ei = hc.getTree().getLeaf(i);
                this.types[i] = 1;
                this.ids[i] = ei.getIndex();
                if (i >= this.size - 1) continue;
                this.matrix[i] = new float[this.size - i - 1];
                CDescriptor di = retrldesc.getDescriptor(ei);
                for (int j = i + 1; j < this.size; ++j) {
                    Entity ej = hc.getTree().getLeaf(j);
                    CDescriptor dj = retrldesc.getDescriptor(ej);
                    this.matrix[i][j - i - 1] = (float)desc.calcDistance(di, dj);
                }
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Matrix filled");
                if (this.size <= 10) {
                    this.dumpMatrixTrace(this.log);
                }
            }
        }

        public int getLevelSize(byte ntype) {
            return U.count(this.types, ntype);
        }

        public int nextLeaveIndex(int limit) {
            return this.nextNodeIndex((byte)1, limit);
        }

        public int nextNodeIndex(byte ntype, int limit) {
            int i = limit + 1;
            if (i < 0) {
                i = 0;
            }
            while (true) {
                if (i >= this.types.length) {
                    return -1;
                }
                if (this.types[i] == ntype) {
                    return i;
                }
                if (this.types[i] != 0) {
                    ++i;
                    continue;
                }
                if (this.types[i] != 0) continue;
                if (this.ids[i] < i && this.ids[i] >= 0) {
                    throw new IllegalStateException("Error in links: i=" + i + " id[i]=" + this.ids[i]);
                }
                if ((i = this.ids[i]) < 0) break;
            }
            return -1;
        }

        public void eraseSimilarity(int index) {
            for (int i = 0; i < this.size; ++i) {
                if (i < index) {
                    this.matrix[i][index - i - 1] = -1.0f;
                    continue;
                }
                if (i <= index) continue;
                this.matrix[index][i - index - 1] = -1.0f;
            }
        }

        public void delete(int index) {
            if (this.types[index] == 0) {
                throw new IndexOutOfBoundsException("Attempt to delete an already deleted node");
            }
            int next = -1;
            if (index + 1 < this.types.length) {
                next = this.types[index + 1] == 0 ? this.ids[index + 1] : index + 1;
            }
            this.types[index] = 0;
            this.ids[index] = next;
            this.eraseSimilarity(index);
        }

        public void replace(int index, byte newType, int newID, boolean eraseSimilarity) {
            if (this.types[index] == 0) {
                throw new IndexOutOfBoundsException("Attempt to replace an already deleted node");
            }
            this.types[index] = newType;
            this.ids[index] = newID;
            if (eraseSimilarity) {
                this.eraseSimilarity(index);
            }
        }

        public Entity getLeave(int index) {
            if (this.types[index] != 1) {
                throw new IndexOutOfBoundsException("Invalid leave index: " + index);
            }
            return this.hc.getTree().getLeaf(this.ids[index]);
        }

        public EntityGroup getGroup(int index) {
            if (this.types[index] < 2) {
                throw new IndexOutOfBoundsException("Invalid group index: " + index);
            }
            return this.hc.getTree().getGroup(this.ids[index]);
        }

        public CDescriptor getLeaveDescriptor(int index) {
            return this.retrldesc.getDescriptor(this.getLeave(index));
        }

        public CDescriptor getGroupDescriptor(int index) {
            return this.retrgdesc.getDescriptor(this.getGroup(index).properties());
        }

        public int[][] getMinimalPairs(byte ntype, float maxd, int maxc) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("getMinimalPairs() maxd=" + maxd + " maxc=" + maxc));
                if (this.size <= 10) {
                    this.dumpMatrixTrace(this.log);
                }
            }
            Vector<int[]> ret = new Vector<int[]>();
            IntVector iv = new IntVector(2 * maxc + 2);
            float min = -1.0f;
            block0: while (true) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("New loop, min=" + min));
                }
                min = this.findMin(ntype, min, maxd, iv, maxc + 1 - iv.size());
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("findMin() returned, min=" + min + " iv.size=" + iv.size() + " iv: " + iv.toString()));
                }
                if (min < 0.0f || ret.size() > 0 && iv.size() / 2 + ret.size() > maxc) break;
                int i = 0;
                while (true) {
                    if (ret.size() >= maxc || i >= iv.size() / 2) continue block0;
                    ret.add(new int[]{iv.get(2 * i), iv.get(2 * i + 1)});
                    ++i;
                }
                break;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Loop exited, ret.size=" + ret.size()));
            }
            if (ret.isEmpty()) {
                return null;
            }
            return VectorUtils.toIntIntArray(ret);
        }

        public float findMin(byte ntype) {
            return this.findMin(ntype, -1.0f, -1.0f, null, 0);
        }

        public float findMin(byte ntype, float mind, float maxd, IntVector pairs, int maxPairCount) {
            float min = -1.0f;
            if (pairs != null) {
                pairs.clear();
            }
            int i = 0;
            while (i < this.size - 1 && (this.types[i] != 0 || (i = this.ids[i]) >= 0 && i < this.size - 1)) {
                if (this.types[i] == ntype) {
                    for (int j = 0; j < this.matrix[i].length; ++j) {
                        if (this.types[i + j + 1] == 0) {
                            if ((j = this.ids[i + j + 1]) < 0) break;
                            j = j - i - 1;
                        }
                        if (this.types[i + j + 1] != ntype || !(this.matrix[i][j] > mind) || !(maxd < 0.0f) && !(this.matrix[i][j] < maxd)) continue;
                        if (min < 0.0f || this.matrix[i][j] < min) {
                            min = this.matrix[i][j];
                            if (pairs == null) continue;
                            pairs.clear();
                            pairs.add(i);
                            pairs.add(i + j + 1);
                            continue;
                        }
                        if (this.matrix[i][j] != min || pairs == null || maxPairCount >= 0 && pairs.size() >= maxPairCount * 2) continue;
                        pairs.add(i);
                        pairs.add(i + j + 1);
                    }
                }
                ++i;
            }
            return min;
        }
    }

    class ClusterRepresentant {
        StaticMolecule repr;
        CDescriptor fp;
        String reprs;
        IntVector ids;
        int[] pair;

        ClusterRepresentant() {
            this.repr = null;
            this.fp = null;
            this.reprs = null;
            this.ids = null;
            this.pair = null;
        }

        ClusterRepresentant(StaticMolecule repr, CDescriptor fp, String reprs) {
            this.repr = repr;
            this.fp = fp;
            this.reprs = reprs;
            this.ids = null;
            this.pair = null;
        }

        int calculateClusterSize(SimilarityMatrix<StaticMolecule> mat, ComparableDescriptor desc, SSS<StaticMolecule> sss) {
            int ni = mat.nextLeaveIndex(-1);
            int ret = 0;
            while (ni >= 0) {
                CDescriptor dni = mat.getLeaveDescriptor(ni);
                boolean cd = desc.contains(dni, this.fp);
                if (sss == null && cd) {
                    ++ret;
                }
                boolean cs = false;
                StaticMolecule sni = null;
                if (sss != null && cd && (cs = sss.contains(this.repr, sni = mat.retrieve(ni)))) {
                    ++ret;
                }
                if (sss != null && cs != cd && LibraryMCS.this.log.isTraceEnabled()) {
                    LibraryMCS.this.log.trace((Object)("SS discrepancy. CD=" + cd + " CS=" + cs + " Q: " + this.reprs + " T: " + sni.toMolecule().toFormat("smiles")));
                }
                ni = mat.nextLeaveIndex(ni);
            }
            if (ret == 0 && this.pair != null && LibraryMCS.this.log.isWarnEnabled()) {
                LibraryMCS.this.log.warn((Object)("No cluster member found for pair " + U.sel(this.pair) + "Pair1.Pair2.ClusterRepresentant follows"));
                LibraryMCS.this.log.warn((Object)(mat.retrieve(this.pair[0]).toMolecule().toFormat("smiles") + "." + mat.retrieve(this.pair[1]).toMolecule().toFormat("smiles") + "." + this.reprs));
            }
            return ret;
        }

        ClusterRepresentant[] createFromPairs(SimilarityMatrix<StaticMolecule> mat, int[][] pairs, MCS<StaticMolecule> mcs, SSS<StaticMolecule> sss, ComparableDescriptor desc) {
            StaticMolecule[] pmcs = new StaticMolecule[pairs.length];
            String[] smi = new String[pairs.length];
            CDescriptor[] dsc = new CDescriptor[pairs.length];
            int matchcount = 0;
            for (int i = 0; i < pairs.length; ++i) {
                StaticMolecule match;
                StaticMolecule m0 = mat.retrieve(pairs[i][0]);
                StaticMolecule m1 = mat.retrieve(pairs[i][1]);
                if ((m0 == null || m1 == null) && LibraryMCS.this.log.isWarnEnabled()) {
                    LibraryMCS.this.log.warn((Object)("Error in clustering. m0: " + m0 + " m1:" + m1));
                }
                if ((match = mcs.findMCS(m0, m1)) == null) continue;
                pmcs[i] = match;
                Molecule m = pmcs[i].toMolecule();
                dsc[i] = desc.constructDescriptor(m);
                ++matchcount;
                smi[i] = m.toFormat("SMILES");
                if (LibraryMCS.this.log.isTraceEnabled()) {
                    LibraryMCS.this.log.trace((Object)("Pair " + i + " match: " + smi[i]));
                }
                for (int j = 0; j < i; ++j) {
                    if (pmcs[j] == null || !desc.equals(dsc[i], dsc[j])) continue;
                    boolean s = true;
                    if (pmcs[i].getAtomCount() != pmcs[j].getAtomCount()) {
                        s = false;
                    }
                    if (s) {
                        s = sss.contains(pmcs[i], pmcs[j]);
                    }
                    if (s) {
                        if (LibraryMCS.this.log.isTraceEnabled()) {
                            LibraryMCS.this.log.trace((Object)("Representant candidate match with #" + i + ". Ignore current one."));
                        }
                        pmcs[j] = null;
                        --matchcount;
                        continue;
                    }
                    if (!LibraryMCS.this.log.isTraceEnabled()) continue;
                    LibraryMCS.this.log.trace((Object)("FP discrepancy. Same fingerprint got for " + smi[i] + " and " + smi[j]));
                }
            }
            if (LibraryMCS.this.log.isTraceEnabled()) {
                LibraryMCS.this.log.trace((Object)("MatchCount: " + matchcount));
            }
            if (matchcount == 0) {
                return null;
            }
            ClusterRepresentant[] ret = new ClusterRepresentant[matchcount];
            int p = 0;
            for (int i = 0; i < pairs.length; ++i) {
                if (pmcs[i] == null) continue;
                ret[p] = new ClusterRepresentant(pmcs[i], dsc[i], smi[i]);
                ret[p].pair = pairs[i];
                ++p;
            }
            return ret;
        }

        void addID(int id) {
            if (this.ids == null) {
                this.ids = new IntVector();
            }
            this.ids.add(id);
        }

        int getMCSSize() {
            return this.repr.getAtomCount();
        }

        void addGroups(byte ntype, TreeNodeEntityGroup g, SimilarityMatrix<StaticMolecule> mat, SSS<StaticMolecule> sss) {
            int ni = mat.nextNodeIndex(ntype, -1);
            boolean replaced = false;
            while (ni >= 0) {
                CDescriptor dni = mat.getGroupDescriptor(ni);
                boolean cd = false;
                cd = LibraryMCS.this.getDesc().contains(dni, this.fp);
                boolean cs = false;
                if (cd) {
                    StaticMolecule sni = null;
                    sni = mat.retrieve(ni);
                    cs = sss.contains(this.repr, sni);
                    if (cs != cd && LibraryMCS.this.log.isTraceEnabled()) {
                        LibraryMCS.this.log.trace((Object)("SS discrepancy. CD=" + cd + " CS=" + cs + " Q: " + this.reprs + " T: " + sni.toMolecule().toFormat("smiles")));
                    }
                }
                if (cs) {
                    g.AddSubtree(mat.getGroup(ni));
                    if (LibraryMCS.this.isFirstParentIDStored()) {
                        LibraryMCS.this.firstParent.setPropertyInt(mat.getGroup(ni).properties(), g.getIndex());
                    }
                    if (replaced) {
                        mat.delete(ni);
                    } else {
                        mat.replace(ni, (byte)(ntype + 1), g.getIndex(), true);
                        replaced = true;
                    }
                }
                ni = mat.nextNodeIndex(ntype, ni);
            }
        }

        void addLeaves(EntityGroup g, SimilarityMatrix<StaticMolecule> mat, SSS<StaticMolecule> sss) {
            int ni = mat.nextLeaveIndex(-1);
            boolean replaced = false;
            while (ni >= 0) {
                CDescriptor dni = mat.getLeaveDescriptor(ni);
                boolean cd = false;
                cd = LibraryMCS.this.getDesc().contains(dni, this.fp);
                boolean cs = false;
                StaticMolecule sni = null;
                if (cd && (cs = sss.contains(this.repr, sni = mat.retrieve(ni))) != cd && LibraryMCS.this.log.isTraceEnabled()) {
                    LibraryMCS.this.log.trace((Object)("SS discrepancy. CD=" + cd + " CS=" + cs + " Q: " + this.reprs + " T: " + sni.toMolecule().toFormat("smiles")));
                }
                if (cs) {
                    if (LibraryMCS.this.log.isTraceEnabled()) {
                        LibraryMCS.this.log.trace((Object)("Q: " + this.reprs + " T: " + sni.toMolecule().toFormat("smiles") + " map: " + U.sel(sss.getMap())));
                    }
                    g.add(mat.getLeave(ni));
                    if (LibraryMCS.this.isLeavesFirstParentIDStored()) {
                        LibraryMCS.this.setFirstParentAssociation(mat.getLeave(ni), g);
                    }
                    if (replaced) {
                        mat.delete(ni);
                    } else {
                        mat.replace(ni, (byte)2, g.getIndex(), true);
                        replaced = true;
                    }
                }
                ni = mat.nextLeaveIndex(ni);
            }
        }
    }
}

