/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.ArbitraryEntityGroup;
import chemaxon.clustering.backend.DefaultEntityStore;
import chemaxon.clustering.backend.EPropDesc;
import chemaxon.clustering.backend.EPropValue;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.EntityProperties;
import chemaxon.clustering.backend.EntityStore;
import chemaxon.clustering.backend.PQValue;
import chemaxon.clustering.backend.PhantomEntityGroup;
import chemaxon.clustering.backend.PropertyTypes;
import chemaxon.clustering.backend.SelectionExpression;
import chemaxon.clustering.backend.SimplePQValue;
import chemaxon.clustering.backend.StoreIO;
import chemaxon.clustering.backend.StoreProperties;
import chemaxon.clustering.backend.StretchingEntityStore;
import chemaxon.clustering.backend.TreeNodeEntityGroup;
import chemaxon.clustering.backend.oa.IteratorWithException;
import chemaxon.clustering.util.Comparator;
import chemaxon.clustering.util.IntegerSet;
import chemaxon.clustering.util.IterateAccess;
import chemaxon.clustering.util.RAIterator;
import chemaxon.clustering.util.SimpleIntegerSet;
import chemaxon.clustering.util.SimpleRAIterateAccess;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MRTree
implements StoreIO.AddMoleculeNode {
    Log log = LogFactory.getLog(MRTree.class);
    public static final String GROUP_STORE_PROPERTY = "MRTREEGROUP";
    public static final String GROUP_NAME_PROPERTY = "MRTREEGNAME";
    private StretchingEntityStore leaves;
    private StretchingEntityStore nodes;
    private int npi = -1;
    private int gnpi = -1;
    private boolean storeRawMolecule = true;
    private boolean storeRawProperties = true;
    private boolean storeLeaves = true;
    private int rmpi = -1;
    IntegerSet lastImportedIdx = null;
    Map<String, EPropDesc> rawImportedProperties = null;
    public static final int defaultBatchSize = 1000;
    private int batchSize = 1000;
    private boolean importing = false;
    private StoreIO.PropertyProjection pproj = null;
    private EPropDesc rmp = null;
    private Preprocessor pproc = null;
    private StoreIO.AddMoleculeNode importVerboseCallback = null;
    public static final SelectionExpression SELECT_ALL = new SelectionExpression(){

        @Override
        public EntityGroup select(EntityStore leaves, EntityProperties properties) {
            ArbitraryEntityGroup g = new ArbitraryEntityGroup(leaves, properties);
            g.addAll();
            return g;
        }
    };
    public static final SelectionExpression SELECT_NONE = new SelectionExpression(){

        @Override
        public EntityGroup select(EntityStore leaves, EntityProperties properties) {
            return new ArbitraryEntityGroup(leaves, properties);
        }
    };
    public static final SelectionExpression SELECT_EMPTY_TREENODE = new SelectionExpression(){

        @Override
        public EntityGroup select(EntityStore leaves, EntityProperties properties) {
            return new TreeNodeEntityGroup(leaves, properties);
        }
    };
    public static final SelectionExpression SELECT_EMPTY_PHANTOM = new SelectionExpression(){

        @Override
        public EntityGroup select(EntityStore leaves, EntityProperties properties) {
            return new PhantomEntityGroup(properties);
        }
    };
    public static final SelectionExpression SELECT_EMPTY_ARBITRARY = new SelectionExpression(){

        @Override
        public EntityGroup select(EntityStore leaves, EntityProperties properties) {
            return new ArbitraryEntityGroup(leaves, properties);
        }
    };

    public MRTree(boolean storeRawMolecule, boolean storeRawProperties, boolean storeLeaves) {
        this.storeRawMolecule = storeRawMolecule;
        this.storeRawProperties = storeRawProperties;
        this.storeLeaves = storeLeaves;
    }

    public void toString(StringBuffer b, int gl, int ll) {
        b.append("MRTree dump\n");
        b.append("  storeRawMolecule=  " + this.storeRawMolecule + "\n");
        b.append("  storeRawProperties=" + this.storeRawProperties + "\n");
        b.append("  storeLeaves=       " + this.storeLeaves + "\n");
        b.append("Tree nodes (groups):\n");
        if (this.nodes == null) {
            b.append("  NULL - not allocated.\n");
        } else {
            DefaultEntityStore.toString(this.nodes, b, "  ", gl);
        }
        b.append("Tree leaves:\n");
        if (this.leaves == null) {
            b.append("  NULL - not allocated.\n");
        } else {
            DefaultEntityStore.toString(this.leaves, b, "  ", ll);
        }
    }

    public void setBatchSize(int bs) {
        this.batchSize = bs;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Batch size set to " + bs));
        }
    }

    public int importStructures(IteratorWithException<Molecule, IOException> input, boolean monitorProgress, Preprocessor pproc, StoreIO.AddMoleculeNode verboseCallback) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("importStructures(" + input.toString() + ")"));
        }
        if (this.importing) {
            throw new UnsupportedOperationException();
        }
        StoreIO io = new StoreIO();
        this.pproj = null;
        this.pproc = pproc;
        this.importVerboseCallback = verboseCallback;
        this.importing = true;
        StoreIO.DefaultAddMoleculeNode adder = new StoreIO.DefaultAddMoleculeNode();
        adder.setPartialCallback(this, this.batchSize);
        int rdct = io.addMolecules(input, adder);
        this.importing = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("importStructures() finished. Imported: " + rdct));
        }
        return rdct;
    }

    @Override
    public void importFinished(StoreIO io) {
        Vector<EPropDesc> unknowns;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"importFinished() called, process importeds");
        }
        if (!this.importing) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"importFinished() callback invoked outside the import process");
            }
            throw new UnsupportedOperationException();
        }
        EntityStore s = io.getStore();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Read store:");
            StringBuffer b = new StringBuffer();
            DefaultEntityStore.toString(s, b, "", 2);
            this.log.trace((Object)b.toString());
        }
        if (this.leaves == null && this.storeLeaves) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Construct leaves store");
                this.log.trace((Object)("New estimated obj property count: " + (s.getStringPropertyCount() + 1)));
            }
            this.leaves = StretchingEntityStore.constructDefaultStretchingStore(0, 0, 0, 0, s.getStringPropertyCount() + 1);
        }
        this.rmp = s.properties().getProperty("MOLECULE");
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Rawmol property: " + this.rmp));
        }
        if (this.pproj == null && this.storeLeaves) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Construct property projection");
            }
            this.pproj = new StoreIO.PropertyProjection(s, this.leaves);
            if (this.storeRawMolecule) {
                this.rmpi = this.pproj.ensureCopy(this.rmp).getPropertyIndex();
            } else {
                this.pproj.ensureIgnore(this.rmp);
            }
        }
        if (this.storeRawProperties && (unknowns = this.pproj.getUnknowns()) != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Map unknown properties");
            }
            for (EPropDesc i : unknowns) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Map copy " + i));
                }
                this.pproj.ensureCopy(i);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Process imported entities");
        }
        if (this.lastImportedIdx == null && this.storeLeaves) {
            this.lastImportedIdx = new SimpleIntegerSet(s.size(), this.leaves.size() + s.size() + 1);
        }
        if (this.lastImportedIdx != null) {
            this.lastImportedIdx.ensureCapacity(s.size(), this.leaves.size() + s.size() + 1);
        }
        int importedCount = 0;
        for (Entity e : s) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Imported entity: " + e));
            }
            ++importedCount;
            Entity nl = null;
            if (this.storeLeaves) {
                nl = this.leaves.add();
                this.lastImportedIdx.add(nl.getStore().indexOf(nl));
                this.pproj.projectProperties(e, nl);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("New leave entity: " + nl));
                }
            }
            if (this.pproc == null) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Invoke preprocessor");
            }
            this.pproc.processNewNode(this, nl, e, (Molecule)e.properties().getProperty(this.rmp).getValue());
        }
        s.clearEntities();
        if (this.importVerboseCallback != null) {
            this.importVerboseCallback.importFinished(null);
        }
    }

    public Entity addMolecule(Molecule m, Preprocessor pproc) {
        throw new UnsupportedOperationException();
    }

    public EntityGroup selectLastImported(boolean storeGroup, String name) {
        return this.select(new SelectionExpression(){

            @Override
            public EntityGroup select(EntityStore leaves, EntityProperties properties) {
                if (leaves != MRTree.this.leaves) {
                    throw new UnsupportedOperationException("Inconsistency error.");
                }
                if (MRTree.this.lastImportedIdx == null) {
                    throw new UnsupportedOperationException("No lastImported");
                }
                ArbitraryEntityGroup g = new ArbitraryEntityGroup(leaves, MRTree.this.lastImportedIdx, properties);
                return g;
            }
        }, storeGroup, name);
    }

    public void clearLastImportedIndex() {
        this.lastImportedIdx.removeAll();
    }

    public EntityGroup select(SelectionExpression expr, boolean storeGroup, String name) {
        if (!storeGroup) {
            return expr.select(this.leaves, null);
        }
        this.ensureNodes();
        Entity ne = this.nodes.add();
        EntityGroup g = expr.select(this.leaves, ne.properties());
        ne.flatProperties().setObjectProperty(this.npi, g);
        ne.flatProperties().setStringProperty(this.gnpi, name);
        return this.getGroup(this.nodes.indexOf(ne));
    }

    private void ensureLeaves() {
        if (this.leaves == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Construct leaves store");
            }
            this.leaves = StretchingEntityStore.constructDefaultStretchingStore(0, 0, 0, 0, 0);
        }
    }

    private void ensureNodes() {
        if (this.nodes == null) {
            this.nodes = StretchingEntityStore.constructDefaultStretchingStore(0, 0, 0, 0, 2);
            this.npi = this.nodes.addObjectProperties(new String[]{GROUP_STORE_PROPERTY})[0];
            this.gnpi = this.nodes.addStringProperties(new String[]{GROUP_NAME_PROPERTY})[0];
        }
    }

    public StoreProperties getGroupsProperties() {
        this.ensureNodes();
        return this.nodes.properties();
    }

    public EntityGroup getGroup(PQValue q) {
        for (int i = 0; i < this.getGroupCount(); ++i) {
            EntityGroup gi = this.getGroup(i);
            EPropValue p = gi.properties().getProperty(q);
            if (!q.match(p)) continue;
            return gi;
        }
        return null;
    }

    public RAIterator<EntityGroup> getGroups(String name) {
        return this.getGroups(name, null);
    }

    public RAIterator<EntityGroup> getGroups(String name, Comparator<EntityGroup> comp) {
        this.ensureNodes();
        EPropDesc np = this.nodes.properties().getProperty(PropertyTypes.STRINGPROP, this.gnpi);
        SimplePQValue pq = new SimplePQValue(np);
        pq.setStringValue(name);
        return this.getGroups(pq, comp);
    }

    public RAIterator<EntityGroup> getGroups(PQValue q) {
        return this.getGroups(q, null);
    }

    public RAIterator<EntityGroup> getGroups(final PQValue q, Comparator<EntityGroup> comp) {
        return new SimpleRAIterateAccess<EntityGroup>(new IterateAccess<EntityGroup>(){
            int i = 0;

            @Override
            public int getCC() {
                return MRTree.this.nodes.getCC();
            }

            @Override
            public EntityGroup fetchNext() {
                while (this.i < MRTree.this.getGroupCount()) {
                    EntityGroup gi;
                    EPropValue p;
                    if (!q.match(p = (gi = MRTree.this.getGroup(this.i++)).properties().getProperty(q))) continue;
                    return gi;
                }
                return null;
            }

            @Override
            public void reset() {
                this.i = 0;
            }
        }, comp);
    }

    public EntityGroup getGroup(int groupIndex) {
        Entity e = this.nodes.getEntity(groupIndex);
        EntityGroup g = (EntityGroup)e.flatProperties().getObjectProperty(this.npi);
        return g;
    }

    public EntityGroup getGroup(String groupName) {
        this.ensureNodes();
        for (int i = 0; i < this.nodes.size; ++i) {
            if (!this.getGroupName(i).equals(groupName)) continue;
            return this.getGroup(i);
        }
        return null;
    }

    public int getGroupCount() {
        if (this.nodes == null) {
            return 0;
        }
        return this.nodes.size();
    }

    public int getLeavesCount() {
        if (this.leaves == null) {
            return 0;
        }
        return this.leaves.size();
    }

    public StoreProperties getLeavesProperties() {
        this.ensureLeaves();
        return this.leaves.properties();
    }

    public Entity getLeaf(int i) {
        return this.leaves.getEntity(i);
    }

    public String getGroupName(int i) {
        return this.nodes.getEntity(i).flatProperties().getStringProperty(this.gnpi);
    }

    public Molecule getRawMolecule(Entity l) {
        if (!this.storeRawMolecule) {
            throw new UnsupportedOperationException("Raw structure not stored");
        }
        return (Molecule)l.flatProperties().getObjectProperty(this.rmpi);
    }

    public void exportSD(EntityGroup g, SDExporter e) {
    }

    @Override
    public void addNode(Molecule m, StoreIO io) {
        throw new UnsupportedOperationException("Invalid operation");
    }

    public static interface Preprocessor<R> {
        public void processNewNode(MRTree var1, Entity var2, Entity var3, R var4);
    }

    public static interface SDImporter {
        public Molecule retrieveRawMolecule(Molecule var1);

        public void createLeavesProperties(Molecule var1, StoreProperties var2);
    }

    public static interface SDExporter {
        public Molecule constructBLMolecule(Entity var1, Molecule var2);

        public Molecule constructGroupMolecule(EntityGroup var1, String var2);
    }
}

