/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.EPropDesc;
import chemaxon.clustering.backend.EPropValue;
import chemaxon.clustering.backend.PQValue;
import chemaxon.clustering.backend.PropertyTypes;
import java.util.BitSet;

public class SimplePQValue
implements PQValue {
    EPropDesc pd;
    Object value;

    public SimplePQValue(EPropDesc pd) {
        if (pd == null) {
            throw new NullPointerException("Property descriptor is null");
        }
        this.pd = pd;
    }

    @Override
    public boolean match(EPropValue v) {
        if (this.getType() != v.getType() || this.getPropertyIndex() != v.getPropertyIndex()) {
            throw new UnsupportedOperationException();
        }
        switch (this.getType()) {
            case BITSETPROP: {
                throw new UnsupportedOperationException("Not supported yet");
            }
            case DOUBLEPROP: 
            case INTPROP: 
            case STRINGPROP: {
                return this.value.equals(v.getValue());
            }
            case OBJECTPROP: {
                throw new UnsupportedOperationException("Not supported yet");
            }
        }
        throw new UnsupportedOperationException("Consistency error");
    }

    @Override
    public PropertyTypes getType() {
        return this.pd.getType();
    }

    @Override
    public String getName() {
        return this.pd.getName();
    }

    @Override
    public int getBitSetBitCount() {
        if (this.getType() != PropertyTypes.BITSETPROP) {
            throw new UnsupportedOperationException();
        }
        return this.pd.getBitSetBitCount();
    }

    @Override
    public int getPropertyIndex() {
        return this.pd.getPropertyIndex();
    }

    @Override
    public BitSet getBitSetValue() {
        if (this.getType() != PropertyTypes.BITSETPROP) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void getBitSetValue(BitSet b) {
        if (this.getType() != PropertyTypes.BITSETPROP) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getDoubleValue() {
        if (this.getType() != PropertyTypes.DOUBLEPROP) {
            throw new UnsupportedOperationException();
        }
        return (Double)this.value;
    }

    @Override
    public int getIntValue() {
        if (this.getType() != PropertyTypes.INTPROP) {
            throw new UnsupportedOperationException();
        }
        return (Integer)this.value;
    }

    @Override
    public String getStringValue() {
        if (this.getType() != PropertyTypes.STRINGPROP) {
            throw new UnsupportedOperationException();
        }
        return (String)this.value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isBitSet(int bindex) {
        if (this.getType() != PropertyTypes.BITSETPROP) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBitSetValue(BitSet b) {
        if (this.getType() != PropertyTypes.BITSETPROP) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDoubleValue(double d) {
        if (this.getType() != PropertyTypes.DOUBLEPROP) {
            throw new UnsupportedOperationException();
        }
        this.value = new Double(d);
    }

    @Override
    public void setIntValue(int v) {
        if (this.getType() != PropertyTypes.INTPROP) {
            throw new UnsupportedOperationException();
        }
        this.value = new Integer(v);
    }

    @Override
    public void setStringValue(String s) {
        if (this.getType() != PropertyTypes.STRINGPROP) {
            throw new UnsupportedOperationException();
        }
        this.value = s;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }
}

