/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.ArbitraryEntityGroup;
import chemaxon.clustering.backend.BitSetPropertyGroup;
import chemaxon.clustering.backend.DoublePropertyGroup;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.EntityProperties;
import chemaxon.clustering.backend.EntityStore;
import chemaxon.clustering.backend.Events;
import chemaxon.clustering.backend.HierarchicEntityGroup;
import chemaxon.clustering.backend.HierarchyWalker;
import chemaxon.clustering.backend.IntPropertyGroup;
import chemaxon.clustering.backend.ObjectPropertyGroup;
import chemaxon.clustering.backend.SimpleTreeWalker;
import chemaxon.clustering.util.Comparator;
import chemaxon.clustering.util.Filter;
import chemaxon.clustering.util.IntStat;
import chemaxon.clustering.util.IterateAccess;
import chemaxon.clustering.util.RAIterator;
import chemaxon.clustering.util.RandomAccess;
import chemaxon.clustering.util.SimpleRAIterateAccess;
import chemaxon.clustering.util.SimpleRAIterator;
import java.util.Vector;

public class TreeNodeEntityGroup
implements HierarchicEntityGroup,
Events.EntityGroupChangeListener {
    private EntityStore s = null;
    private EntityProperties p = null;
    private int size = 0;
    private Vector<EntityGroup> leaves = null;
    private Vector<TreeNodeEntityGroup> innerchildren = null;
    private ArbitraryEntityGroup singletons = null;
    private Events.DefaultGroupEventHandler geh = null;
    private boolean released = false;
    private boolean checkOnAddition = false;
    private boolean getSupported = true;
    private int cc = 0;

    public TreeNodeEntityGroup(EntityStore s, EntityProperties p) {
        this.s = s;
        this.p = p;
        this.cc = 0;
    }

    @Override
    public int getIndex() {
        return this.p.indexOfEntity();
    }

    @Override
    public void AddSubtree(EntityGroup subtree) {
        if (this.released) {
            throw new UnsupportedOperationException("Invoked on released object");
        }
        if (subtree instanceof TreeNodeEntityGroup) {
            if (this.innerchildren == null) {
                this.innerchildren = new Vector();
            }
            this.innerchildren.add((TreeNodeEntityGroup)subtree);
        } else {
            if (this.leaves == null) {
                this.leaves = new Vector();
            }
            this.leaves.add(subtree);
        }
        subtree.getEventHandler().addGroupChangedListener(this);
        this.size += subtree.size();
        if (this.getSupported && !subtree.isGetSupported()) {
            this.getSupported = false;
        }
        ++this.cc;
        if (this.geh != null) {
            this.geh.entityAddedOrRemoved((EntityGroup)this, subtree, true);
        }
    }

    @Override
    public RAIterator<Entity> iterator() {
        return ArbitraryEntityGroup.iterator(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Entity get(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int siz = this.getSingletonCount();
        Entity ret = null;
        if (n < siz) {
            ret = this.getSingleton(n);
        }
        for (int i = 0; i < this.getSubtreeCount(); ++i) {
            int ss = this.getSubtree(i).size();
            if (siz <= n && siz + ss > n) {
                ret = (Entity)this.getSubtree(i).get(n - siz);
            }
            siz += ss;
        }
        if (siz != this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return ret;
    }

    @Override
    public void add(Entity e) {
        if (this.released) {
            throw new UnsupportedOperationException("Invoked on released object");
        }
        if (this.singletons == null) {
            this.singletons = new ArbitraryEntityGroup(this.s, null);
            this.singletons.getEventHandler().addGroupChangedListener(this);
        }
        ++this.cc;
        this.singletons.add(e);
        if (this.geh != null) {
            this.geh.entityAddedOrRemoved((EntityGroup)this, e, true);
        }
    }

    @Override
    public boolean remove(Entity e) {
        EntityGroup g = this.find(e);
        if (g == null) {
            return false;
        }
        boolean ret = g.remove(e);
        if (!ret) {
            throw new UnsupportedOperationException("Consistency error");
        }
        ++this.cc;
        if (this.geh != null) {
            this.geh.entityAddedOrRemoved((EntityGroup)this, e, false);
        }
        return ret;
    }

    @Override
    public boolean contains(Entity e) {
        return this.find(e) != null;
    }

    private EntityGroup find(Entity e) {
        if (this.singletons != null && this.singletons.contains(e)) {
            return this.singletons;
        }
        if (this.innerchildren != null) {
            for (TreeNodeEntityGroup treeNodeEntityGroup : this.innerchildren) {
                if (!treeNodeEntityGroup.contains(e)) continue;
                return treeNodeEntityGroup;
            }
        }
        if (this.leaves != null) {
            for (EntityGroup entityGroup : this.leaves) {
                if (!entityGroup.contains(e)) continue;
                return entityGroup;
            }
        }
        return null;
    }

    @Override
    public void releaseEntityGroup() {
        if (this.released) {
            throw new UnsupportedOperationException("Invoked on released object");
        }
        if (this.innerchildren != null) {
            for (TreeNodeEntityGroup tn : this.innerchildren) {
                tn.getEventHandler().removeGroupChangedListener(this);
                tn.releaseEntityGroup();
            }
        }
        if (this.leaves != null) {
            for (EntityGroup cg : this.leaves) {
                cg.getEventHandler().removeGroupChangedListener(this);
                cg.releaseEntityGroup();
            }
        }
        if (this.singletons != null) {
            this.singletons.getEventHandler().removeGroupChangedListener(this);
            this.singletons.releaseEntityGroup();
        }
        if (this.geh != null) {
            this.geh.entityGroupReleased(this);
        }
        this.released = true;
    }

    @Override
    public IntPropertyGroup getIntPropertyGroup(int iPropIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DoublePropertyGroup getDoublePropertyGroup(int dPropIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BitSetPropertyGroup getBitSetPropertyGroup(int bPropIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ObjectPropertyGroup getObjectPropertyGroup(int oPropIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Events.GroupEventHandler getEventHandler() {
        if (this.geh == null) {
            this.geh = new Events.DefaultGroupEventHandler(this);
        }
        return this.geh;
    }

    @Override
    public void entityAddedOrRemoved(EntityGroup g, Entity e, boolean added) {
        if (this.released) {
            throw new UnsupportedOperationException("Invoked on released object");
        }
        this.size = added ? ++this.size : --this.size;
        ++this.cc;
        if (this.geh != null) {
            this.geh.entityAddedOrRemoved(g, e, added);
        }
    }

    @Override
    public void entityAddedOrRemoved(EntityGroup g, EntityGroup ear, boolean added) {
        if (this.released) {
            throw new UnsupportedOperationException("Invoked on released object");
        }
        this.size = added ? (this.size += ear.size()) : (this.size -= ear.size());
        ++this.cc;
        if (this.geh != null) {
            this.geh.entityAddedOrRemoved(g, ear, added);
        }
    }

    @Override
    public void entityGroupReleased(EntityGroup g) {
        throw new UnsupportedOperationException("Child group released before parent");
    }

    @Override
    public EntityProperties properties() {
        if (this.released) {
            throw new UnsupportedOperationException("Invoked on released object");
        }
        if (this.p == null) {
            throw new UnsupportedOperationException();
        }
        return this.p;
    }

    @Override
    public boolean isReleased() {
        return this.released;
    }

    public String toString() {
        return ArbitraryEntityGroup.toString(this);
    }

    @Override
    public int getSubtreeCount() {
        if (this.released) {
            throw new UnsupportedOperationException("Invoked on released object");
        }
        int ret = 0;
        if (this.innerchildren != null) {
            ret += this.innerchildren.size();
        }
        if (this.leaves != null) {
            ret += this.leaves.size();
        }
        return ret;
    }

    public IntStat getSubtreeSizeStat(boolean countSingletons) {
        IntStat ret = new IntStat();
        if (countSingletons) {
            ret.addValue(0, this.getSingletonCount());
        }
        for (int i = 0; i < this.getSubtreeCount(); ++i) {
            EntityGroup gi = this.getSubtree(i);
            ret.addValue(gi.size());
        }
        return ret;
    }

    @Override
    public EntityGroup getSubtree(int i) {
        if (this.released) {
            throw new UnsupportedOperationException("Invoked on released object");
        }
        if (this.innerchildren == null) {
            return this.leaves.get(i);
        }
        if (i < this.innerchildren.size()) {
            return this.innerchildren.get(i);
        }
        return this.leaves.get(i - this.innerchildren.size());
    }

    @Override
    public int getCC() {
        return this.cc;
    }

    public RAIterator<EntityGroup> iterateSubtrees(Comparator<EntityGroup> comp) {
        return this.iterateSubtrees(comp, null);
    }

    public RAIterator<EntityGroup> iterateSubtrees(Comparator<EntityGroup> comp, final Filter<EntityGroup> filt) {
        return new SimpleRAIterateAccess<EntityGroup>(new IterateAccess<EntityGroup>(){
            int pos = 0;

            @Override
            public int getCC() {
                return TreeNodeEntityGroup.this.getCC();
            }

            @Override
            public EntityGroup fetchNext() {
                while (this.pos < TreeNodeEntityGroup.this.getSubtreeCount()) {
                    EntityGroup ret = TreeNodeEntityGroup.this.getSubtree(this.pos++);
                    if (filt != null && !filt.match(ret)) continue;
                    return ret;
                }
                return null;
            }

            @Override
            public void reset() {
                this.pos = 0;
            }
        }, comp);
    }

    @Override
    public RAIterator<EntityGroup> iterateSubtrees() {
        return new SimpleRAIterator<EntityGroup>(new RandomAccess<EntityGroup>(){

            @Override
            public int size() {
                return TreeNodeEntityGroup.this.getSubtreeCount();
            }

            @Override
            public EntityGroup get(int i) {
                return TreeNodeEntityGroup.this.getSubtree(i);
            }

            @Override
            public int getCC() {
                return TreeNodeEntityGroup.this.getCC();
            }

            @Override
            public int indexOf(EntityGroup e) {
                return SimpleRAIterator.naiveIndexOf(this, e);
            }

            @Override
            public boolean isGetSupported() {
                return true;
            }
        });
    }

    @Override
    public RAIterator<Entity> iterateSingletons() {
        if (this.singletons == null) {
            return ArbitraryEntityGroup.emptyRAIterator(this, true);
        }
        return this.singletons.iterator();
    }

    @Override
    public void walk(HierarchyWalker.WalkTypes walkType, HierarchyWalker w) {
        SimpleTreeWalker.walk(walkType, this, w);
    }

    @Override
    public int getSingletonCount() {
        if (this.singletons == null) {
            return 0;
        }
        return this.singletons.size();
    }

    @Override
    public Entity getSingleton(int i) {
        return this.singletons.get(i);
    }

    @Override
    public int indexOf(Entity e) {
        return SimpleRAIterator.naiveIndexOf(this, e);
    }

    @Override
    public boolean isGetSupported() {
        return this.getSupported;
    }

    @Override
    public boolean isHierarchic() {
        return true;
    }

    @Override
    public HierarchicEntityGroup getHierarchic() {
        return this;
    }
}

