/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend.oa;

import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityProperties;
import chemaxon.clustering.backend.HC;
import chemaxon.clustering.backend.oa.ChemFormat;
import chemaxon.clustering.backend.oa.ConsolePS;
import chemaxon.clustering.backend.oa.CreatePS;
import chemaxon.clustering.backend.oa.FilePS;
import chemaxon.clustering.backend.oa.FormatFactory;
import chemaxon.clustering.backend.oa.IteratorWithException;
import chemaxon.clustering.backend.oa.OAEmpty;
import chemaxon.clustering.backend.oa.OAException;
import chemaxon.clustering.backend.oa.OAWrClus;
import chemaxon.clustering.backend.oa.OAWrMols;
import chemaxon.clustering.backend.oa.OAWrStat;
import chemaxon.clustering.backend.oa.OutputAction;
import chemaxon.clustering.backend.oa.PrintStreamWrapper;
import chemaxon.clustering.boundary.CDescriptor;
import chemaxon.clustering.boundary.CFPDFactory;
import chemaxon.clustering.boundary.ComparableDescriptor;
import chemaxon.clustering.util.RandomAccess;
import chemaxon.common.util.BasicEnvironment;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.MonitorableInputStream;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.util.FindCodeBase;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import javax.swing.ProgressMonitorInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChemFormatFactory
implements FormatFactory<Molecule, String> {
    Log log = LogFactory.getLog(ChemFormatFactory.class);
    ComparableDescriptor desc = null;
    int batchSize = 1000;
    HC hc = null;
    private Class[] actions = null;
    Vector<String> inputLocations = new Vector();
    Vector<HC.Callback<Molecule>> rawDecorators = null;
    boolean leavesRequired = false;
    HC.StoreAdditionalRawmol storeRaw = null;
    HC.RetrievePropertyObject<Molecule> retrieveRaw = null;
    HC.StoreAdditionalMolS storeIntermediare = null;
    HC.RetrievePropertyObject<String> retrieveSmiles = null;
    HC.StoreAdditionalDescriptor storeDescriptor = null;
    HC.RetrieveDescriptor retrieveDescriptor = null;

    @Override
    public ChemFormat construct(String f) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Construct " + f));
        }
        if (f == null || f.length() == 0 || f.equalsIgnoreCase("smiles") || f.toLowerCase().startsWith("smi")) {
            return new ChemFormat(this, ChemFormat.format.smiles);
        }
        if (f.equalsIgnoreCase("sdf")) {
            return new ChemFormat(this, ChemFormat.format.sdf);
        }
        return null;
    }

    @Override
    public CreatePS<PrintStreamWrapper> getPS(String spec) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getPS " + spec));
        }
        if (spec.equals("-") || spec.equals("-2")) {
            return new ConsolePS(spec);
        }
        return new FilePS(spec);
    }

    @Override
    public OutputAction createOutputAction(Class oa, String param) throws OAException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Create output action " + oa.getName() + " params: " + param));
            }
            String[] opts = param.split(":");
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Split options: " + U.sel(opts)));
            }
            Constructor c = oa.getConstructor(FormatFactory.class, String[].class);
            OutputAction ac = (OutputAction)c.newInstance(this, opts);
            if (ac.isLeavesRequested()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Leaves required by the output action.");
                }
                this.leavesRequired = true;
            }
            return ac;
        }
        catch (InstantiationException ex) {
            throw new OAException("Internal error", ex);
        }
        catch (IllegalAccessException ex) {
            throw new OAException("Internal error", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new OAException("Internal error", ex);
        }
        catch (InvocationTargetException ex) {
            throw new OAException("Internal error", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new OAException("Internal error", ex);
        }
        catch (SecurityException ex) {
            throw new OAException("Internal error", ex);
        }
    }

    @Override
    public synchronized Class[] getActions() {
        if (this.actions == null) {
            this.actions = new Class[]{OAWrClus.class, OAWrMols.class, OAWrStat.class, OAEmpty.class};
        }
        return this.actions;
    }

    @Override
    public Class getAction(String shortName) throws OAException {
        Class[] a = this.getActions();
        for (int i = 0; i < a.length; ++i) {
            try {
                OutputAction ac = (OutputAction)a[i].newInstance();
                if (!ac.getShortName().equalsIgnoreCase(shortName)) continue;
                return a[i];
            }
            catch (InstantiationException e) {
                throw new OAException("Internal error", e);
            }
            catch (IllegalAccessException e) {
                throw new OAException("Internal error", e);
            }
        }
        throw new OAException("Action not found: " + shortName);
    }

    @Override
    public OutputAction createOutputAction(Class oa) throws OAException {
        try {
            return (OutputAction)oa.newInstance();
        }
        catch (InstantiationException ex) {
            throw new OAException("Internal error", ex);
        }
        catch (IllegalAccessException ex) {
            throw new OAException("Internal error", ex);
        }
    }

    @Override
    public ComparableDescriptor getDescriptor() {
        if (this.desc == null) {
            this.desc = new CFPDFactory().getDescriptor(null);
        }
        return this.desc;
    }

    public void setDescriptor(ComparableDescriptor desc) {
        if (this.desc != null) {
            throw new IllegalStateException("Descriptor already specified");
        }
        if (desc == null) {
            throw new NullPointerException("No descriptor given");
        }
        this.desc = desc;
    }

    public boolean isDescriptorSet() {
        return this.desc != null;
    }

    @Override
    public HC constructHC(int l) {
        if (this.hc != null) {
            throw new IllegalStateException("HC already constructed");
        }
        this.hc = new HC(this.isLeavesStored(), l, this.getDescriptor());
        this.hc.setBatchSize(this.batchSize);
        if (this.isLeavesStored()) {
            this.hc.addRDDecorator(this.storeDescriptor);
            this.hc.addRMDecorator(this.storeRaw);
            this.hc.addRMDecorator(this.storeIntermediare);
        }
        return this.hc;
    }

    public boolean addInputLocation(String s) {
        boolean dupeFound = false;
        for (int i = 0; i < this.inputLocations.size(); ++i) {
            if (!this.inputLocations.get(i).equals(s)) continue;
            dupeFound = true;
            break;
        }
        if (dupeFound) {
            this.log.error((Object)("Duplicate input found: " + s + " Only first occurence processed."));
            return false;
        }
        this.inputLocations.add(s);
        return true;
    }

    public int getInputCount() {
        return this.inputLocations.size();
    }

    @Override
    public IteratorWithException<Molecule, IOException> iterateInputs() {
        return new SuperIterator<Molecule, IOException>(this.iterateMultipleInputs());
    }

    @Override
    public void setBatchSize(int bs) {
        this.batchSize = bs;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    public static IteratorWithException<Molecule, IOException> iterateInput(String input) throws IOException {
        return ChemFormatFactory.iterateInput(input, null);
    }

    public static IteratorWithException<Molecule, IOException> iterateInput(final String input, final Iterable<HC.Callback<Molecule>> rawDecorators) throws IOException {
        InputStream is = ChemFormatFactory.getInputStream(input, false);
        final MolImporter mi = new MolImporter(is, "c");
        return new IteratorAdapter<Molecule, IOException>(){

            @Override
            Molecule fetchNext() throws IOException {
                try {
                    Molecule m = mi.read();
                    if (rawDecorators != null) {
                        for (HC.Callback d : rawDecorators) {
                            d.processNewLeaf(null, null, m);
                        }
                    }
                    return m;
                }
                catch (Exception e) {
                    return null;
                }
            }

            public String toString() {
                return input;
            }
        };
    }

    @Override
    public IteratorWithException<IteratorWithException<Molecule, IOException>, IOException> iterateMultipleInputs() {
        final Iterator<String> si = this.inputLocations.iterator();
        return new IteratorAdapter<IteratorWithException<Molecule, IOException>, IOException>(){

            @Override
            IteratorWithException<Molecule, IOException> fetchNext() throws IOException {
                if (si.hasNext()) {
                    return ChemFormatFactory.iterateInput((String)si.next(), ChemFormatFactory.this.rawDecorators);
                }
                return null;
            }
        };
    }

    private static boolean isURL(String path) {
        return path.startsWith("http:/") || path.startsWith("https:/") || path.startsWith("ftp:/") || path.startsWith("file:/");
    }

    private static InputStream getInputStream(String s, boolean monitorProgress) throws IOException {
        InputStream is;
        if (s.equals("-")) {
            is = System.in;
        } else if (ChemFormatFactory.isURL(s)) {
            URLConnection conn = new URL(s).openConnection();
            is = conn.getInputStream();
            is = new MonitorableInputStream(is, conn.getContentLength());
        } else {
            File f = new File(s);
            if (f.exists()) {
                is = new FileInputStream(f);
            } else {
                File f2 = new File(FindCodeBase.getCodeBaseDir() + File.separator + s);
                if (f2.exists()) {
                    is = new FileInputStream(f2);
                } else {
                    is = BasicEnvironment.getResourceAsStream(ChemFormatFactory.class, "/" + s);
                    if (is == null) {
                        is = new ByteArrayInputStream(s.getBytes());
                    }
                }
            }
        }
        is = new BufferedInputStream(monitorProgress ? new ProgressMonitorInputStream(null, "Reading " + s, is) : is);
        if (s.endsWith(".gz")) {
            return new GZIPInputStream(is);
        }
        if (s.endsWith(".zip")) {
            System.out.println("zipped");
            return new ZipInputStream(is);
        }
        return is;
    }

    @Override
    public void addRawDecorator(HC.Callback<Molecule> d) {
        if (this.rawDecorators == null) {
            this.rawDecorators = new Vector();
        }
        if (d.getHierarchyPosition() != 0) {
            return;
        }
        this.rawDecorators.add(d);
    }

    @Override
    public void setLeavesRequired() {
        if (this.hc != null) {
            throw new IllegalStateException("HC already constructed");
        }
        this.leavesRequired = true;
    }

    @Override
    public boolean isRawStored() {
        return this.storeRaw != null;
    }

    @Override
    public void setStoreRawInput() {
        if (this.hc != null) {
            throw new IllegalStateException("HC already constructed");
        }
        if (this.isRawStored()) {
            return;
        }
        this.storeRaw = new HC.StoreAdditionalRawmol("CHEMAXON.CLUSTERING.RAWINPUTMOL");
    }

    @Override
    public HC.RetrievePropertyObject<Molecule> getRetrieveLeaveRaw() {
        if (this.retrieveRaw == null) {
            if (this.storeRaw != null) {
                this.retrieveRaw = this.storeRaw;
            } else {
                final HC.RetrievePropertyObject<String> rs = this.getRetrieveLeaveIntermediate();
                if (rs != null) {
                    this.retrieveRaw = new HC.RetrievePropertyObject<Molecule>(){

                        @Override
                        public Molecule getPropertyObject(Entity node) {
                            try {
                                return MolImporter.importMol((String)rs.getPropertyObject(node));
                            }
                            catch (MolFormatException e) {
                                if (ChemFormatFactory.this.log.isWarnEnabled()) {
                                    ChemFormatFactory.this.log.warn((Object)"Unable to parse stored source", (Throwable)e);
                                }
                                return null;
                            }
                        }

                        @Override
                        public Molecule getPropertyObject(EntityProperties node) {
                            try {
                                return MolImporter.importMol((String)rs.getPropertyObject(node));
                            }
                            catch (MolFormatException e) {
                                if (ChemFormatFactory.this.log.isWarnEnabled()) {
                                    ChemFormatFactory.this.log.warn((Object)"Unable to parse stored source", (Throwable)e);
                                }
                                return null;
                            }
                        }
                    };
                }
            }
        }
        return this.retrieveRaw;
    }

    @Override
    public boolean isIntermediateStored() {
        return this.storeIntermediare != null;
    }

    @Override
    public void setStoreIntermediate() {
        if (this.hc != null) {
            throw new IllegalStateException("HC already constructed");
        }
        if (this.isIntermediateStored()) {
            return;
        }
        this.storeIntermediare = new HC.StoreAdditionalMolS("CHEMAXON.CLUSTERING.LEAVESMILES", "smiles");
    }

    @Override
    public HC.RetrievePropertyObject<String> getRetrieveLeaveIntermediate() {
        if (!this.isIntermediateStored()) {
            return null;
        }
        if (this.retrieveSmiles == null) {
            this.retrieveSmiles = new HC.RetrievePropertyObject<String>(){

                @Override
                public String getPropertyObject(Entity node) {
                    return ChemFormatFactory.this.storeIntermediare.getPropertyString(node);
                }

                @Override
                public String getPropertyObject(EntityProperties node) {
                    return ChemFormatFactory.this.storeIntermediare.getPropertyString(node);
                }
            };
        }
        return this.retrieveSmiles;
    }

    @Override
    public boolean isLeavesStored() {
        return this.leavesRequired;
    }

    @Override
    public boolean isDescriptorsStored() {
        return this.storeDescriptor != null;
    }

    @Override
    public void setStoreDescriptors() {
        if (this.hc != null) {
            throw new IllegalStateException("HC already constructed");
        }
        if (this.isDescriptorsStored()) {
            return;
        }
        this.storeDescriptor = new HC.StoreAdditionalDescriptor("CHEMAXON.CLUSTERING.LEAVEDESCRIPTOR");
    }

    @Override
    public HC.RetrieveDescriptor getRetrieveLeaveDescriptor() {
        if (!this.isLeavesStored()) {
            return null;
        }
        if (this.retrieveDescriptor == null) {
            if (this.isDescriptorsStored()) {
                this.retrieveDescriptor = this.storeDescriptor;
            } else {
                final HC.RetrievePropertyObject<String> smi = this.getRetrieveLeaveIntermediate();
                final ComparableDescriptor dd = this.getDescriptor();
                if (smi != null) {
                    this.retrieveDescriptor = new HC.RetrieveDescriptor(){

                        @Override
                        public CDescriptor getDescriptor(Entity node) {
                            try {
                                String s = (String)smi.getPropertyObject(node);
                                Molecule m = s.length() == 0 ? new Molecule() : MolImporter.importMol(s);
                                return dd.constructDescriptor(m);
                            }
                            catch (Exception e) {
                                if (ChemFormatFactory.this.log.isErrorEnabled()) {
                                    ChemFormatFactory.this.log.error((Object)e);
                                }
                                return null;
                            }
                        }

                        @Override
                        public CDescriptor getPropertyObject(Entity node) {
                            return this.getDescriptor(node);
                        }

                        @Override
                        public CDescriptor getPropertyObject(EntityProperties node) {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public CDescriptor getDescriptor(EntityProperties node) {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }
                    };
                }
            }
        }
        return this.retrieveDescriptor;
    }

    @Override
    public RandomAccess<CDescriptor> getLeaveDescriptors() {
        if (!this.isLeavesStored()) {
            return null;
        }
        final HC.RetrieveDescriptor rld = this.getRetrieveLeaveDescriptor();
        if (rld == null) {
            return null;
        }
        return new RandomAccess<CDescriptor>(){

            @Override
            public int size() {
                return ChemFormatFactory.this.hc.getLeavesCount();
            }

            @Override
            public CDescriptor get(int i) {
                return rld.getDescriptor(ChemFormatFactory.this.hc.getTree().getLeaf(i));
            }

            @Override
            public int indexOf(CDescriptor e) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public int getCC() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean isGetSupported() {
                return true;
            }
        };
    }

    public static class LFin
    extends HC.Callback<Molecule> {
        Log log = LogFactory.getLog(LFin.class);

        public LFin() {
            super(0);
        }

        @Override
        public void processNewLeaf(Entity node, Entity rawnode, Molecule rawmol) {
            block11: {
                if (rawmol.getFragCount() > 1) {
                    int i;
                    block10: {
                        if (this.log.isDebugEnabled()) {
                            try {
                                this.log.debug((Object)("Multi fragment input molecule: " + rawmol.toFormat("smiles")));
                            }
                            catch (Exception e) {
                                if (!this.log.isErrorEnabled()) break block10;
                                this.log.error((Object)"Error printint info.", (Throwable)e);
                            }
                        }
                    }
                    SelectionMolecule[] sm = rawmol.findFrags();
                    int mi = 0;
                    for (i = 1; i < sm.length; ++i) {
                        if (sm[i].getAtomCount() <= sm[mi].getAtomCount()) continue;
                        mi = i;
                    }
                    for (i = 0; i < sm.length; ++i) {
                        if (i == mi) continue;
                        for (int j = sm[i].getAtomCount() - 1; j >= 0; --j) {
                            rawmol.removeAtom(sm[i].getAtom(j));
                        }
                    }
                    if (this.log.isDebugEnabled()) {
                        try {
                            this.log.debug((Object)("After smaller fragmenst removed: " + rawmol.toFormat("smiles")));
                        }
                        catch (Exception e) {
                            if (!this.log.isErrorEnabled()) break block11;
                            this.log.error((Object)"Error printint info.", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public static abstract class IteratorAdapter<T, E extends Exception>
    implements IteratorWithException<T, E> {
        boolean endReached = false;
        T next = null;

        abstract T fetchNext() throws E;

        @Override
        public boolean hasNext() throws E {
            if (this.endReached) {
                return false;
            }
            if (this.next == null) {
                this.next = this.fetchNext();
                if (this.next == null) {
                    this.endReached = true;
                    return false;
                }
            }
            return true;
        }

        @Override
        public T next() throws E {
            if (this.hasNext()) {
                T n = this.next;
                this.next = null;
                return n;
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove not supported.");
        }
    }

    public static class SuperIterator<T, E extends Exception>
    extends IteratorAdapter<T, E> {
        IteratorWithException<IteratorWithException<T, E>, E> base;
        IteratorWithException<T, E> current;

        public SuperIterator(IteratorWithException<IteratorWithException<T, E>, E> base) {
            this.base = base;
            this.current = null;
        }

        @Override
        T fetchNext() throws E {
            while (true) {
                if (this.current != null && this.current.hasNext()) {
                    return this.current.next();
                }
                if (!this.base.hasNext()) break;
                this.current = this.base.next();
            }
            this.base = null;
            return null;
        }
    }
}

