/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend.oa;

public class OALevelSelect {
    boolean upper = false;
    boolean lower = false;
    int dist = 0;
    public static final OALevelSelect LOWEST = new OALevelSelect(false, true, 0);
    public static final OALevelSelect HIGHEST = new OALevelSelect(true, false, 0);

    private OALevelSelect() {
    }

    private OALevelSelect(boolean upper, boolean lower, int dist) {
        this.upper = upper;
        this.lower = lower;
        this.dist = dist;
    }

    public int getLevel(int levelCount) {
        if (this.upper) {
            return Math.max(levelCount - this.dist - 1, 1);
        }
        if (this.lower) {
            return Math.min(levelCount - 1, 1 + this.dist);
        }
        return -1;
    }

    public static boolean checkSelectStatement(String s) {
        return OALevelSelect.parseStatement(s) != null;
    }

    public static OALevelSelect parseStatement(String s) {
        int im;
        OALevelSelect ret = null;
        String sel = null;
        String num = null;
        int ip = s.indexOf(43);
        int i = Math.max(ip, im = s.indexOf(45));
        if (i == -1) {
            sel = s;
        } else {
            sel = s.substring(0, i);
            num = s.substring(i + 1);
        }
        if (sel.equals("f") || sel.equals("fine") || sel.equals("finest") || sel.equals("l") || sel.equals("lower") || sel.equals("lowest")) {
            ret = new OALevelSelect();
            ret.lower = true;
        } else if (sel.equals("r") || sel.equals("rough") || sel.equals("roughest") || sel.equals("u") || sel.equals("upper")) {
            ret = new OALevelSelect();
            ret.upper = true;
        } else {
            return null;
        }
        if (num != null) {
            try {
                ret.dist = Math.abs(Integer.parseInt(num));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return ret;
    }

    public String toString() {
        String ret = null;
        if (this.upper) {
            ret = "upper";
            if (this.dist > 0) {
                ret = ret + "-" + this.dist;
            }
        } else if (this.lower) {
            ret = "lower";
            if (this.dist > 0) {
                ret = ret + "+" + this.dist;
            }
        }
        return ret;
    }
}

