/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend.oa;

import chemaxon.clustering.backend.Clustor;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.oa.CreatePS;
import chemaxon.clustering.backend.oa.Format;
import chemaxon.clustering.backend.oa.FormatFactory;
import chemaxon.clustering.backend.oa.OAException;
import chemaxon.clustering.backend.oa.OALevelSelect;
import chemaxon.clustering.backend.oa.OutputAction;
import chemaxon.clustering.backend.oa.PrintStreamWrapper;
import chemaxon.clustering.scaffolding.logging.VLog;
import chemaxon.clustering.util.Comparator;
import chemaxon.clustering.util.RAIterator;
import chemaxon.clustering.util.RangeIntegerSet;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.Molecule;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAWrClus
implements OutputAction {
    Log log = LogFactory.getLog(OAWrClus.class);
    CreatePS<PrintStreamWrapper> cps = null;
    Format<String> f = null;
    int order = 0;
    RangeIntegerSet clustersizes = null;
    RangeIntegerSet clusterids = null;
    FormatFactory<Molecule, String> ff;
    OALevelSelect ls = null;

    public OAWrClus() {
        this.ff = null;
    }

    public OAWrClus(FormatFactory<Molecule, String> ff, String[] params) throws OAException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Construct OAWrClus ff: " + ff.toString() + " params: " + U.sel(params)));
        }
        this.ff = ff;
        if (params.length > 0) {
            this.f = ff.construct(params[0]);
            if (this.f == null) {
                throw new OAException("Unknown wrclus format \"" + params[0] + "\" in -o wrclus " + U.sel(params));
            }
        } else {
            this.f = ff.construct(null);
        }
        this.cps = params.length > 1 && params[1] != null && params[1].length() > 0 ? ff.getPS(params[1]) : ff.getPS("-");
        if (params.length > 2) {
            String[] o = params[2].split(";");
            for (int i = 0; i < o.length; ++i) {
                if (o[i].equals("ascs")) {
                    this.order = 1;
                    continue;
                }
                if (o[i].equals("descs")) {
                    this.order = 2;
                    continue;
                }
                if (o[i].startsWith("s")) {
                    this.clustersizes = new RangeIntegerSet(o[i].substring(1));
                    continue;
                }
                if (o[i].startsWith("id")) {
                    this.clusterids = new RangeIntegerSet(o[i].substring(2));
                    continue;
                }
                this.ls = OALevelSelect.parseStatement(o[i]);
                if (this.ls != null) continue;
                throw new OAException("Unknown wrclus option \"" + o[i] + "\" in -o wrclus " + U.sel(params));
            }
        }
        if (params.length > 3) {
            throw new OAException("Too many wrclus parameters in -o wrclus " + U.sel(params));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(Clustor cl, VLog vlog) throws IOException {
        Clustor clust = cl;
        this.f.setClustor(clust);
        if (vlog != null) {
            vlog.verbose(this.toString());
        }
        this.cps.setMaxParamCount(0);
        PrintStreamWrapper ps = this.cps.getPS();
        try {
            int level = this.ls.getLevel(clust.getHC().getLevelCount());
            RAIterator<EntityGroup> groups = null;
            switch (this.order) {
                case 0: {
                    groups = clust.getHC().getGroups(level, null);
                    break;
                }
                case 1: {
                    groups = clust.getHC().getGroups(level, new Comparator<EntityGroup>(){

                        @Override
                        public boolean isGreater(EntityGroup t1, EntityGroup t2) {
                            return t1.size() > t2.size();
                        }
                    });
                    break;
                }
                case 2: {
                    groups = clust.getHC().getGroups(level, new Comparator<EntityGroup>(){

                        @Override
                        public boolean isGreater(EntityGroup t1, EntityGroup t2) {
                            return t1.size() < t2.size();
                        }
                    });
                }
            }
            while (groups.hasNext()) {
                EntityGroup g = (EntityGroup)groups.next();
                if (this.clustersizes != null && !this.clustersizes.contains(g.size()) || this.clusterids != null && !this.clusterids.contains(groups.indexOf(g))) continue;
                String s = this.f.getCluster(g);
                ps.print(s);
            }
        }
        finally {
            ps.close();
        }
    }

    @Override
    public boolean isLeavesRequested() {
        return false;
    }

    @Override
    public String getShortName() {
        return "wrclus";
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Write clusters to ");
        b.append(this.cps.toString());
        b.append(" in format ");
        b.append(((Object)this.f).toString());
        b.append(" in order ");
        switch (this.order) {
            case 0: {
                b.append("natural");
                break;
            }
            case 1: {
                b.append("asc by size");
                break;
            }
            case 2: {
                b.append("desc by size");
            }
        }
        if (this.clustersizes != null) {
            b.append(" sizes: ");
            b.append(this.clustersizes.toString());
        }
        if (this.ls != null) {
            b.append(" level: ");
            b.append(this.ls.toString());
        }
        return b.toString();
    }

    @Override
    public void setupClustor(Clustor clust) {
        clust.setStoreClusterRepresentantIntermediate();
        if (this.ls == null) {
            this.ls = clust.getPreferredLevel();
        }
    }

    @Override
    public void setupFF(FormatFactory ff) {
    }
}

