/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend.oa;

import chemaxon.clustering.backend.Clustor;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.HC;
import chemaxon.clustering.backend.oa.CreatePS;
import chemaxon.clustering.backend.oa.Format;
import chemaxon.clustering.backend.oa.FormatFactory;
import chemaxon.clustering.backend.oa.OAException;
import chemaxon.clustering.backend.oa.OALevelSelect;
import chemaxon.clustering.backend.oa.OutputAction;
import chemaxon.clustering.backend.oa.PrintStreamWrapper;
import chemaxon.clustering.scaffolding.logging.VLog;
import chemaxon.clustering.util.RAIterator;
import chemaxon.clustering.util.RangeIntegerSet;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.Molecule;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAWrMols
implements OutputAction {
    Log log = LogFactory.getLog(OAWrMols.class);
    RangeIntegerSet clusterIDsToWrite = new RangeIntegerSet("all");
    RangeIntegerSet clusterSizesToWrite = new RangeIntegerSet("all");
    FormatFactory ff;
    CreatePS<PrintStreamWrapper> cps = null;
    Format<String> f = null;
    OALevelSelect ls = null;

    public OAWrMols() {
        this.ff = null;
    }

    public OAWrMols(FormatFactory<Molecule, String> ff, String[] params) throws OAException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Construct OAWrMols ff: " + ff.toString() + " params: " + U.sel(params)));
        }
        this.ff = ff;
        if (params.length > 0) {
            this.f = ff.construct(params[0]);
            if (this.f == null) {
                throw new OAException("Unknown wrmols format \"" + params[0] + "\" in -o wrmols " + U.sel(params));
            }
        } else {
            this.f = ff.construct(null);
        }
        this.cps = params.length > 1 ? ff.getPS(params[1]) : ff.getPS("-");
        if (params.length > 2) {
            String[] o = params[2].split(";");
            for (int i = 0; i < o.length; ++i) {
                if (o[i].startsWith("s")) {
                    this.clusterSizesToWrite = new RangeIntegerSet(o[i].substring(1));
                    continue;
                }
                if (o[i].startsWith("id")) {
                    this.clusterIDsToWrite = new RangeIntegerSet(o[i].substring(2));
                    continue;
                }
                this.ls = OALevelSelect.parseStatement(o[i]);
                if (this.ls != null) continue;
                throw new OAException("Unknown wrmols option \"" + o[i] + "\" in -o wrmols " + U.sel(params));
            }
        }
        if (params.length > 3) {
            throw new OAException("Too many wrmols parameters in -o wrmols " + U.sel(params));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(Clustor cl, VLog vlog) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("perform " + this.toString()));
        }
        Clustor clust = cl;
        this.f.setClustor(cl);
        if (vlog != null) {
            vlog.verbose(this.toString());
        }
        this.cps.setMaxParamCount(2);
        int maxparam = this.cps.getParamCount();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("maxparam: " + maxparam));
        }
        PrintStreamWrapper ps = null;
        if (maxparam == 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Output all data to a single output");
            }
            ps = this.cps.getPS();
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Use multiple outputs");
        }
        try {
            int level = this.ls.getLevel(clust.getHC().getLevelCount());
            RAIterator<EntityGroup> groups = clust.getHC().getGroups(level, null);
            HC.RetrievePropertyObject grsmi = clust.getClusterRepresentantIntermediate();
            while (groups.hasNext()) {
                EntityGroup g = (EntityGroup)groups.next();
                String ms = (String)grsmi.getPropertyObject(g.properties());
                int gindex = g.getIndex();
                int gsize = g.size();
                if (!this.clusterIDsToWrite.contains(gindex) || !this.clusterSizesToWrite.contains(gsize)) continue;
                if (vlog != null && vlog.isVVerboseEnabled()) {
                    vlog.vverbose("Process group " + g);
                }
                PrintStreamWrapper lps = null;
                try {
                    if (ps == null) {
                        lps = maxparam == 1 ? this.cps.getPS(gindex) : this.cps.getPS(gindex, g.size());
                    }
                    for (Entity ei : g) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("ei: " + ei.toString()));
                        }
                        String s = this.f.getLeaf(gindex, g, ei);
                        if (ps != null) {
                            ps.print(s);
                            continue;
                        }
                        lps.print(s);
                    }
                }
                finally {
                    if (lps == null) continue;
                    lps.close();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Write cluster members in format ");
        b.append(((Object)this.f).toString());
        b.append(" to ");
        b.append(this.cps.toString());
        b.append(" for cluster IDs ");
        b.append(this.clusterIDsToWrite.toString());
        b.append(" sizes ");
        b.append(this.clusterSizesToWrite.toString());
        if (this.ls != null) {
            b.append(" level: ");
            b.append(this.ls.toString());
        }
        return b.toString();
    }

    @Override
    public boolean isLeavesRequested() {
        return true;
    }

    @Override
    public String getShortName() {
        return "wrmols";
    }

    @Override
    public void setupClustor(Clustor clust) {
        clust.setStoreClusterRepresentantIntermediate();
        if (this.ls == null) {
            this.ls = clust.getPreferredLevel();
        }
    }

    @Override
    public void setupFF(FormatFactory ff) {
        ff.setStoreIntermediate();
    }
}

