/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend.oa;

import chemaxon.clustering.backend.Clustor;
import chemaxon.clustering.backend.TreeNodeEntityGroup;
import chemaxon.clustering.backend.oa.CreatePS;
import chemaxon.clustering.backend.oa.FormatFactory;
import chemaxon.clustering.backend.oa.OAException;
import chemaxon.clustering.backend.oa.OutputAction;
import chemaxon.clustering.scaffolding.logging.VLog;
import chemaxon.clustering.tools.simplexml.create.NodeData;
import chemaxon.clustering.tools.simplexml.create.PrinterPrintStream;
import chemaxon.clustering.tools.simplexml.create.SimpleXMLNode;
import chemaxon.clustering.util.IntStat;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.modelling.util.U;
import java.io.IOException;
import java.io.PrintStream;
import java.util.BitSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAWrStat
implements OutputAction {
    Log log = LogFactory.getLog(OAWrStat.class);
    CreatePS<PrintStream> cps = null;
    public static final int FORMAT_XML = 3;
    int format = 1;
    public TreeNodeEntityGroup[] mg = null;
    public IntStat[] stat = null;
    public int stct = 0;
    public int lvct = 0;
    public int[] cc = null;
    public int[] sc = null;
    public int[] rc = null;
    public double[] ccov = null;
    public int levelCount = 0;
    public int preferredLevel = 0;

    OAWrStat() {
    }

    public OAWrStat(int format2) {
        this.format = format2;
    }

    public OAWrStat(FormatFactory<?, ?> ff, String[] params) throws OAException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Construct OAWrStat ff: " + ff.toString() + " params: " + U.sel(params)));
        }
        if (params.length > 0) {
            if (params[0].equalsIgnoreCase("brief")) {
                this.format = 0;
            } else if (params[0].equalsIgnoreCase("") || params[0].equalsIgnoreCase("normal")) {
                this.format = 1;
            } else if (params[0].equalsIgnoreCase("full")) {
                this.format = 2;
            } else if (params[0].equalsIgnoreCase("xml")) {
                this.format = 3;
            } else {
                throw new OAException("Unknown wrstat format \"" + params[0] + "\" in -o wrstat" + U.sel(params));
            }
        }
        this.cps = params.length > 1 ? ff.getPS(params[1]) : ff.getPS("-");
        if (params.length > 2) {
            throw new OAException("Too many wrclus parameters in -o wrstat " + U.sel(params));
        }
    }

    public String toString() {
        String level = "unknown";
        switch (this.format) {
            case 0: {
                level = "brief";
                break;
            }
            case 1: {
                level = "normal";
                break;
            }
            case 2: {
                level = "full";
                break;
            }
            case 3: {
                level = "xml";
            }
        }
        return "Write " + level + " cluster size statistics to " + this.cps.toString();
    }

    public void calc(Clustor clust) {
        this.levelCount = clust.getHC().getLevelCount() - 1;
        this.lvct = clust.getHC().getLeavesCount();
        this.preferredLevel = clust.getPreferredLevel().getLevel(clust.getHC().getLevelCount());
        this.mg = new TreeNodeEntityGroup[this.levelCount];
        this.stat = new IntStat[this.levelCount];
        this.cc = new int[this.levelCount];
        this.sc = new int[this.levelCount];
        this.rc = new int[this.levelCount];
        this.ccov = new double[this.levelCount];
        this.stct = clust.getHC().getLevelGroup(1).size();
        for (int i = 0; i < this.levelCount; ++i) {
            this.mg[i] = clust.getHC().getLevelGroup(i + 1);
            this.stat[i] = this.mg[i].getSubtreeSizeStat(true);
            this.cc[i] = this.stat[i].getFreq();
            this.sc[i] = this.stat[i].getFreq(1);
            this.rc[i] = this.stat[i].getFreq() - this.stat[i].getFreq(1);
            this.ccov[i] = 100.0 * ((double)this.stct - (double)this.sc[i]) / (double)this.stct;
        }
    }

    @Override
    public boolean isLeavesRequested() {
        return false;
    }

    public int[] getAllSizes() {
        BitSet freq = this.stat[0].getUsedFreqs();
        for (int i = 1; i < this.levelCount; ++i) {
            this.stat[i].setUsedFreqs(freq);
        }
        int[] ret = new int[freq.cardinality()];
        int p = 0;
        int i = freq.nextSetBit(0);
        while (i >= 0) {
            ret[p++] = i;
            i = freq.nextSetBit(i + 1);
        }
        return ret;
    }

    void performXML(Clustor clust, SimpleXMLNode root) {
        SimpleXMLNode info = new SimpleXMLNode("info", true);
        info.hintAttributesDone();
        root.addChild(info);
        info.addChild(new NodeData("structures", new String[]{"value", "" + this.stct}));
        info.addChild(new NodeData("levelCount", new String[]{"value", "" + this.levelCount}));
        info.addChild(new NodeData("preferredLevel", new String[]{"value", "" + this.preferredLevel, "textual", clust.getPreferredLevel().toString()}));
        info.close();
        SimpleXMLNode coverage = new SimpleXMLNode("coverage", true);
        coverage.hintAttributesDone();
        root.addChild(coverage);
        for (int i = 0; i < this.levelCount; ++i) {
            SimpleXMLNode level = new SimpleXMLNode("level", true);
            level.addAttribute("level", "" + (i + 1));
            level.addAttribute("preferred", "" + (i + 1 == this.preferredLevel));
            level.addAttribute("totalClusterCount", "" + this.cc[i]);
            level.addAttribute("singletonCount", "" + this.sc[i]);
            level.addAttribute("realClusterCount", "" + this.rc[i]);
            level.addAttribute("clusteringCoverage", TextUtils.formatNumber(this.ccov[i], 0, 4, 2) + "%");
            level.close();
            coverage.addChild(level);
        }
        coverage.close();
        BitSet freq = null;
        freq = this.stat[0].getUsedFreqs();
        for (int i = 1; i < this.levelCount; ++i) {
            this.stat[i].setUsedFreqs(freq);
        }
        SimpleXMLNode statistics = new SimpleXMLNode("statistics", true);
        statistics.hintAttributesDone();
        root.addChild(statistics);
        SimpleXMLNode clustersizes = new SimpleXMLNode("clustersizes", true);
        clustersizes.hintAttributesDone();
        statistics.addChild(clustersizes);
        int i = freq.nextSetBit(0);
        while (i >= 0) {
            clustersizes.addChild(new NodeData("size", new String[]{"value", "" + i}));
            i = freq.nextSetBit(i + 1);
        }
        clustersizes.close();
        for (i = 0; i < this.levelCount; ++i) {
            SimpleXMLNode level = new SimpleXMLNode("level", true);
            level.addAttribute("level", "" + (i + 1));
            level.addAttribute("preferred", "" + (i + 1 == this.preferredLevel));
            level.addAttribute("totalClusterCount", "" + this.cc[i]);
            level.addAttribute("singletonCount", "" + this.sc[i]);
            level.addAttribute("realClusterCount", "" + this.rc[i]);
            level.addAttribute("clusteringCoverage", TextUtils.formatNumber(this.ccov[i], 0, 4, 2) + "%");
            level.hintAttributesDone();
            statistics.addChild(level);
            for (int j = 0; j < this.stat[i].getFreqCount(); ++j) {
                level.addChild(new NodeData("clusters", new String[]{"size", "" + this.stat[i].getValsByIndex(j), "frequency", "" + this.stat[i].getFreqByIndex(j)}));
            }
            level.close();
        }
        statistics.close();
    }

    @Override
    public void perform(Clustor clust, VLog vlog) throws IOException {
        int i;
        int i2;
        this.cps.setMaxParamCount(0);
        PrintStream ps = this.cps.getPS();
        this.calc(clust);
        if (this.format == 3) {
            PrinterPrintStream pps = new PrinterPrintStream(ps);
            SimpleXMLNode root = new SimpleXMLNode("statistics", true);
            root.hintAttributesDone();
            SimpleXMLNode.Updater<PrinterPrintStream> updater = new SimpleXMLNode.Updater<PrinterPrintStream>(root, pps);
            ps.println("<?xml version=\"1.0\"?>");
            updater.ping();
            this.performXML(clust, root);
            root.close();
            return;
        }
        ps.println("Cluste size statistics");
        ps.println();
        ps.println("[INFO]");
        ps.println("Structure count: " + this.stct);
        ps.println("Level count:     " + this.levelCount);
        ps.println("Preferred level: " + clust.getPreferredLevel().toString());
        ps.println();
        ps.println("[COVERAGE]");
        ps.print("Level:                          ");
        for (i2 = 0; i2 < this.levelCount; ++i2) {
            if (i2 != 0) {
                ps.print('|');
            }
            if (i2 + 1 == this.preferredLevel) {
                ps.print("***");
            } else {
                ps.print("   ");
            }
            ps.print(TextUtils.formatNumberCenter(i2 + 1, 3, ' '));
            if (i2 + 1 == this.preferredLevel) {
                ps.print("***");
                continue;
            }
            ps.print("   ");
        }
        ps.println();
        ps.print("                                ");
        for (i2 = 0; i2 < this.levelCount; ++i2) {
            if (i2 != 0) {
                ps.print('+');
            }
            ps.print("---------");
        }
        ps.println();
        ps.print("Total cluster count:            ");
        for (i2 = 0; i2 < this.levelCount; ++i2) {
            if (i2 != 0) {
                ps.print('|');
            }
            ps.print(TextUtils.formatNumber(this.cc[i2], 8, ' '));
            ps.print(' ');
        }
        ps.println();
        ps.print("Singleton cluster/struct count: ");
        for (i2 = 0; i2 < this.levelCount; ++i2) {
            if (i2 != 0) {
                ps.print('|');
            }
            ps.print(TextUtils.formatNumber(this.sc[i2], 8, ' '));
            ps.print(' ');
        }
        ps.println();
        ps.print("Real cluster count:             ");
        for (i2 = 0; i2 < this.levelCount; ++i2) {
            if (i2 != 0) {
                ps.print('|');
            }
            ps.print(TextUtils.formatNumber(this.rc[i2], 8, ' '));
            ps.print(' ');
        }
        ps.println();
        ps.print("Clustering coverage (%):        ");
        for (i2 = 0; i2 < this.levelCount; ++i2) {
            if (i2 != 0) {
                ps.print('|');
            }
            ps.print(TextUtils.formatNumber(this.ccov[i2], 8, 4, 2) + "%");
        }
        ps.println();
        BitSet freq = null;
        if (this.format >= 1) {
            freq = this.stat[0].getUsedFreqs();
            for (i = 1; i < this.levelCount; ++i) {
                this.stat[i].setUsedFreqs(freq);
            }
            ps.println();
            ps.println("[STATISTICS]");
            boolean b = false;
            ps.print("Cluster size:           ");
            int i3 = freq.nextSetBit(0);
            while (i3 >= 0) {
                if (b) {
                    ps.print('|');
                } else {
                    b = true;
                }
                ps.print(TextUtils.formatNumberCenter(i3, 6, ' '));
                i3 = freq.nextSetBit(i3 + 1);
            }
            ps.println();
            b = false;
            ps.print("                        ");
            i3 = freq.nextSetBit(0);
            while (i3 >= 0) {
                if (b) {
                    ps.print('+');
                } else {
                    b = true;
                }
                ps.print("------");
                i3 = freq.nextSetBit(i3 + 1);
            }
            ps.println();
            for (i3 = 0; i3 < this.levelCount; ++i3) {
                ps.print("Frequency at level ");
                if (i3 + 1 == this.preferredLevel) {
                    ps.print("*");
                } else {
                    ps.print(" ");
                }
                ps.print(TextUtils.formatNumber(i3 + 1, 2));
                if (i3 + 1 == this.preferredLevel) {
                    ps.print("*");
                } else {
                    ps.print(" ");
                }
                ps.print(" ");
                b = false;
                int j = freq.nextSetBit(0);
                while (j >= 0) {
                    if (b) {
                        ps.print('|');
                    } else {
                        b = true;
                    }
                    int f = this.stat[i3].getFreq(j);
                    if (f == 0) {
                        ps.print("      ");
                    } else {
                        ps.print(TextUtils.formatNumber(f, 6, ' ', "  "));
                    }
                    j = freq.nextSetBit(j + 1);
                }
                ps.println();
            }
        }
        if (this.format >= 2) {
            ps.println();
            ps.println("[Cluster size-frequency]");
            ps.println("  excluding singletons");
            ps.println("========================");
            ps.print("Level:                ");
            for (i = 0; i < this.levelCount; ++i) {
                if (i != 0) {
                    ps.print('|');
                }
                if (i + 1 == this.preferredLevel) {
                    ps.print("     *****");
                } else {
                    ps.print("          ");
                }
                ps.print(TextUtils.formatNumberCenter(i + 1, 7, ' '));
                if (i + 1 == this.preferredLevel) {
                    ps.print("*****     ");
                    continue;
                }
                ps.print("          ");
            }
            ps.println();
            ps.print("                      ");
            for (i = 0; i < this.levelCount; ++i) {
                if (i != 0) {
                    ps.print('|');
                }
                ps.print(" Freq.:Single:Cumul.:Clust.");
            }
            ps.println();
            ps.print("                      ");
            for (i = 0; i < this.levelCount; ++i) {
                if (i != 0) {
                    ps.print('|');
                }
                ps.print("      :cover.:cover.:count ");
            }
            ps.println();
            ps.print("                      ");
            for (i = 0; i < this.levelCount; ++i) {
                if (i != 0) {
                    ps.print('+');
                }
                ps.print("======+======+======+======");
            }
            ps.println();
            int[] prevsifi = new int[this.levelCount];
            int[] prevfi = new int[this.levelCount];
            int i4 = freq.length() - 1;
            while (i4 >= 0 && i4 != 1) {
                ps.print("Cluster size:  ");
                ps.print(TextUtils.formatNumber(i4, 6, ' '));
                ps.print(' ');
                for (int j = 0; j < this.levelCount; ++j) {
                    int fi;
                    if (j != 0) {
                        ps.print('|');
                    }
                    if ((fi = this.stat[j].getFreq(i4)) == 0) {
                        ps.print("      :      :      :      ");
                        continue;
                    }
                    int si = i4;
                    int n = j;
                    prevsifi[n] = prevsifi[n] + si * fi;
                    int n2 = j;
                    prevfi[n2] = prevfi[n2] + fi;
                    ps.print(TextUtils.formatNumber(fi, 6, ' ', "  "));
                    ps.print(':');
                    ps.print(TextUtils.formatNumber(100.0 * (double)(si * fi) / (double)this.stct, 5, 4, 2));
                    ps.print("%:");
                    ps.print(TextUtils.formatNumber(100.0 * (double)prevsifi[j] / (double)this.stct, 5, 4, 2));
                    ps.print("%:");
                    ps.print(TextUtils.formatNumber(100.0 * (double)prevfi[j] / (double)this.rc[j], 5, 4, 2));
                    ps.print("%");
                }
                ps.println();
                freq.clear(i4);
                i4 = freq.length() - 1;
            }
        }
    }

    @Override
    public String getShortName() {
        return "wrstat";
    }

    @Override
    public void setupClustor(Clustor clust) {
    }

    @Override
    public void setupFF(FormatFactory ff) {
    }
}

