/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.boundary;

import chemaxon.clustering.boundary.BinaryFPImpl;
import chemaxon.clustering.boundary.CDescriptor;
import chemaxon.clustering.boundary.CDescriptorImpl;
import chemaxon.clustering.boundary.CFPDFactory;
import chemaxon.descriptors.ChemicalFingerprint;
import chemaxon.descriptors.FPRetriever;
import chemaxon.struc.Molecule;

class CFPImpl
extends BinaryFPImpl {
    CFPImpl(CFPDFactory f) {
        super(f);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("CFPImpl constructed. Factory: " + f.getClass().getName() + " cfg: " + f.getConfigString()));
        }
    }

    @Override
    public CDescriptor constructDescriptor(Molecule m) {
        try {
            ChemicalFingerprint fp = new ChemicalFingerprint(((CFPDFactory)this.f).cfp);
            long tbef = System.currentTimeMillis();
            fp.generate(m);
            long taft = System.currentTimeMillis();
            if (taft - tbef > 1000L && this.log.isInfoEnabled()) {
                this.log.info((Object)("FP generation took " + (taft - tbef) + " ms. Structure: " + m.toFormat("smiles")));
            }
            return new CDescriptorImpl(FPRetriever.getFP(fp));
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Exception constructing descriptor", (Throwable)e);
            }
            return null;
        }
    }
}

