/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.boundary;

import chemaxon.clustering.boundary.BinaryFPImpl;
import chemaxon.clustering.boundary.CDescriptor;
import chemaxon.clustering.boundary.CDescriptorImpl;
import chemaxon.clustering.boundary.ECFPDFactory;
import chemaxon.descriptors.ECFP;
import chemaxon.descriptors.FPRetriever;
import chemaxon.struc.Molecule;

class ECFPImpl
extends BinaryFPImpl {
    ECFPImpl(ECFPDFactory f) {
        super(f);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("ECFPImpl constructed. Factory: " + f.getClass().getName() + " cfg: " + f.getConfigString()));
        }
    }

    @Override
    public CDescriptor constructDescriptor(Molecule m) {
        try {
            int[] fpint;
            ECFP fp = new ECFP(((ECFPDFactory)this.f).cfp);
            long tbef = System.currentTimeMillis();
            fp.generate(m);
            long taft = System.currentTimeMillis();
            if (taft - tbef > 1000L && this.log.isInfoEnabled()) {
                this.log.info((Object)("FP generation took " + (taft - tbef) + " ms. Structure: " + m.toFormat("smiles")));
            }
            if ((fpint = FPRetriever.getECFPFP(fp)) == null) {
                throw new NullPointerException("Fingerprint is null");
            }
            return new CDescriptorImpl(fpint);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Exception constructing descripptor", (Throwable)e);
            }
            return null;
        }
    }
}

