/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.calculations.impl;

import chemaxon.clustering.boundary.CDescriptor;
import chemaxon.clustering.boundary.CFPDFactory;
import chemaxon.clustering.boundary.ComparableDescriptor;
import chemaxon.clustering.calculations.SimpleDiverseSubsetSelection;
import chemaxon.clustering.util.RandomAccess;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import java.util.BitSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MMDS
implements SimpleDiverseSubsetSelection {
    Log log = LogFactory.getLog(MMDS.class);
    ComparableDescriptor desc = new CFPDFactory().getDescriptor(null);
    Vector<Molecule> molecules = new Vector();
    Vector<CDescriptor> descriptors = new Vector();
    int[] lastret = null;
    int centrumMmdID = -1;
    int centrumMrmsdID = -1;
    boolean adsSet = false;
    RandomAccess<Molecule> ram = new RandomAccess<Molecule>(){

        @Override
        public int size() {
            return MMDS.this.molecules.size();
        }

        @Override
        public Molecule get(int i) {
            return MMDS.this.molecules.get(i);
        }

        @Override
        public int indexOf(Molecule e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getCC() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isGetSupported() {
            return true;
        }
    };
    RandomAccess<CDescriptor> rad = new RandomAccess<CDescriptor>(){

        @Override
        public int size() {
            return MMDS.this.descriptors.size();
        }

        @Override
        public CDescriptor get(int i) {
            return MMDS.this.descriptors.get(i);
        }

        @Override
        public int indexOf(CDescriptor e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getCC() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isGetSupported() {
            return true;
        }
    };

    int findCentrumID(centrumFindingMethods method, double[] scores) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("findCentrumID(), method=" + method.toString()));
        }
        if (this.size() == 0) {
            return -1;
        }
        if (scores != null && scores.length != this.size()) {
            throw new IndexOutOfBoundsException("Scores array size mismatch");
        }
        int bestindex = -1;
        double bestscore = 0.0;
        for (int i = 0; i < this.rad.size(); ++i) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Calculat score for input " + i));
            }
            double scorei = 0.0;
            CDescriptor di = this.rad.get(i);
            for (int j = 0; j < this.rad.size(); ++j) {
                if (i == j) continue;
                CDescriptor dj = this.rad.get(j);
                double dij = this.desc.calcDistance(di, dj);
                switch (method) {
                    case minimumOfMaximumDissimilarity: {
                        if (!(dij > scorei)) break;
                        scorei = dij;
                        break;
                    }
                    case minimumOfRMSD: {
                        scorei += dij * dij;
                    }
                }
                if (scores == null && bestindex >= 0 && bestscore <= scorei) break;
            }
            if (bestindex < 0) {
                bestindex = i;
                bestscore = scorei;
            } else if (bestscore > scorei) {
                bestindex = i;
                bestscore = scorei;
            }
            if (scores == null) continue;
            scores[i] = scorei;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("bestIndex: " + bestindex + " bestScore: " + bestscore));
        }
        return bestindex;
    }

    public int findCentrumID(centrumFindingMethods method) {
        if (this.size() == 0) {
            return -1;
        }
        switch (method) {
            case minimumOfMaximumDissimilarity: {
                if (this.centrumMmdID == -1) {
                    this.centrumMmdID = this.findCentrumID(centrumFindingMethods.minimumOfMaximumDissimilarity, null);
                }
                return this.centrumMmdID;
            }
            case minimumOfRMSD: {
                if (this.centrumMrmsdID == -1) {
                    this.centrumMrmsdID = this.findCentrumID(centrumFindingMethods.minimumOfRMSD, null);
                }
                return this.centrumMrmsdID;
            }
        }
        return -1;
    }

    public Molecule findCentrum(centrumFindingMethods method) {
        if (this.size() == 0) {
            return null;
        }
        int id = this.findCentrumID(method);
        return this.ram.get(id);
    }

    void invalidate() {
        this.lastret = null;
        this.centrumMmdID = -1;
        this.centrumMrmsdID = -1;
    }

    @Override
    public void addMolecule(Molecule m) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Add molecule called");
        }
        if (this.adsSet) {
            throw new IllegalStateException("Alternative data source already specified");
        }
        CDescriptor d = this.desc.constructDescriptor(m);
        this.molecules.add(m);
        this.descriptors.add(d);
        this.invalidate();
    }

    @Override
    public void setAlternativeDataSource(ComparableDescriptor desc, RandomAccess<Molecule> mols, RandomAccess<CDescriptor> descs) {
        this.adsSet = true;
        this.invalidate();
        if (!this.molecules.isEmpty()) {
            throw new IllegalStateException("Structures already added");
        }
        this.desc = desc;
        this.rad = descs;
        this.ram = mols;
    }

    @Override
    public int size() {
        return this.rad.size();
    }

    @Override
    public Molecule get(int i) {
        return this.ram.get(i);
    }

    @Override
    public boolean isGetSupported() {
        return true;
    }

    void fillDiverseSubsetIndices(int n) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("fillDiverseSubsetIndices() n: " + n));
        }
        if (n < 0) {
            n = this.rad.size();
        }
        if (n > this.rad.size()) {
            n = this.rad.size();
        }
        if (this.lastret != null && n <= this.lastret.length) {
            return;
        }
        if (n == 0) {
            if (this.lastret == null) {
                this.lastret = new int[0];
            }
            return;
        }
        int donect = 0;
        if (this.lastret == null || this.lastret.length == 0) {
            this.lastret = new int[n];
            this.lastret[0] = this.findCentrumID(centrumFindingMethods.minimumOfRMSD, null);
            donect = 1;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Centrum id: " + this.lastret[0]));
            }
        } else {
            int[] tmp = this.lastret;
            this.lastret = new int[n];
            System.arraycopy(tmp, 0, this.lastret, 0, tmp.length);
            donect = tmp.length;
        }
        BitSet selected = new BitSet(this.rad.size());
        for (int i = 0; i < donect; ++i) {
            selected.set(this.lastret[i]);
        }
        while (donect < this.lastret.length) {
            int bestCandidateIndex = -1;
            double bestCandidateDist = -1.0;
            for (int i = 0; i < this.rad.size(); ++i) {
                if (selected.get(i)) continue;
                CDescriptor di = this.rad.get(i);
                double mind = -1.0;
                for (int j = 0; j < donect; ++j) {
                    CDescriptor dj = this.rad.get(this.lastret[j]);
                    double dij = this.desc.calcDistance(di, dj);
                    if (!(mind < 0.0) && !(mind > dij)) continue;
                    mind = dij;
                }
                if (bestCandidateIndex >= 0 && !(bestCandidateDist < mind)) continue;
                bestCandidateIndex = i;
                bestCandidateDist = mind;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Element " + donect + " index: " + bestCandidateIndex + " dist: " + bestCandidateDist));
            }
            this.lastret[donect] = bestCandidateIndex;
            selected.set(this.lastret[donect]);
            ++donect;
        }
    }

    @Override
    public int[] getDiverseSubsetIndices(int n) {
        if (n < 0) {
            n = this.size();
        }
        this.fillDiverseSubsetIndices(n);
        int[] ret = new int[Math.min(n, this.lastret.length)];
        if (ret.length > 0) {
            System.arraycopy(this.lastret, 0, ret, 0, ret.length);
        }
        return ret;
    }

    @Override
    public Molecule[] getDiverseSubset(int n) {
        if (n < 0) {
            n = this.size();
        }
        this.fillDiverseSubsetIndices(n);
        Molecule[] ret = new Molecule[Math.min(n, this.lastret.length)];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.ram.get(this.lastret[i]);
        }
        return ret;
    }

    @Override
    public String getShortName() {
        return "MMDS";
    }

    @Override
    public String getName() {
        return "Maximum of Minimal Dissimilarity Selection";
    }

    public static void MMDSExample() {
        try {
            MMDS sel = new MMDS();
            sel.addMolecule(MolImporter.importMol("C1CCCCC1"));
            sel.addMolecule(MolImporter.importMol("CCCC1CCCCC1CCC"));
            sel.addMolecule(MolImporter.importMol("C1CCC(CCCCCCC)CC1CCC"));
            sel.addMolecule(MolImporter.importMol("N#CCCC"));
            sel.addMolecule(MolImporter.importMol("N#CCCC(CCCCCCC)"));
            Molecule[] diverses = sel.getDiverseSubset(2);
            for (int i = 0; i < diverses.length; ++i) {
                System.out.println("Molecule " + i + ": " + diverses[i].toFormat("smiles"));
            }
        }
        catch (MolFormatException e) {
            System.err.println("Exception: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        System.err.println("Maximum of Minimal Dissimilarity Selection");
        System.err.println();
        System.err.println("The purpose of command line interface is to ease experimenting with this");
        System.err.println("implementation. Thus the command line functionality is very limited.");
        System.err.println();
        System.err.println("Use argument \"-e\" to launch example an return. If not specified then");
        System.err.println("input structures are read from standard input");
        System.err.println("Results are written to the standard output in SMILES format (ID attached)");
        System.err.println("Desired output size can be specified as the first command line argument");
        System.err.println("");
        if (args.length > 1) {
            System.err.println("ERROR: only one argument accepted (desired output size or \"-e\" to call MMDSExample() ). Given " + args.length);
            return;
        }
        int n = -1;
        if (args.length == 1) {
            if (args[0].equals("-e")) {
                MMDS.MMDSExample();
                return;
            }
            try {
                n = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                System.err.println("ERROR: invalid desired output size argument: " + args[0]);
                return;
            }
        }
        try {
            long t0 = System.currentTimeMillis();
            MolImporter mi = new MolImporter(System.in);
            MMDS sel = new MMDS();
            Molecule m = null;
            while ((m = mi.read()) != null) {
                sel.addMolecule(m);
            }
            long t1 = System.currentTimeMillis();
            System.err.println(sel.size() + " structure(s) read");
            sel.getDiverseSubsetIndices(1);
            long t2 = System.currentTimeMillis();
            int[] ids = sel.getDiverseSubsetIndices(n);
            long t3 = System.currentTimeMillis();
            for (int i = 0; i < ids.length; ++i) {
                if (sel.isGetSupported()) {
                    System.out.print(sel.get(ids[i]).toFormat("smiles"));
                    System.out.print("\t");
                }
                System.out.println(ids[i]);
            }
            long t4 = System.currentTimeMillis();
            System.err.println("TIMES t_read: " + (t1 - t0) + " t_centrum: " + (t2 - t1) + " t_select: " + (t3 - t2) + " t_write: " + (t4 - t3));
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static enum centrumFindingMethods {
        minimumOfMaximumDissimilarity,
        minimumOfRMSD;

    }
}

