/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui;

import chemaxon.clustering.gui.JKlustor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class JKMenuBar
extends JMenuBar
implements ActionListener {
    private static final String VIEW_SORT_BY_PROPERTY = "SortByProperty";
    private static final String FILTER_PROPERTY = "FilterProperty";
    private static final String FILTER_MARK = "FilterMark";
    private static final String FILTER_COLOR = "FilterColor";
    private static final String FILTER_CLEAR_COLOR = "FilterClearColor";
    private static final String DISPLAY_HIDE_MARKED = "DisplayHideMarked";
    private static final String DISPLAY_HIDE_UNMARKED = "DisplayHideUnmarked";
    private static final String DISPLAY_HIDE_SINGLETONS = "DisplayHideSingletons";
    private static final String DISPLAY_SHOW_SINGLETONS = "DisplayShowSingletons";
    private static final String DISPLAY_SHOW_ALL = "DisplayShowAll";
    private static final String DISPLAY_SINGLETONS_ONLY = "DisplaySingletonsOnly";
    private static final String DISPLAY_ID = "DisplayID";
    private static final String DISPLAY_PROPERTIES_IN_TOOLTIPS = "DisplayPropertiesInTooltips";
    private static final String DISPLAY_PROPERTIES_IN_VIEWER = "DisplayPropertiesInViewer";
    private JMenu fileMenu;
    private JMenu clusterMenu;
    private JMenu displayMenu;
    private JMenu filterMenu;
    private JMenuItem displayMenuHideMarkedItem;
    private JMenuItem displayMenuHideUnmarkedItem;
    private JMenuItem displayMenuHideSingletonsItem;
    private JMenuItem displayMenuShowSingletonsItem;
    private JMenuItem displayMenuShowOnlySingletonsItem;
    private JMenuItem displayMenuShowAllItem;
    private JCheckBoxMenuItem displayId;
    private JCheckBoxMenuItem displayPropertiesInTooltip;
    private JCheckBoxMenuItem displayPropertiesInMViewTable;
    private JMenuItem filterMenuPropertyItem;
    private JMenuItem filterMenuClearColorItem;
    private JKlustor jKlustor = null;

    public JKMenuBar(JKlustor jKlustor, boolean isApplet) {
        this.jKlustor = jKlustor;
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        this.fileMenu.getAccessibleContext().setAccessibleDescription("File menu");
        this.clusterMenu = new JMenu("Cluster");
        this.clusterMenu.setMnemonic(67);
        this.displayMenu = new JMenu("Display");
        this.displayMenu.setMnemonic(68);
        this.displayMenu.getAccessibleContext().setAccessibleDescription("Display menu");
        this.filterMenu = new JMenu("Filter");
        this.filterMenu.setMnemonic(73);
        this.filterMenu.getAccessibleContext().setAccessibleDescription("Filter menu");
        JMenuItem importMenu = this.createMenuItem(jKlustor.actionHandler.importAction);
        JMenuItem exportMenuItem = this.createMenuItem(jKlustor.actionHandler.exportAction);
        JMenuItem igMenuItem = this.createMenuItem(jKlustor.actionHandler.importGraphAction);
        JMenuItem egMenuItem = this.createMenuItem(jKlustor.actionHandler.exportGraphAction);
        JMenuItem exitMenuItem = this.createMenuItem(jKlustor.actionHandler.exitAction);
        JMenuItem reportMenuItem = this.createMenuItem(jKlustor.actionHandler.reportAction);
        JMenuItem optionsMenuItem = this.createMenuItem(jKlustor.actionHandler.optionsAction);
        JMenuItem levelClusterMenuItem = this.createMenuItem(jKlustor.actionHandler.levelClusteringAction);
        JMenuItem mviewMenuItem = this.createMenuItem(jKlustor.actionHandler.mviewAction);
        mviewMenuItem.setSelected(true);
        JMenuItem rgroupMenuItem = this.createMenuItem(jKlustor.actionHandler.rtableAction);
        JMenuItem ttableMenuItem = this.createMenuItem(jKlustor.actionHandler.treeTableAction);
        JMenuItem licenseMenuItem = this.createMenuItem(jKlustor.actionHandler.licenseAction);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(mviewMenuItem);
        buttonGroup.add(rgroupMenuItem);
        buttonGroup.add(ttableMenuItem);
        this.displayMenuHideMarkedItem = new JMenuItem("Hide marked", 77);
        this.displayMenuHideMarkedItem.setAccelerator(KeyStroke.getKeyStroke(77, 8));
        this.displayMenuHideMarkedItem.getAccessibleContext().setAccessibleDescription("Hide the marked nodes.");
        this.displayMenuHideMarkedItem.addActionListener(this);
        this.displayMenuHideMarkedItem.setActionCommand(DISPLAY_HIDE_MARKED);
        this.displayMenuHideUnmarkedItem = new JMenuItem("Hide unmarked", 85);
        this.displayMenuHideUnmarkedItem.setAccelerator(KeyStroke.getKeyStroke(85, 8));
        this.displayMenuHideUnmarkedItem.getAccessibleContext().setAccessibleDescription("Hide the unmarked nodes.");
        this.displayMenuHideUnmarkedItem.addActionListener(this);
        this.displayMenuHideUnmarkedItem.setActionCommand(DISPLAY_HIDE_UNMARKED);
        this.displayMenuHideSingletonsItem = new JMenuItem("Hide singletons", 72);
        this.displayMenuHideSingletonsItem.setAccelerator(KeyStroke.getKeyStroke(72, 8));
        this.displayMenuHideSingletonsItem.getAccessibleContext().setAccessibleDescription("Hide the singletons.");
        this.displayMenuHideSingletonsItem.addActionListener(this);
        this.displayMenuHideSingletonsItem.setActionCommand(DISPLAY_HIDE_SINGLETONS);
        this.displayMenuShowSingletonsItem = new JMenuItem("Show singletons", 73);
        this.displayMenuShowSingletonsItem.setAccelerator(KeyStroke.getKeyStroke(73, 8));
        this.displayMenuShowSingletonsItem.getAccessibleContext().setAccessibleDescription("Show the singletons.");
        this.displayMenuShowSingletonsItem.addActionListener(this);
        this.displayMenuShowSingletonsItem.setActionCommand(DISPLAY_SHOW_SINGLETONS);
        this.displayMenuShowAllItem = new JMenuItem("Show all nodes", 65);
        this.displayMenuShowAllItem.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.displayMenuShowAllItem.getAccessibleContext().setAccessibleDescription("Show all nodes.");
        this.displayMenuShowAllItem.addActionListener(this);
        this.displayMenuShowAllItem.setActionCommand(DISPLAY_SHOW_ALL);
        this.displayMenuShowOnlySingletonsItem = new JMenuItem("Show singletons only", 83);
        this.displayMenuShowOnlySingletonsItem.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        this.displayMenuShowOnlySingletonsItem.getAccessibleContext().setAccessibleDescription("Show singletons only.");
        this.displayMenuShowOnlySingletonsItem.addActionListener(this);
        this.displayMenuShowOnlySingletonsItem.setActionCommand(DISPLAY_SINGLETONS_ONLY);
        this.displayId = new JCheckBoxMenuItem("ID In Dendogram", false);
        this.displayId.setActionCommand(DISPLAY_ID);
        this.displayId.addActionListener(this);
        this.displayPropertiesInTooltip = new JCheckBoxMenuItem("Properites in Tooltips", true);
        this.displayPropertiesInTooltip.setActionCommand(DISPLAY_PROPERTIES_IN_TOOLTIPS);
        this.displayPropertiesInTooltip.addActionListener(this);
        this.displayPropertiesInMViewTable = new JCheckBoxMenuItem("Properites in Viewer", true);
        this.displayPropertiesInMViewTable.setActionCommand(DISPLAY_PROPERTIES_IN_VIEWER);
        this.displayPropertiesInMViewTable.addActionListener(this);
        this.filterMenuPropertyItem = new JMenuItem("Property", 80);
        this.filterMenuPropertyItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.filterMenuPropertyItem.getAccessibleContext().setAccessibleDescription("Property filter");
        this.filterMenuPropertyItem.addActionListener(this);
        this.filterMenuPropertyItem.setActionCommand(FILTER_PROPERTY);
        this.filterMenuClearColorItem = new JMenuItem("Clear colors", 67);
        this.filterMenuClearColorItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.filterMenuClearColorItem.getAccessibleContext().setAccessibleDescription("Clear all colors");
        this.filterMenuClearColorItem.addActionListener(this);
        this.filterMenuClearColorItem.setActionCommand(FILTER_CLEAR_COLOR);
        this.fileMenu.add(importMenu);
        this.fileMenu.add(exportMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(igMenuItem);
        this.fileMenu.add(egMenuItem);
        if (!isApplet) {
            this.fileMenu.addSeparator();
            this.fileMenu.add(exitMenuItem);
        }
        this.clusterMenu.add(levelClusterMenuItem);
        this.clusterMenu.addSeparator();
        this.clusterMenu.add(reportMenuItem);
        this.clusterMenu.add(optionsMenuItem);
        JMenu modeMenu = new JMenu("Mode");
        modeMenu.add(mviewMenuItem);
        modeMenu.add(rgroupMenuItem);
        modeMenu.add(ttableMenuItem);
        this.displayMenu.add(modeMenu);
        this.displayMenu.addSeparator();
        this.displayMenu.add(this.displayMenuHideMarkedItem);
        this.displayMenu.add(this.displayMenuHideUnmarkedItem);
        this.displayMenu.add(this.displayMenuHideSingletonsItem);
        this.displayMenu.add(this.displayMenuShowSingletonsItem);
        this.displayMenu.add(this.displayMenuShowOnlySingletonsItem);
        this.displayMenu.add(this.displayMenuShowAllItem);
        this.displayMenu.addSeparator();
        this.displayMenu.add(this.displayId);
        this.displayMenu.add(this.displayPropertiesInTooltip);
        this.displayMenu.add(this.displayPropertiesInMViewTable);
        this.filterMenu.add(this.filterMenuPropertyItem);
        this.filterMenu.add(this.filterMenuClearColorItem);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.add(licenseMenuItem);
        this.add(this.fileMenu);
        this.add(this.clusterMenu);
        this.add(this.displayMenu);
        this.add(this.filterMenu);
        this.add(helpMenu);
    }

    private JMenuItem createMenuItem(Action a) {
        JMenuItem mi = new JMenuItem();
        mi.setAction(a);
        mi.setIcon(null);
        return mi;
    }

    private void addSaveMoleculesFileFilters(JFileChooser chooser) {
        FileFilter[] filters = chooser.getChoosableFileFilters();
        for (int i = 0; i < filters.length; ++i) {
            chooser.removeChoosableFileFilter(filters[i]);
        }
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return true;
            }

            @Override
            public String getDescription() {
                return "All Files (*.*)";
            }
        });
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f != null) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String fileName = f.getName();
                    int i = fileName.lastIndexOf(46);
                    if (i > 0 && i < fileName.length() - 1) {
                        return fileName.substring(i + 1).toLowerCase().equals("sdf");
                    }
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "MDL SDfiles (*.sdf)";
            }
        });
    }

    private boolean overWriteCheck(File f) {
        return !f.exists() || 1 != JOptionPane.showOptionDialog(this.jKlustor.getClusterViewer(), "Overwrite selected file?", "File exists", 0, 3, null, null, null);
    }

    private void viewSortByHandler() {
        String[] options = new String[this.jKlustor.getGraph().getPropertyCount() + 1];
        for (int i = 0; i < this.jKlustor.getGraph().getPropertyCount(); ++i) {
            options[i] = this.jKlustor.getGraph().getPropertyKey(i);
        }
        options[options.length - 1] = "Size";
        JComboBox<String> propertyCombo = new JComboBox<String>(options);
        JOptionPane pane = new JOptionPane(propertyCombo, -1, 2);
        JDialog dialog = pane.createDialog(null, "Sort by...");
        dialog.setVisible(true);
        if (pane.getValue() instanceof Integer && (Integer)pane.getValue() == 0) {
            System.out.println(propertyCombo.getSelectedItem());
            System.out.println(options[propertyCombo.getSelectedIndex()]);
        }
    }

    private void filterPropertyHandler() {
        JPanel filterPanel = new JPanel();
        String[] colorStrings = new String[]{"Red", "Blue", "Green", "Yellow", "Magenta"};
        final JComboBox<String> colorCombo = new JComboBox<String>(colorStrings);
        String[] actionStrings = new String[]{"Mark", "Color"};
        final JComboBox<String> actionCombo = new JComboBox<String>(actionStrings);
        actionCombo.setSelectedItem("Color");
        actionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (actionCombo.getSelectedItem().toString().equals("Mark")) {
                    colorCombo.setEnabled(false);
                } else {
                    colorCombo.setEnabled(true);
                }
            }
        });
        final JTextField minTextField = new JTextField();
        final JTextField maxTextField = new JTextField();
        String[] propertyStrings = new String[this.jKlustor.getGraph().getRangePropertyCount() + 1];
        propertyStrings[0] = "Merged structures";
        for (int i = 1; i < propertyStrings.length; ++i) {
            propertyStrings[i] = this.jKlustor.getGraph().getRangePropertyKey(i - 1);
        }
        final JComboBox<String> propertyCombo = new JComboBox<String>(propertyStrings);
        propertyCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (propertyCombo.getSelectedItem().toString().equals("Merged structures")) {
                    minTextField.setText("3");
                    maxTextField.setText("10");
                } else {
                    minTextField.setText(JKMenuBar.this.jKlustor.getGraph().getPropertyMin(propertyCombo.getSelectedItem().toString()).toString());
                    maxTextField.setText(JKMenuBar.this.jKlustor.getGraph().getPropertyMax(propertyCombo.getSelectedItem().toString()).toString());
                }
            }
        });
        propertyCombo.setSelectedItem("Merged structures");
        filterPanel.setLayout(new GridLayout(6, 2));
        filterPanel.add(new JLabel("Action:"));
        filterPanel.add(actionCombo);
        filterPanel.add(new JLabel("Color:"));
        filterPanel.add(colorCombo);
        filterPanel.add(new JLabel("Property:"));
        filterPanel.add(propertyCombo);
        filterPanel.add(new JLabel("Minimum:"));
        filterPanel.add(minTextField);
        filterPanel.add(new JLabel("Maximum:"));
        filterPanel.add(maxTextField);
        JOptionPane pane = new JOptionPane(filterPanel, -1, 2);
        JDialog dialog = pane.createDialog(null, "Color molecules");
        dialog.setVisible(true);
        if (pane.getValue() instanceof Integer && (Integer)pane.getValue() == 0) {
            try {
                String propName = propertyCombo.getSelectedItem().toString();
                String[] propKeys = new String[]{propName};
                Object[] condition = new Object[1];
                if (propName.equals("Merged structures")) {
                    int min = Integer.valueOf(minTextField.getText());
                    int max = Integer.valueOf(maxTextField.getText());
                    if (actionCombo.getSelectedItem().toString().equals("Mark")) {
                        this.jKlustor.getGraph().searchNewNodes(true, min, max, 0);
                    } else {
                        this.jKlustor.getGraph().searchNewNodes(false, min, max, colorCombo.getSelectedIndex() + 1);
                    }
                    return;
                }
                switch (this.jKlustor.getGraph().getRangePropertyType(propertyCombo.getSelectedIndex())) {
                    case 1: {
                        double mind = Double.valueOf(minTextField.getText());
                        double maxd = Double.valueOf(maxTextField.getText());
                        double[] cond1d = new double[]{mind, maxd};
                        condition[0] = cond1d;
                        break;
                    }
                    case 0: {
                        float minf = Float.valueOf(minTextField.getText()).floatValue();
                        float maxf = Float.valueOf(maxTextField.getText()).floatValue();
                        float[] cond1f = new float[]{minf, maxf};
                        condition[0] = cond1f;
                        break;
                    }
                    case 2: {
                        int mini = Integer.valueOf(minTextField.getText());
                        int maxi = Integer.valueOf(maxTextField.getText());
                        int[] cond1i = new int[]{mini, maxi};
                        condition[0] = cond1i;
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
                if (actionCombo.getSelectedItem().toString().equals("Mark")) {
                    this.jKlustor.getGraph().searchAndMarkNodes(propKeys, condition);
                } else {
                    int color = colorCombo.getSelectedIndex() + 1;
                    try {
                        this.jKlustor.getGraph().searchAndColorNodes(propKeys, condition, color);
                    }
                    catch (IllegalArgumentException e) {
                        JOptionPane.showMessageDialog(null, "Invalid color", "Error coloring molecules", 0);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource() instanceof JMenuItem) {
                String actionCommand = ((JMenuItem)event.getSource()).getActionCommand();
                if (actionCommand.equals(VIEW_SORT_BY_PROPERTY)) {
                    this.viewSortByHandler();
                } else if (actionCommand.equals(DISPLAY_HIDE_MARKED)) {
                    this.jKlustor.getGraph().hideMarkedNodesAndUnmark();
                    this.jKlustor.getClusterViewer().updateStructure();
                } else if (actionCommand.equals(DISPLAY_HIDE_UNMARKED)) {
                    this.jKlustor.getGraph().hideUnmarkedNodes();
                    this.jKlustor.getClusterViewer().updateStructure();
                } else if (actionCommand.equals(DISPLAY_HIDE_SINGLETONS)) {
                    this.jKlustor.getGraph().hideSingletons();
                    this.jKlustor.getClusterViewer().updateStructure();
                } else if (actionCommand.equals(DISPLAY_SHOW_SINGLETONS)) {
                    this.jKlustor.getGraph().showSingletons();
                    this.jKlustor.getClusterViewer().updateStructure();
                } else if (actionCommand.equals(DISPLAY_SHOW_ALL)) {
                    this.jKlustor.getGraph().showAll();
                    this.jKlustor.getClusterViewer().updateStructure();
                } else if (actionCommand.equals(DISPLAY_SINGLETONS_ONLY)) {
                    this.jKlustor.getGraph().showSingletonsOnly();
                    this.jKlustor.getClusterViewer().updateStructure();
                } else if (actionCommand.equals(DISPLAY_ID)) {
                    this.jKlustor.getClusterViewer().setDisplayIDInDendogram(this.displayId.getState());
                } else if (actionCommand.equals(DISPLAY_PROPERTIES_IN_TOOLTIPS)) {
                    this.jKlustor.getClusterViewer().setDisplayPropertiesInTooltips(this.displayPropertiesInTooltip.getState());
                } else if (actionCommand.equals(DISPLAY_PROPERTIES_IN_VIEWER)) {
                    this.jKlustor.getClusterViewer().setDisplayPropertiesInMViewTable(this.displayPropertiesInMViewTable.getState());
                } else if (actionCommand.equals(FILTER_PROPERTY)) {
                    this.filterPropertyHandler();
                    this.jKlustor.getClusterViewer().repaint();
                } else if (actionCommand.equals(FILTER_CLEAR_COLOR)) {
                    this.jKlustor.getGraph().clearAllColor();
                    this.jKlustor.getClusterViewer().repaint();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

