/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui;

import chemaxon.clustering.gui.JKlustor;
import java.awt.Insets;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class JKToolBar
extends JToolBar {
    private JKlustor jklustor;
    JToggleButton mview;
    JToggleButton rtable;
    JToggleButton treetable;

    public JKToolBar(JKlustor jk) {
        this.jklustor = jk;
        JButton open = this.makeButton(this.jklustor.actionHandler.importAction);
        JButton save = this.makeButton(this.jklustor.actionHandler.exportAction);
        this.mview = this.makeToggleButton(this.jklustor.actionHandler.mviewAction);
        this.mview.setSelected(true);
        this.rtable = this.makeToggleButton(this.jklustor.actionHandler.rtableAction);
        this.treetable = this.makeToggleButton(this.jklustor.actionHandler.treeTableAction);
        JButton recluster = this.makeButton(this.jklustor.actionHandler.clusterAction);
        JButton levelCluster = this.makeButton(this.jklustor.actionHandler.levelClusteringAction);
        JButton report = this.makeButton(this.jklustor.actionHandler.reportAction);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mview);
        bg.add(this.rtable);
        bg.add(this.treetable);
        this.setRollover(true);
        this.add(open);
        this.add(save);
        this.addSeparator();
        this.add(recluster);
        this.add(levelCluster);
        this.add(report);
        this.addSeparator();
        this.add(this.mview);
        this.add(this.rtable);
        this.add(this.treetable);
    }

    public void update() {
        if (this.mview.isSelected() ^ this.jklustor.isMViewMode()) {
            this.mview.setSelected(this.jklustor.isMViewMode());
        }
        if (this.treetable.isSelected() ^ this.jklustor.isTreeTableMode()) {
            this.treetable.setSelected(this.jklustor.isTreeTableMode());
        }
        if (this.rtable.isSelected() ^ this.jklustor.isRGroupMode()) {
            this.rtable.setSelected(this.jklustor.isRGroupMode());
        }
    }

    protected JButton makeButton(Action action) {
        JButton button = new JButton();
        button.setAction(action);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setText(null);
        return button;
    }

    protected JToggleButton makeToggleButton(Action action) {
        JToggleButton button = new JToggleButton();
        button.setAction(action);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setText(null);
        return button;
    }

    protected JToggleButton makeToggleButton(String imageName, String actionCommand, String toolTipText, String altText) {
        JToggleButton button = new JToggleButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        URL imgURL = JKToolBar.class.getResource(imageName);
        if (imgURL != null) {
            button.setIcon(new ImageIcon(imgURL));
            button.setMargin(new Insets(1, 1, 1, 1));
        } else {
            button.setText(altText);
        }
        return button;
    }

    protected JButton makeButton(String imageName, String actionCommand, String toolTipText, String altText) {
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        URL imgURL = JKToolBar.class.getResource(imageName);
        if (imgURL != null) {
            button.setIcon(new ImageIcon(imgURL));
            button.setMargin(new Insets(1, 1, 1, 1));
        } else {
            button.setText(altText);
        }
        return button;
    }
}

