/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui;

import chemaxon.clustering.JKlustorImport;
import chemaxon.clustering.LibraryMCS;
import chemaxon.clustering.MGraph;
import chemaxon.clustering.gui.JKMenuBar;
import chemaxon.clustering.gui.JKToolBar;
import chemaxon.clustering.gui.JKlustorActions;
import chemaxon.clustering.gui.JKlustorExport;
import chemaxon.clustering.gui.component.ClusterViewer;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.license.LicenseManager;
import chemaxon.util.CmdLine;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageProducer;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JKlustor {
    Log log = LogFactory.getLog(JKlustor.class);
    public static final String title = "Library MCS";
    public static final String version = VersionInfo.JCHEM_VERSION;
    protected static CmdLine cmdLine = null;
    protected static int mode = 1;
    protected static int[] properties = null;
    protected static String data = null;
    private LibraryMCS libMCS = null;
    private MGraph workGraph = null;
    private JKMenuBar mainMenuBar;
    private JKToolBar toolBar;
    private ClusterViewer clusterViewer;
    private JKlustorImport dataImporter;
    private JKlustorExport dataExporter;
    JKlustorActions actionHandler;
    private Dimension preferredSize = new Dimension(800, 615);
    private int defaultViewerMode = 2;

    public JKlustor(JApplet applet) {
        this.init();
        applet.getContentPane().add((Component)this.clusterViewer, "Center");
        this.dataImporter.setProgressPanel(this.clusterViewer.getProgressPanel());
        this.createMenubar(applet);
        this.createToolbar(applet);
        this.setClusterViewerModeToDefault();
    }

    public JKlustor(JFrame frame) {
        JKlustor.setIconImage(frame);
        this.init();
        frame.getContentPane().add((Component)this.clusterViewer, "Center");
        this.dataImporter.setProgressPanel(this.clusterViewer.getProgressPanel());
        this.createMenubar(frame);
        this.createToolbar(frame);
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JKlustor.this.actionHandler.invokeExitAction();
            }
        });
        frame.pack();
        this.setClusterViewerModeToDefault();
    }

    public void onRemove() {
        this.clusterViewer.onRemove();
        this.clusterViewer = null;
        this.workGraph = null;
        this.dataImporter = null;
    }

    public void importStructures(String fileName) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("importStructures( \"" + fileName + "\" )"));
        }
        this.dataImporter.importStructures(fileName);
        this.setClusterViewerModeToDefault();
    }

    public void importStructures(String fileName, int[] selectedProperties) throws Exception {
        this.dataImporter.importStructures(fileName, selectedProperties);
        this.setClusterViewerModeToDefault();
    }

    public void importStructures(InputStream is) throws Exception {
        this.dataImporter.importStructures(is);
        this.setClusterViewerModeToDefault();
    }

    public void importStructures(InputStream is, int[] selectedProperties) throws Exception {
        this.dataImporter.importStructures(is, selectedProperties);
        this.setClusterViewerModeToDefault();
    }

    public void addStructures(String fileName) throws Exception {
        this.dataImporter.addStructures(fileName);
        this.setClusterViewerModeToDefault();
    }

    public boolean isMViewMode() {
        if (this.clusterViewer != null) {
            return this.clusterViewer.isMViewMode();
        }
        return this.defaultViewerMode == 1;
    }

    public boolean isRGroupMode() {
        if (this.clusterViewer != null) {
            return this.clusterViewer.isRGroupMode();
        }
        return this.defaultViewerMode == 3;
    }

    public boolean isTreeTableMode() {
        if (this.clusterViewer != null) {
            return this.clusterViewer.isTreeTableMode();
        }
        return this.defaultViewerMode == 2;
    }

    public void setClusterViewerModeToDefault() {
        switch (this.defaultViewerMode) {
            case 1: {
                this.setMViewMode();
                break;
            }
            case 3: {
                this.setRGroupMode();
                break;
            }
            case 2: {
                this.setTreeTableMode();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid default view mode");
            }
        }
    }

    public void setMViewMode() {
        if (this.clusterViewer != null) {
            this.clusterViewer.setMViewMode();
        }
        if (this.toolBar != null) {
            this.toolBar.update();
        }
    }

    public void setRGroupMode() {
        if (this.clusterViewer != null) {
            this.clusterViewer.setRGroupMode();
        }
        if (this.toolBar != null) {
            this.toolBar.update();
        }
    }

    public void setTreeTableMode() {
        if (this.clusterViewer != null) {
            this.clusterViewer.setTreeTableMode();
        }
        if (this.toolBar != null) {
            this.toolBar.update();
        }
    }

    public void clustering() {
        this.dataImporter.resetLibMCS();
        this.dataImporter.calculateLibMCS();
    }

    public void levelClustering() {
        this.dataImporter.levelClustering();
        if (this.clusterViewer != null) {
            this.clusterViewer.updateStructure();
        }
    }

    public void showReport() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JKlustor.this.dataImporter.showReport();
            }
        });
    }

    public static void setIconImage(JFrame frame) {
        try {
            URL u = JKlustor.class.getResource("icons/jklustor16.png");
            if (u != null) {
                Image img = Toolkit.getDefaultToolkit().createImage((ImageProducer)u.getContent());
                frame.setIconImage(img);
            } else {
                System.out.println("URL not found: " + u);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ClusterViewer getClusterViewer() {
        return this.clusterViewer;
    }

    public void showDefaultGraph() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"showDefaultGraph()");
        }
        try {
            this.dataImporter.importStructures("chemaxon/clustering/data/SC1000.sdf", new int[]{1, 2, 3, 4});
        }
        catch (Exception e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Exception", (Throwable)e);
            }
            try {
                this.setGraph(this.dataImporter.createDefaultTestGraph());
            }
            catch (Exception e2) {
                e.printStackTrace();
                e2.printStackTrace();
            }
        }
        this.setClusterViewerModeToDefault();
    }

    public JKlustorImport getDataImporter() {
        return this.dataImporter;
    }

    public JKlustorExport getDataExporter() {
        return this.dataExporter;
    }

    public JKlustorActions getActionHandler() {
        return this.actionHandler;
    }

    public LibraryMCS getLibMCS() {
        return this.libMCS;
    }

    public void setLibMCS(LibraryMCS libMCS) {
        this.libMCS = libMCS;
    }

    public void setGraph(MGraph g) {
        this.workGraph = g;
        this.clusterViewer.setGraph(g);
    }

    public MGraph getGraph() {
        return this.workGraph;
    }

    public void handleError(Throwable t) {
        this.actionHandler.handleErrors(t);
    }

    private void init() {
        this.clusterViewer = new ClusterViewer();
        this.clusterViewer.setPreferredSize(this.preferredSize);
        this.dataImporter = new JKlustorImport(this);
        this.dataImporter.setMode(mode);
        this.dataExporter = new JKlustorExport();
        this.actionHandler = new JKlustorActions(this);
    }

    private void createToolbar(JFrame mainFrame) {
        this.toolBar = new JKToolBar(this);
        mainFrame.getContentPane().add((Component)this.toolBar, "First");
    }

    private void createToolbar(JApplet mainApplet) {
        this.toolBar = new JKToolBar(this);
        mainApplet.getContentPane().add((Component)this.toolBar, "First");
    }

    private void createMenubar(JFrame mainFrame) {
        this.mainMenuBar = new JKMenuBar(this, false);
        mainFrame.setJMenuBar(this.mainMenuBar);
    }

    private void createMenubar(JApplet mainApplet) {
        this.mainMenuBar = new JKMenuBar(this, true);
        mainApplet.setJMenuBar(this.mainMenuBar);
    }

    public static void main(String[] args) {
        Log log;
        block8: {
            log = LogFactory.getLog(JKlustor.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)"main()");
            }
            if (UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block8;
                    log.error((Object)e);
                }
            }
        }
        try {
            LicenseHandler.getInstance().checkLicense("JKlustor");
        }
        catch (LicenseException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JPanel panel = LicenseManager.getLicenseExceptionPanel(e);
                    JOptionPane.showOptionDialog(null, panel, "Error", -1, 0, null, null, null);
                }
            });
            return;
        }
        if (args != null && args.length > 0) {
            data = args[0];
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame mainFrame = new JFrame("Library MCS " + version);
                final JKlustor jKlustor = new JKlustor(mainFrame);
                mainFrame.setLocationRelativeTo(null);
                mainFrame.setVisible(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (data != null) {
                                jKlustor.importStructures(data, properties);
                            } else {
                                jKlustor.showDefaultGraph();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }
}

