/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui;

import chemaxon.clustering.gui.JKlustor;
import chemaxon.clustering.gui.action.ClusterAction;
import chemaxon.clustering.gui.action.ExitAction;
import chemaxon.clustering.gui.action.ExportAction;
import chemaxon.clustering.gui.action.ExportGraphAction;
import chemaxon.clustering.gui.action.ImportAction;
import chemaxon.clustering.gui.action.ImportGraphAction;
import chemaxon.clustering.gui.action.LevelClusteringAction;
import chemaxon.clustering.gui.action.LicenseAction;
import chemaxon.clustering.gui.action.MViewAction;
import chemaxon.clustering.gui.action.OptionsAction;
import chemaxon.clustering.gui.action.RGroupAction;
import chemaxon.clustering.gui.action.ReportAction;
import chemaxon.clustering.gui.action.TreeTableAction;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class JKlustorActions {
    JKlustor jKlustor;
    Action importAction;
    Action exportAction;
    Action importGraphAction;
    Action exportGraphAction;
    Action exitAction;
    Action reportAction;
    Action optionsAction;
    Action clusterAction;
    Action levelClusteringAction;
    Action mviewAction;
    Action rtableAction;
    Action treeTableAction;
    Action licenseAction;
    ActionEvent event;

    public JKlustorActions(JKlustor jklustor) {
        this.jKlustor = jklustor;
        this.event = new ActionEvent(jklustor, 0, "");
        this.createActions();
    }

    public void invokeImportAction() {
        this.importAction.actionPerformed(this.event);
    }

    public void invokeExportAction() {
        this.exportAction.actionPerformed(this.event);
    }

    public void invokeImportGraphAction() {
        this.importGraphAction.actionPerformed(this.event);
    }

    public void invokeExportGraphAction() {
        this.exportGraphAction.actionPerformed(this.event);
    }

    public void invokeExitAction() {
        this.exitAction.actionPerformed(this.event);
    }

    private void createActions() {
        this.exitAction = new ExitAction(this.jKlustor);
        this.importAction = new ImportAction(this.jKlustor);
        this.exportAction = new ExportAction(this.jKlustor);
        this.importGraphAction = new ImportGraphAction(this.jKlustor);
        this.exportGraphAction = new ExportGraphAction(this.jKlustor);
        this.reportAction = new ReportAction(this.jKlustor);
        this.optionsAction = new OptionsAction(this.jKlustor);
        this.clusterAction = new ClusterAction(this.jKlustor);
        this.levelClusteringAction = new LevelClusteringAction(this.jKlustor);
        this.mviewAction = new MViewAction(this.jKlustor);
        this.rtableAction = new RGroupAction(this.jKlustor);
        this.treeTableAction = new TreeTableAction(this.jKlustor);
        this.licenseAction = new LicenseAction(this.jKlustor);
    }

    public void handleErrors(Throwable t) {
        t.printStackTrace();
        JOptionPane.showMessageDialog(this.jKlustor.getClusterViewer(), t.getMessage());
    }

    public static void addFileFilter(JFileChooser chooser, final String ext, final String desc) {
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f != null) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String fileName = f.getName().toLowerCase();
                    if (fileName.endsWith(ext)) {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public String getDescription() {
                return desc;
            }
        });
    }
}

