/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui;

import chemaxon.clustering.MBaseNode;
import chemaxon.clustering.MGraph;
import chemaxon.clustering.MLevelEnumeration;
import chemaxon.formats.MolExporter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Vector;

public class JKlustorExport {
    public static final int SMILES_FORMAT = 0;
    public static final int SDF_FORMAT = 1;
    public static final int DOT_FORMAT = 2;
    public static final int GRAPH_FORMAT = 3;
    private boolean exportMarkedOnly = false;
    private boolean exportElementCount = false;
    private boolean exportParentID = false;

    public void setExportOptions(boolean markedOnly, boolean elementCount, boolean parentID) {
        this.exportMarkedOnly = markedOnly;
        this.exportElementCount = elementCount;
        this.exportParentID = parentID;
    }

    public void export(MGraph graph, int format2, OutputStream out) throws IOException {
        switch (format2) {
            case 0: {
                this.exportToSmiles(graph, out);
                break;
            }
            case 1: {
                this.exportToSDF(graph, out);
                break;
            }
            case 2: {
                this.exportToDot(graph, out);
                break;
            }
            case 3: {
                this.exportToGraph(graph, out);
            }
        }
    }

    public void exportToSmiles(MGraph graph, OutputStream out) throws IOException {
    }

    public void exportToSDF(MGraph graph, OutputStream out) throws IOException {
        BufferedOutputStream bo = new BufferedOutputStream(out);
        MolExporter molExporter = new MolExporter(bo, "sdf");
        for (int i = 1; i <= graph.getDepth(); ++i) {
            MLevelEnumeration levelEnum = new MLevelEnumeration(graph, i);
            while (levelEnum.hasMoreElements()) {
                MBaseNode next = levelEnum.nextNode();
                if (next.isHidden() || this.exportMarkedOnly && !next.isMarked()) continue;
                if (next.hasChildren()) {
                    next.setProperty("ClusterID", String.valueOf(next.getID()));
                    if (this.exportElementCount) {
                        next.setProperty("ElementCount", String.valueOf(next.visibleChildCount()));
                    }
                }
                if (i > 1 && this.exportParentID) {
                    next.setProperty("ParentID", String.valueOf(next.getParent().getID()));
                }
                next.convertPropertiesToStringProperties();
                molExporter.write(next.getMoleculeWithProperty());
            }
        }
        molExporter.close();
        bo.close();
    }

    public void exportToDot(MGraph graph, OutputStream out) throws IOException {
    }

    public void exportToGraph(MGraph graph, OutputStream os) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(os);
        out.writeByte(1);
        out.writeInt(graph.getNextClusterID());
        String[] propertyKeys = graph.getPropertyKeys();
        int[] propertyTypes = graph.getPropertyTypes();
        out.writeInt(propertyKeys == null ? 0 : propertyKeys.length);
        if (propertyKeys != null) {
            for (int i = 0; i < propertyKeys.length; ++i) {
                out.writeObject(propertyKeys[i]);
                out.writeInt(propertyTypes[i]);
            }
        }
        Vector multiNodes = new Vector(10, 10);
        this.exportNodeDataToGraph(graph.getRootNode(), out, multiNodes, new Integer(0));
        out.flush();
        out.close();
    }

    private void exportNodeDataToGraph(MBaseNode node, ObjectOutputStream out, Vector multiNodes, Integer multiNodeSerial) throws IOException {
        node.saveNodeData(out, multiNodes, multiNodeSerial);
        out.writeInt(node.getColor());
        out.writeBoolean(node.isHidden());
        out.writeInt(node.getID());
        out.writeBoolean(node.isMarked());
        if (node.getContent() != null) {
            out.writeObject(node.getContent());
        }
        int childCount = node.getChildCount();
        out.writeInt(childCount);
        for (int i = 0; i < childCount; ++i) {
            MBaseNode child = node.getChild(i);
            out.writeObject(child.getClass());
            this.exportNodeDataToGraph(child, out, multiNodes, multiNodeSerial);
        }
    }
}

