/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui;

import chemaxon.clustering.gui.JKlustorDialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ReportDialog
extends JKlustorDialog {
    private String terminationGroup = "Termination information";
    private String structureGroup = "Structure information";
    private String clusteringGroup = "Clustering information";
    private String importedS = "Input structure file:";
    private String importedCountS = "Number of input structures:";
    private String runningS = "Clustering time:";
    private String levelCountS = "Level count:";
    private String clusterCountS = "Top level cluster count:";
    private String totalClusterCountS = "Total custer count:";
    private JTextField termination;
    private JTextField imported;
    private JTextField importedCount;
    private JTextField running;
    private JTextField levelCount;
    private JTextField clusterCount;
    private JTextField totalClusterCount;
    Dimension labelSize = new Dimension(200, 25);
    Dimension tfSize = new Dimension(200, 25);

    public ReportDialog(JPanel owner) {
        super(owner);
        this.setTitle("Clustering Report");
        this.initGUI();
    }

    private void initGUI() {
        this.termination = new JTextField(" ");
        this.termination.setEditable(false);
        this.termination.setPreferredSize(new Dimension(200, 25));
        this.imported = new JTextField(" ");
        this.setTextField(this.imported);
        this.importedCount = new JTextField(" ");
        this.setTextField(this.importedCount);
        this.running = new JTextField(" ");
        this.setTextField(this.running);
        this.levelCount = new JTextField(" ");
        this.setTextField(this.levelCount);
        this.clusterCount = new JTextField(" ");
        this.setTextField(this.clusterCount);
        this.totalClusterCount = new JTextField(" ");
        this.setTextField(this.totalClusterCount);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportDialog.this.setVisible(false);
            }
        });
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(okButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 9, 9));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.createTerminationPanel());
        mainPanel.add(Box.createVerticalStrut(11));
        mainPanel.add(this.createStructurePanel());
        mainPanel.add(Box.createVerticalStrut(11));
        mainPanel.add(this.createClusteringPanel());
        mainPanel.add(Box.createVerticalStrut(17));
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
        this.getRootPane().setDefaultButton(okButton);
        okButton.setFocusPainted(true);
        okButton.requestFocus();
        this.setLocationRelativeTo(this.owner);
    }

    private void setTextField(JTextField t) {
        t.setEditable(false);
        t.setPreferredSize(this.tfSize);
        t.setHorizontalAlignment(4);
    }

    private JPanel createLabelPanel(String s) {
        JPanel xpanel = new JPanel();
        xpanel.setLayout(new BoxLayout(xpanel, 0));
        JLabel label = new JLabel(s);
        label.setFont(label.getFont().deriveFont(1));
        label.setForeground(SystemColor.textHighlightText);
        xpanel.setBackground(SystemColor.textHighlight);
        xpanel.add(label);
        xpanel.add(Box.createHorizontalGlue());
        return xpanel;
    }

    private JPanel createTerminationPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder(this.terminationGroup));
        panel.add(this.termination);
        return panel;
    }

    private JPanel createStructurePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(this.structureGroup));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gbl);
        c.insets = new Insets(0, 0, 5, 0);
        c.anchor = 17;
        JLabel l1 = new JLabel(this.importedS);
        l1.setPreferredSize(this.labelSize);
        gbl.setConstraints(l1, c);
        panel.add(l1);
        c.gridwidth = 0;
        gbl.setConstraints(this.imported, c);
        panel.add(this.imported);
        JLabel l2 = new JLabel(this.importedCountS);
        c.gridwidth = 1;
        gbl.setConstraints(l2, c);
        panel.add(l2);
        c.gridwidth = 0;
        gbl.setConstraints(this.importedCount, c);
        panel.add(this.importedCount);
        return panel;
    }

    private JPanel createClusteringPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(this.clusteringGroup));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gbl);
        c.insets = new Insets(0, 0, 5, 0);
        c.anchor = 17;
        JLabel l1 = new JLabel(this.runningS);
        l1.setPreferredSize(this.labelSize);
        gbl.setConstraints(l1, c);
        panel.add(l1);
        c.gridwidth = 0;
        gbl.setConstraints(this.running, c);
        panel.add(this.running);
        JLabel l2 = new JLabel(this.levelCountS);
        c.gridwidth = 1;
        gbl.setConstraints(l2, c);
        panel.add(l2);
        c.gridwidth = 0;
        gbl.setConstraints(this.levelCount, c);
        panel.add(this.levelCount);
        JLabel l3 = new JLabel(this.clusterCountS);
        c.gridwidth = 1;
        gbl.setConstraints(l3, c);
        panel.add(l3);
        c.gridwidth = 0;
        gbl.setConstraints(this.clusterCount, c);
        panel.add(this.clusterCount);
        JLabel l4 = new JLabel(this.totalClusterCountS);
        c.gridwidth = 1;
        gbl.setConstraints(l4, c);
        panel.add(l4);
        c.gridwidth = 0;
        gbl.setConstraints(this.totalClusterCount, c);
        panel.add(this.totalClusterCount);
        return panel;
    }

    public void setTerminationCause(String s) {
        this.termination.setText(s);
    }

    public void setImportedStructures(String s) {
        this.imported.setText(s);
    }

    public void setImportedStructureCount(String s) {
        this.importedCount.setText(s);
    }

    public void setRunningTime(String s) {
        this.running.setText(s);
    }

    public void setLevelCount(String s) {
        this.levelCount.setText(s);
    }

    public void setTopLevelClusterCount(String s) {
        this.clusterCount.setText(s);
    }

    public void setTotalClusterCount(String s) {
        this.totalClusterCount.setText(s);
    }
}

