/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.action;

import chemaxon.clustering.LibraryMCS;
import chemaxon.clustering.gui.JKlustor;
import chemaxon.clustering.gui.JKlustorActions;
import chemaxon.clustering.gui.JKlustorDialog;
import chemaxon.formats.MolExporter;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class ExportAction
extends AbstractAction {
    private static final int SDF_FILE = 1;
    private static final int SMILES_FILE = 2;
    private static final int DOT_FILE = 3;
    private static final int OTHER_FILE = 4;
    private JFileChooser exportFileChooser;
    JRadioButton saveAll;
    JRadioButton saveBottom;
    JRadioButton saveSelected;
    JRadioButton saveExtended;
    private JDialog parameterDialog = null;
    private JTextField locationTF;
    private JCheckBox saveIdentifier;
    private JCheckBox saveParentID;
    private JCheckBox saveParentSmiles;
    private JCheckBox saveElementCount;
    private int exportType = 1;
    private File outputFile = null;
    private JKlustor jKlustor;

    public ExportAction(JKlustor jKlustor) {
        this.jKlustor = jKlustor;
        ImageIcon exportIcon = new ImageIcon(JKlustor.class.getResource("icons/save.png"));
        this.putValue("Name", "Save as...");
        this.putValue("SmallIcon", exportIcon);
        this.putValue("ShortDescription", "Save Structures");
        this.putValue("ActionCommandKey", "Export");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
    }

    private void initFileChooser() {
        this.exportFileChooser = new JFileChooser();
        this.exportFileChooser.setDialogTitle("Library MCS: Save Structures");
        this.exportFileChooser.setMultiSelectionEnabled(false);
        JKlustorActions.addFileFilter(this.exportFileChooser, "dot", "Graphviz/dot files (*.dot)");
        this.exportFileChooser.addChoosableFileFilter(new MolFileFilter("smiles"));
        this.exportFileChooser.addChoosableFileFilter(new MolFileFilter("sdf"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.parameterDialog == null) {
                this.initParameterDialog();
                this.initFileChooser();
            }
            if (e.getActionCommand().equals("Browse")) {
                int i = this.exportFileChooser.showSaveDialog(this.parameterDialog);
                if (i == 0) {
                    int type = this.getFileType(this.exportFileChooser.getFileFilter());
                    this.outputFile = this.checkFileExtension(this.exportFileChooser.getSelectedFile(), type);
                    this.parameterDialog.requestFocus();
                    switch (type) {
                        case 3: {
                            this.exportType = 3;
                            break;
                        }
                        case 1: {
                            this.exportType = 1;
                            break;
                        }
                        case 2: {
                            this.exportType = 2;
                            break;
                        }
                        default: {
                            this.exportType = 4;
                        }
                    }
                    this.locationTF.setText(this.outputFile.getCanonicalPath());
                    this.updateFieldsOnType();
                } else {
                    this.parameterDialog.requestFocus();
                }
                return;
            }
            if (e.getActionCommand().equals("OK")) {
                if (!this.overWriteCheck(this.outputFile)) {
                    this.parameterDialog.requestFocus();
                    return;
                }
                switch (this.exportType) {
                    case 3: {
                        this.exportToDot(this.outputFile);
                        break;
                    }
                    case 1: {
                        this.exportToSDF(this.outputFile, this.saveParentID.isSelected(), this.saveElementCount.isSelected());
                        break;
                    }
                    case 2: {
                        this.exportToSmiles(this.outputFile, this.saveSelected.isSelected(), this.saveParentSmiles.isSelected(), this.saveIdentifier.isSelected(), this.saveParentID.isSelected(), this.saveElementCount.isSelected());
                    }
                }
                this.parameterDialog.setVisible(false);
                return;
            }
            if (e.getActionCommand().equals("Cancel")) {
                this.parameterDialog.setVisible(false);
                return;
            }
            this.updateContentGroup();
            this.parameterDialog.setVisible(true);
        }
        catch (Exception ex) {
            this.jKlustor.handleError(ex);
        }
    }

    private void initParameterDialog() {
        JPanel contentPanel = new JPanel();
        JLabel title3 = new JLabel();
        this.locationTF = new JTextField();
        title3.setText("Location:");
        JButton button1 = new JButton();
        button1.setText("Browse...");
        button1.setActionCommand("Browse");
        button1.addActionListener(this);
        JLabel title2 = new JLabel();
        title2.setText("Content:");
        this.saveAll = new JRadioButton("All nodes", true);
        this.saveBottom = new JRadioButton("Input structures only");
        this.saveSelected = new JRadioButton("Selection");
        this.saveExtended = new JRadioButton("Selection with input structures");
        ButtonGroup selgr = new ButtonGroup();
        selgr.add(this.saveAll);
        selgr.add(this.saveBottom);
        selgr.add(this.saveSelected);
        selgr.add(this.saveExtended);
        JLabel title1 = new JLabel();
        title1.setText("Additional Fields:");
        this.saveIdentifier = new JCheckBox("Identifier");
        this.saveParentID = new JCheckBox("Parent identifier");
        this.saveParentSmiles = new JCheckBox("Parent smiles");
        this.saveElementCount = new JCheckBox("Element count of cluster");
        contentPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)contentPanel.getLayout()).columnWidths = new int[]{11, 0, 5, 0, 11, 0, 5, 0, 0};
        ((GridBagLayout)contentPanel.getLayout()).rowHeights = new int[]{0, 11, 0, 5, 0, 5, 0, 5, 0, 5, 0, 5, 0};
        ((GridBagLayout)contentPanel.getLayout()).columnWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)contentPanel.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        Insets zi = new Insets(0, 0, 0, 0);
        contentPanel.add((Component)title3, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)this.locationTF, new GridBagConstraints(3, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)button1, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)title2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)this.saveAll, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)this.saveBottom, new GridBagConstraints(1, 6, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)this.saveSelected, new GridBagConstraints(1, 8, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)this.saveExtended, new GridBagConstraints(1, 10, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)title1, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)this.saveIdentifier, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)this.saveParentID, new GridBagConstraints(5, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)this.saveParentSmiles, new GridBagConstraints(5, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)this.saveElementCount, new GridBagConstraints(5, 10, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel dialogPane = new JPanel();
        dialogPane.setBorder(new EmptyBorder(8, 8, 8, 8));
        dialogPane.setLayout(new BorderLayout());
        dialogPane.add((Component)contentPanel, "Center");
        JPanel buttonBar = this.createButtonBar();
        dialogPane.add((Component)buttonBar, "South");
        this.parameterDialog = new JKlustorDialog(this.jKlustor.getClusterViewer());
        this.parameterDialog.setTitle("Export Data");
        this.parameterDialog.getContentPane().setLayout(new BorderLayout());
        this.parameterDialog.getContentPane().add(dialogPane);
        this.parameterDialog.pack();
        this.parameterDialog.setLocationRelativeTo(this.jKlustor.getClusterViewer());
        this.parameterDialog.setResizable(false);
    }

    private JPanel createButtonBar() {
        JPanel buttonBar = new JPanel();
        buttonBar.setBorder(new EmptyBorder(17, 0, 0, 0));
        buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)buttonBar.getLayout()).columnWidths = new int[]{0, 75, 6, 75, 0};
        ((GridBagLayout)buttonBar.getLayout()).rowHeights = new int[]{0, 0};
        ((GridBagLayout)buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)buttonBar.getLayout()).rowWeights = new double[]{0.0, 1.0E-4};
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("OK");
        okButton.addActionListener(this);
        buttonBar.add((Component)okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        buttonBar.add((Component)cancelButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return buttonBar;
    }

    private void updateContentGroup() {
        boolean b = this.jKlustor.getGraph().getMarkedNodeCount() == 0;
        this.saveAll.setSelected(b);
        this.saveSelected.setSelected(!b);
        this.saveSelected.setEnabled(!b);
        this.saveExtended.setEnabled(!b);
    }

    private void updateFieldsOnType() {
        boolean b = this.exportType != 3;
        this.saveIdentifier.setEnabled(b);
        this.saveParentID.setEnabled(b);
        this.saveParentSmiles.setEnabled(b);
        this.saveElementCount.setEnabled(b);
        this.saveBottom.setEnabled(false);
        if (this.exportType == 1) {
            this.saveIdentifier.setEnabled(false);
            this.saveParentSmiles.setEnabled(false);
            this.saveBottom.setEnabled(true);
        }
        if (this.exportType != 1) {
            if (this.saveExtended.isSelected()) {
                this.saveSelected.setSelected(true);
            }
            this.saveExtended.setEnabled(false);
        }
    }

    private boolean overWriteCheck(File f) {
        return !f.exists() || 1 != JOptionPane.showOptionDialog(this.jKlustor.getClusterViewer(), "Overwrite selected file?", "File exists", 0, 3, null, null, null);
    }

    private int getFileType(FileFilter filter) {
        String desc = filter.getDescription();
        if (desc.indexOf("*.sdf") > -1) {
            return 1;
        }
        if (desc.indexOf("*.smiles") > -1) {
            return 2;
        }
        if (desc.indexOf("*.dot") > -1) {
            return 3;
        }
        return 4;
    }

    private File checkFileExtension(File f, int type) throws Exception {
        String ext;
        String saveFileName = f.getName();
        switch (type) {
            case 2: {
                ext = ".smiles";
                break;
            }
            case 3: {
                ext = ".dot";
                break;
            }
            default: {
                ext = ".sdf";
            }
        }
        if (!saveFileName.endsWith(ext)) {
            f = new File(f.getCanonicalPath() + ext);
        }
        return f;
    }

    private void exportToSDF(File f, boolean saveParent, boolean saveElementCount) throws Exception {
        FileOutputStream fo = new FileOutputStream(f);
        BufferedOutputStream bo = new BufferedOutputStream(fo);
        MolExporter molExporter = new MolExporter(bo, "sdf");
        LibraryMCS.ClusterEnumerator enumerator = this.jKlustor.getLibMCS().getClusterEnumerator(this.saveBottom.isSelected(), this.saveSelected.isSelected());
        while (enumerator.hasNext()) {
            Molecule mol = (Molecule)enumerator.next().clone();
            mol.setProperty("RG", null);
            if (mol.getProperty("ClusterID") != null) {
                mol.setProperty("ID", null);
            }
            if (!saveParent) {
                mol.setProperty("ParentID", null);
            }
            if (!saveElementCount) {
                mol.setProperty("ElementCount", null);
            }
            molExporter.write(mol);
        }
        molExporter.close();
        bo.close();
        fo.close();
    }

    private void exportToSmiles(File f, boolean saveSelectedOnly, boolean saveParent, boolean saveID, boolean saveParentID, boolean saveElementCount) throws Exception {
        FileOutputStream fo = new FileOutputStream(f);
        BufferedOutputStream bo = new BufferedOutputStream(fo);
        this.jKlustor.getGraph().saveSmiles(bo, saveSelectedOnly, saveParent, saveID, saveParentID, saveElementCount);
        bo.flush();
        bo.close();
    }

    private void exportToDot(File f) throws Exception {
        FileOutputStream fo = new FileOutputStream(f);
        BufferedOutputStream bo = new BufferedOutputStream(fo);
        this.jKlustor.getGraph().saveDotFormat(bo);
        bo.flush();
        bo.close();
        fo.close();
    }
}

